import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import{I18NMixin as o}from"../../i18n-manager/lib/I18NMixin.js";import"../../simple-tooltip/simple-tooltip.js";class MapMenuHeader extends(o(e)){static get styles(){return[i`
        :host {
          display: block;
          position: relative;
          transition: 0.3s ease-in all;
        }

        :host([hovered]) {
          opacity: 0.8;
        }
        :host(:hover),
        :host(:focus) {
          opacity: 1;
        }

        a,
        a:visited {
          display: block;
          color: var(--map-menu-item-a-color, inherit);
          text-decoration: var(--map-menu-header-a-text-decoration, none);
          transition: background-color 0.3s ease;
          background-color: transparent;
        }

        :host([active]) button {
          color: var(
            --map-menu-item-a-active-color,
            var(--map-menu-item-a-color, inherit)
          );
          font-weight: var(--map-menu-item-button-active-font-weight, bold);
          text-decoration: var(--map-menu-active-item-text-decoration, var(--map-menu-header-a-text-decoration-hover, none));
          background-color: var(--map-menu-item-a-active-background-color);
          border-radius: var(--map-menu-item-border-radius, 4px);
        }
        :host([hovered]) button,
        a:hover button,
        a:focus-within button,
        a:focus button {
          color: var(
            --map-menu-item-a-active-color,
            var(--map-menu-item-a-color, inherit)
          );
          text-decoration: var(--map-menu-header-a-text-decoration-hover, none);
          background-color: var(--map-menu-item-a-active-background-color);
          border-radius: var(--map-menu-item-border-radius, 4px);
        }

        #link {
          display: flex;
          justify-content: flex-start;
          align-items: flex-start;
          flex-direction: column;
        }

        :host([hovered]) simple-icon-lite,
        :host(:hover) simple-icon-lite,
        :host(:focus-within) simple-icon-lite,
        :host(:focus) simple-icon-lite {
          visibility: none;
          opacity: 0;
          pointer-events: none;
        }

        simple-icon-lite {
          color: inherit;
          margin-left: 4px;
          display: inline-flex;
          --simple-icon-height: var(--map-menu-item-icon-height);
          --simple-icon-width: var(--map-menu-item-icon-height);
        }

        .title {
          text-transform: var(--map-menu-text-transform, none);
          font-size: var(--map-menu-font-size);
          font-weight: var(--map-menu-font-weight);
          text-overflow: ellipsis;
          vertical-align: middle;
          max-width: 240px;
          margin-left: var(--map-menu-header-title-margin, 8px);
          white-space: nowrap;
          overflow: hidden;
          word-break: break-all;
        }

        button {
          transition: 0.1s ease-in all;
          cursor: pointer;
          font-family: inherit;
          color: inherit;
          display: flex;
          background-color: transparent;
          text-transform: none;
          width: 100%;
          justify-content: left;
          margin: 0;
          border: 0px;
          padding: var(--map-menu-header-button-padding, 10px 20px);
          text-align: left;
          border-radius: 0px;
          vertical-align: middle;
          line-height: var(
            --map-menu-item-button-height,
            var(--map-menu-item-height)
          );
        }
        :host([status="new"]) a::after {
          border-right: 8px solid green;
          content: "";
          margin-left: -8px;
        }
        :host([status="modified"]) a::after {
          border-right: 8px solid orange;
          content: "";
          margin-left: -8px;
        }
        :host([status="delete"]) a::after {
          border-right: 8px solid red;
          content: "";
          margin-left: -8px;
        }
        #unpublished {
          color: red;
        }
        :host([hide-in-menu]) {
          display: none;
        }
        :host(:not([icon=""])) button {
          padding-left: 0;
          padding: var(--map-menu-header-button-padding);
        }
        .ops {
          position: absolute;
          display: block;
          right: 0px;
          height: 40px;
          top: 0px;
          z-index: 2;
          margin: 0 4px 0 0;
        }
        .ops .op {
          --simple-icon-height: 16px;
          --simple-icon-width: 16px;
          margin: 4px;
          color: var(--map-menu-item-a-active-color, black);
        }
      `]}render(){return t` <a tabindex="-1" href="${this.url}" title="${this.itemtitle}">
        <button>
          ${this.published?"":t`<simple-icon-lite
                id="unpublished"
                title="${this.t.pageIsUnpublished}"
                icon="icons:visibility-off"
              ></simple-icon-lite>`}
          ${this.icon?t`
                <simple-icon-lite
                  icon="${this.icon}"
                  part="icon"
                  id="icon"
                ></simple-icon-lite>
                ${this.iconLabel?t`<simple-tooltip for="icon"
                      >${this.iconLabel}</simple-tooltip
                    >`:""}
              `:""}
          <div class="title">${this.itemtitle}</div>
        </button>
      </a>
      ${this.editControls&&this.active?t` <div class="ops">
            <haxcms-button-add
              class="op"
              type="child"
              label="Add child page"
              action-id="${this.id}"
            ></haxcms-button-add>
          </div>`:""}`}static get tag(){return"map-menu-header"}constructor(){super(),this.editControls=!1,this.iconLabel=null,this.icon=null,this.url="",this.status="",this.opened=!1,this.active=!1,this.published=!0,this.hideInMenu=!1,this.hovered=!1,this.locked=!1,this.itemtitle="",this.t={pageIsUnpublished:"Page is unpublished"},this.registerLocalization({context:this,namespace:"map-menu",localesPath:new URL("../locales/map-menu.es.json",import.meta.url).href+"/../",locales:["es"]}),setTimeout((()=>{this.addEventListener("click",this.__tap.bind(this)),this.addEventListener("keypress",this.__keypress.bind(this))}),0)}updated(e){e.forEach(((e,t)=>{"opened"==t&&void 0!==e&&this._openedChanged(this[t],e),["id","selected"].includes(t)&&this.__selectedChanged(this.selected,this.id)}))}static get properties(){let e={};return super.properties&&(e=super.properties),{...e,opened:{type:Boolean,reflect:!0},itemtitle:{type:String},iconLabel:{type:String,attribute:"icon-label"},editControls:{type:Boolean,attribute:"edit-controls"},url:{type:String},hideInMenu:{type:Boolean,reflect:!0,attribute:"hide-in-menu"},id:{type:String,reflect:!0},icon:{type:String,reflect:!0},active:{type:Boolean,reflect:!0},hovered:{type:Boolean,reflect:!0},published:{type:Boolean,reflect:!0},locked:{type:Boolean},status:{type:String,reflect:!0},selected:{type:String,reflect:!0},__collapseIcon:{type:String},__collapseAria:{type:String}}}_openedChanged(e,t){e?(this.__collapseIcon="icons:expand-more",this.__collapseAria="collapse menu"):(this.__collapseIcon="icons:chevron-right",this.__collapseAria="expand menu")}__selectedChanged(e,t){e===t&&(this.parentNode.expanded||this.dispatchEvent(new CustomEvent("toggle-header",{bubbles:!0,cancelable:!0,composed:!0,detail:!0})),this.dispatchEvent(new CustomEvent("active-item",{bubbles:!0,cancelable:!0,composed:!0,detail:this})))}__tap(e){this.__toggleEventHandler(e)}__keypress(e){"Enter"===e.code&&this.__toggleEventHandler(e)}__toggleEventHandler(e){this.parentNode.expanded||this.dispatchEvent(new CustomEvent("toggle-header",{bubbles:!0,cancelable:!0,composed:!0,detail:!0}))}}customElements.define(MapMenuHeader.tag,MapMenuHeader);export{MapMenuHeader};