/**
 * Inspired by https://github.com/olivernn/lunr.js
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as r}from"../../lit/index.js";import"../es-global-bridge/es-global-bridge.js";class LunrSearch extends t{static get styles(){return[r`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }
      `]}render(){return e` ${this.demo&&this.results?e`${this.results.map((t=>e`<h2>${t.title}</h2>
                <p>${t.description}</p>`))}`:""}
      <slot></slot>`}static get properties(){return{dataSource:{type:String,attribute:"data-source"},__auto:{type:Boolean},data:{type:Array},method:{type:String},search:{type:String},results:{type:Array},noStopWords:{type:Boolean,attribute:"no-stop-words"},fields:{type:Array},indexNoStopWords:{type:Object},index:{type:Object},__lunrLoaded:{type:Boolean},limit:{type:Number},minScore:{type:Number},log:{type:Boolean},demo:{type:Boolean,reflect:!0}}}constructor(){super(),this.windowControllers=new AbortController,this.method="GET",this.noStopWords=!1,this.dataSource=null,this.fields=[],this.limit=500,this.__auto=!1,this.minScore=0,this.log=!1,globalThis.WCGlobalBasePath?this.basePath=globalThis.WCGlobalBasePath:this.basePath=new URL("./lunr-search.js",import.meta.url).href+"/../../../";const t=`${this.basePath}lunr/lunr.js`;globalThis.addEventListener("es-bridge-lunr-loaded",this._lunrLoaded.bind(this),{signal:this.windowControllers.signal}),globalThis.ESGlobalBridge.requestAvailability().load("lunr",t),!0===globalThis.ESGlobalBridge.requestAvailability().imports.lunr&&setTimeout((()=>{this.__lunrLoaded=!0}),0)}updated(t){t.forEach(((t,e)=>{["dataSource","__auto","method"].includes(e)&&this.dataSource&&this.method&&(clearTimeout(this.__debounce),this.__debounce=setTimeout((()=>{fetch(this.dataSource,{method:this.method}).then((t=>{if(t.ok)return t.json()})).then((t=>{this._dataResponse(t)}))}),0));if(["data","search","results","noStopWords"].includes(e)){let t=`${e.replace(/([a-z0-9]|(?=[A-Z]))([A-Z])/g,"$1-$2").toLowerCase()}-changed`;this.dispatchEvent(new CustomEvent(t,{detail:{value:this[e]}}))}"dataSource"==e&&this[e]&&(this.__auto=!0),["data","search","index","minScore","limit"].includes(e)&&(this.results=this.searched(this.data,this.search,this.index,this.minScore,this.limit)),["data","fields","noStopWords","__lunrLoaded"].includes(e)&&(this.index=this._createIndex(this.data,this.fields,this.noStopWords,this.__lunrLoaded))}))}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}_lunrLoaded(t){this.__lunrLoaded=!0,this.windowControllers.abort()}static get tag(){return"lunr-search"}_dataResponse(t){if(t)try{this.data=[...t]}catch(t){console.warn(t)}}searched(t,e,r,i,s){if(t&&r&&e){var o=[];if(""+e!="")for(var n=r.search(e),a=0;a<n.length&&!(a===s||n[a].score<i);a++){let e=t.find((t=>t.id==n[a].ref));o.push(e)}if(0===o.length&&!this.noStopWords&&""+e!=""){this.indexNoStopWords||(this.indexNoStopWords=this._createIndex(t,this.fields,!0,this.__lunrLoaded)),n=this.indexNoStopWords.search(e);for(o=[],a=0;a<n.length&&!(a===s||n[a].score<i);a++){let e=t.find((t=>t.id==n[a].ref));o.push(e)}}return o}}_createIndex(t,e,r,i){if(i){let i=this;if(Array.isArray(t)&&t.length>0){if(Array.isArray(e)&&e.length>0)return lunr((function(){for(var i=0;i<e.length;i++)e[i].charAt(0)===e[i].charAt(0).toUpperCase()?this.field(e[i],{boost:10}):this.field(e[i]);for(i=0;i<t.length;i++){for(var s={id:i},o=0;o<e.length;o++)t[i].hasOwnProperty(e[o])&&null!==t[i][e[o]]&&"function"==typeof t[i][e[o]].toString&&(t[i][e[o]].toString().split(" ").length>2||t[i][e[o]].toString().length<30)?s[e[o]]=t[i][e[o]].toString():s[e[o]]="";this.add(s)}r&&this.pipeline.remove(lunr.stopWordFilter)}));e=[];var s={};return lunr((function(){for(var o=0;o<t.length;o++)for(var n in t[o])"_"!==n.charAt(0)&&!s.hasOwnProperty(n)&&(n.toString().split(" ").length>2||n.toString().length<30)&&(e.push(n),n.charAt(0)===n.charAt(0).toUpperCase()?this.field(n,{boost:10}):this.field(n),s[n]=1);e.length>0&&(i.fields=e);for(var a=0;a<t.length;a++){for(var l={id:a},h=0;h<e.length;h++)t[a].hasOwnProperty(e[h])&&null!==t[a][e[h]]&&"function"==typeof t[a][e[h]].toString&&(t[a][e[h]].toString().split(" ").length>2||t[a][e[h]].toString().length<30)?l[e[h]]=t[a][e[h]].toString():l[e[h]]="";this.add(l)}r&&this.pipeline.remove(lunr.stopWordFilter)}))}}}}customElements.define(LunrSearch.tag,LunrSearch);export{LunrSearch};