/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import{SimpleColors as i}from"../simple-colors/simple-colors.js";import"../responsive-utility/responsive-utility.js";import{normalizeEventPath as n}from"../utils/utils.js";class LrndesignTimeline extends i{static get styles(){return[super.styles,t`
        :host {
          font-size: 14px;
          font-weight: 100;
          line-height: 160%;
          display: block;
          --lrndesign-timeline-color: var(
            --simple-colors-default-theme-grey-8,
            #444
          );
          --lrndesign-timeline-color-print: #000;
          --lrndesign-timeline-background: #f4f4f4;
          --lrndesign-timeline-background-print: #fff;
          --lrndesign-timeline-border: var(
            --simple-colors-default-theme-grey-5,
            #bbb
          );
          --lrndesign-timeline-border-print: var(
            --simple-colors-fixed-theme-grey-5,
            #bbb
          );
          --lrndesign-timeline-accent: #000;
          --lrndesign-timeline-accent-background: #fff;
          --lrndesign-timeline-accent-border: var(
            --simple-colors-default-theme-accent-8,
            #444
          );
          --lrndesign-timeline-header: var(
            --simple-colors-default-theme-accent-1,
            #fff
          );
          --lrndesign-timeline-header-accent: var(
            --simple-colors-default-theme-accent-8,
            #444
          );
          --lrndesign-timeline-accent-print: var(
            --simple-colors-fixed-theme-accent-8,
            #444
          );
        }

        :host([dark]) {
          --lrndesign-timeline-background: #1b1b1b;
        }

        :host([hidden]) {
          display: none;
        }

        ::slotted(section) {
          display: none;
        }

        #timeline {
          display: block;
          border-radius: 3px;
          border: 1px solid var(--lrndesign-timeline-border-print);
          border-left: 3px solid var(--lrndesign-timeline-accent-print);
          background-color: var(--lrndesign-timeline-background-print);
          color: var(--lrndesign-timeline-color-print);
        }

        #events {
          padding: 0;
          width: 100%;
          min-height: 300px;
        }

        .heading {
          margin: 0;
          color: var(--lrndesign-timeline-accent-print);
        }

        .heading h2 {
          font-size: 24px;
          font-weight: 300;
        }

        .heading h2,
        .details,
        .media-outer > div {
          padding: 0 40px;
        }

        .details {
          margin: 15px 0;
        }

        .media-outer > div {
          opacity: 1;
          transition: opacity 0.5s;
        }

        .media-outer > div,
        .media-outer > div * {
          margin: 0 auto;
          max-width: 100%;
          max-height: 260px;
        }
        @media screen {
          #timeline {
            color: var(--lrndesign-timeline-color);
            background-color: var(--lrndesign-accent-background);
            border: 1px solid var(--lrndesign-timeline-border);
            border-left: 3px solid var(--lrndesign-timeline-accent-border);
          }

          :host([dark]) #timeline {
            background-color: var(--lrndesign-timeline-background);
          }

          h2 {
            color: var(--lrndesign-timeline-header-accent);
          }

          :host(:not([timeline-size="xs"])) #timeline {
            background-color: var(--lrndesign-timeline-background);
          }

          :host(:not([timeline-size="xs"])) h2 {
            color: var(--lrndesign-timeline-header-accent);
          }

          :host(:not([timeline-size="xs"])) #events {
            height: 300px;
            position: relative;
            overflow-y: scroll;
          }

          :host(:not([timeline-size="xs"])) .event {
            position: static;
            top: 0;
          }

          :host(:not([timeline-size="xs"])) .event-overview {
            padding: 0;
            position: sticky;
            top: 0;
          }

          :host(:not([timeline-size="xs"])) .heading {
            position: absolute;
            top: 0;
            padding: 10px 0;
            overflow: hidden;
            background-color: transparent;
            width: calc(55% + 30px);
          }

          :host(:not([timeline-size="xs"]))
            .event[has-media][selected]
            .heading {
            z-index: 2;
          }

          :host(:not([timeline-size="xs"])) .event[has-media] .heading:after {
            content: " ";
            z-index: 200;
            position: absolute;
            top: 42px;
            right: 30px;
            width: 0;
            padding: 0;
            border-top: 0px solid transparent;
            border-bottom: 0px solid transparent;
            border-left: 0px solid transparent;
            transition: all 0.3s;
            transition-delay: 0.2s;
          }

          :host(:not([timeline-size="xs"]))
            .event[has-media][selected]
            .heading:after {
            top: 7px;
            right: 0px;
            border-top: 35px solid transparent;
            border-bottom: 35px solid transparent;
            border-left: 35px solid var(--lrndesign-timeline-header-accent);
          }

          :host(:not([timeline-size="xs"])) .heading h2 {
            margin: 7px 48px 0 20px;
            padding: 0 20px;
            line-height: 50px;
            height: 50px;
            background-color: var(--lrndesign-timeline-background);
            color: var(--lrndesign-timeline-header-accent);
          }

          :host(:not([timeline-size="xs"])) .event[selected] .heading h2 {
            background-color: var(--lrndesign-timeline-header-accent);
            color: var(--lrndesign-timeline-header);
          }

          :host(:not([timeline-size="xs"]))
            .event[has-media]
            .heading
            h2:after {
            content: "";
            position: absolute;
            left: calc(100% - 48px);
            top: 17px;
            height: 50px;
            opacity: 0;
            width: 0px;
            transition: opacity 0.3s;
            background-color: var(--lrndesign-timeline-background);
          }

          :host(:not([timeline-size="xs"]))
            .event[has-media][selected]
            .heading
            h2:after {
            width: 13px;
            opacity: 1;
            background-color: var(--lrndesign-timeline-header-accent);
          }

          :host(:not([timeline-size="xs"])) .media-outer {
            display: flex;
            align-items: center;
            position: absolute;
            right: 0;
            width: 45%;
            height: 300px;
          }

          :host(:not([timeline-size="xs"])) .media-outer > div {
            display: flex;
            padding: 20px 20px 20px 50px;
            opacity: 0;
            transition: opacity 0.3s delay 0.3s;
          }

          :host(:not([timeline-size="xs"]))
            .event[selected]
            .media-outer
            > div {
            opacity: 1;
            transition-delay: 0s;
          }

          :host(:not([timeline-size="xs"])) .details {
            padding: 67px 20px 20px;
            margin: 0 20px;
            width: calc(55% - 80px);
            color: var(--lrndesign-timeline-color);
            background-color: var(--lrndesign-timeline-background);
            border: 1px solid var(--lrndesign-timeline-background);
            border-radius: 3px;
            transition: all 0.5s;
          }

          :host(:not([timeline-size="xs"])) .event:last-of-type .details {
            min-height: 180px;
          }

          :host(:not([timeline-size="xs"])) .event[selected] .details {
            color: var(--lrndesign-timeline-accent);
            background-color: var(--lrndesign-timeline-accent-background);
            border: 1px solid var(--lrndesign-timeline-border);
            box-shadow: 0 2px 2px var(--lrndesign-timeline-border);
          }

          :host(:not([timeline-size="xs"]))
            .event:first-of-type[selected]
            .details {
            border-top: 1px solid var(--lrndesign-timeline-background);
          }

          :host(:not([timeline-size="xs"]))
            .event:last-of-type[selected]
            .details {
            border-bottom: 1px solid var(--lrndesign-timeline-background);
          }
        }
      `]}render(){return e` <article>
      <h1 id="title">${this.timelineTitle}</h1>
      <slot></slot>
      <div id="timeline">
        <div id="events" @scroll="${this._checkScroll}">
          ${this.eventsList.map(((t,i)=>e`
              <section
                class="event"
                ?has-media="${t.imagesrc&&""!==t.imagesrc}"
                tabindex="0"
                @focus="${this._setScroll}"
              >
                <div class="event-overview">
                  <div class="heading"><h2>${t.heading}</h2></div>
                  <div class="media-outer">
                    ${t.imagesrc&&""!==t.imagesrc?e`
                          <div>
                            <div>
                              <img
                                alt="${t.imagealt}"
                                src="${t.imagesrc}"
                              />
                            </div>
                          </div>
                        `:""}
                  </div>
                </div>
                <div class="details">${t.details}</div>
              </section>
            `))}
        </div>
      </div>
    </article>`}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Timeline",description:"A timeline of events with images and text",icon:"hax:timeline",color:"indigo",tags:["Instructional","content","Media","timeline","time","event","image","text"],handles:[],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"timelineTitle",title:"Timeline Title",description:"A title for the timeline.",inputMethod:"textfield"},{property:"accentColor",title:"Accent Color",description:"An optional accent color.",inputMethod:"colorpicker"},{property:"dark",title:"Dark Theme",description:"Enable Dark Theme",inputMethod:"boolean"},{slot:"",title:"Timeline Description",description:"Optional text describing the timeline.",inputMethod:"textfield"},{property:"events",title:"Timeline Events",description:"The events in the timeline",inputMethod:"array",itemLabel:"heading",properties:[{property:"heading",title:"Event Heading",description:"The heading for the event.",inputMethod:"textfield"},{property:"details",title:"Event Details",description:"The body text with details for the event.",inputMethod:"textfield"},{property:"imagesrc",title:"Event Image",description:"The path of the image.",inputMethod:"haxupload",noVoiceRecord:!0},{property:"imagealt",title:"Event Image Alt Text",description:"The alt text of the image (for accessibility).",inputMethod:"alt"}]}],advanced:[]},demoSchema:[{tag:"lrndesign-timeline",properties:{events:[{heading:"1855 - Charter",details:"Charter now in effect signed by Governor Pollock, February 22; first Board of Trustees president, Judge Frederick Watts of Carlisle. Site in Centre County selected from nine offered throughout state; 200 acres donated by James Irvin with $10,000 pledge from citizens of Centre and Huntingdon counties.",imagealt:"Propfile illustration of, James Pollock, Governor of Pennsylvania 1855-1858.",imagesrc:"https://upload.wikimedia.org/wikipedia/commons/5/56/James_Pollock_Pennsylvania_Governor.jpg"},{heading:"1856 - Construction of Old Main",details:"Construction of Old Main (the &amp;quot;College Building&amp;quot;) begun; supervised by William G. Waring, who was appointed superintendent to open the school and plan farm, orchards and nursery.",imagealt:"Black and white photo original Old Main in an empty field.",imagesrc:"https://libraries.psu.edu/sites/default/files/migrated/1287768717666.jpg"},{heading:"1874 - The Pennsylvania State College ",details:"School renamed The Pennsylvania State College. "},{heading:"1953 - The Pennsylvania State University",details:"The Pennsylvania State University became official name."}]},content:""}],saveOptions:{unsetAttributes:["colors"]}}}static get properties(){return{...super.properties,events:{type:Array},timelineSize:{type:String,reflect:!0,attribute:"timeline-size",value:"xs",timelineTitle:{type:String,reflect:!0,attribute:"timeline-title"},title:{type:String,attribute:"title"}}}}static get tag(){return"lrndesign-timeline"}constructor(){super(),this.events=[],this.timelineSize="xs",globalThis.ResponsiveUtility.requestAvailability()}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),globalThis.dispatchEvent(new CustomEvent("responsive-element",{detail:{element:this,attribute:"timeline-size",relativeToParent:!0,sm:600,md:900,lg:1200,xl:1600}})),this.updateTimeline(),this.observer.observe(this,{childList:!0,subtree:!1})}disconnectedCallback(){this.observer&&this.observer.disconnect&&this.observer.disconnect(),super.disconnectedCallback&&super.disconnectedCallback()}updated(e){super.updated(e),e.forEach(((e,t)=>{"timelineTitle"===t&&this.title&&!this.timelineTitle&&(this.timelineTitle=this.title)})),this.updateTimeline()}get eventsElement(){return!(!this.shadowRoot||!this.shadowRoot.querySelector("#events"))&&this.shadowRoot.querySelector("#events")}get eventsList(){return("string"==typeof this.events?JSON.parse(this.events):this.events)||[]}get observer(){return new MutationObserver((()=>this.updateTimeline()))}_setScroll(e){var t=n(e)[0];t.parentNode.scroll({top:t.offsetTop,left:0,behavior:"smooth"})}_checkScroll(e){if(this.shadowRoot){let e=this.shadowRoot.querySelectorAll(".event")||[];e.forEach((t=>{let i=t.offsetTop,n=e[0].offsetTop+50+t.parentNode.scrollTop,o=t.offsetTop+t.offsetHeight;n>i&&n<o?t.setAttribute("selected",!0):t.removeAttribute("selected")}))}}updateTimeline(){let e=globalThis.document.querySelectorAll("section")||[];this.eventsList.length<1&&e.length>0&&this.eventsElement&&(this.eventsElement.innerHTML="",e.forEach((e=>{let t=e.cloneNode(!0),i=globalThis.document.createElement("div"),n=i.cloneNode(),o=i.cloneNode(),r=i.cloneNode(),s=t.querySelector(".media")?t.querySelector(".media"):void 0,l=t.querySelector("h1,h2,h3,h4,h5,h6")?t.querySelector("h1,h2,h3,h4,h5,h6"):void 0;if(n.classList.add("event-overview"),l){let e=globalThis.document.createElement("h2");r.appendChild(e),r.classList.add("heading"),e.innerHTML=l.innerHTML,l.remove()}if(n.appendChild(r),s){let e=i.cloneNode(),n=i.cloneNode();e.appendChild(n),i.appendChild(e),n.appendChild(s.cloneNode(!0)),s.remove(),t.setAttribute("has-media",!0)}i.classList.add("media-outer"),n.appendChild(i),Object.keys(t.children||[]).forEach((e=>o.append(t.children[e]))),o.classList.add("details"),t.classList.add("event"),t.appendChild(n),t.appendChild(o),this.eventsElement.appendChild(t)}))),this._checkScroll()}}customElements.define(LrndesignTimeline.tag,LrndesignTimeline);export{LrndesignTimeline};