import{LitElement as t,html as e,css as s}from"../../lit/index.js";class LrndesignImagemap extends t{constructor(){super(),import("../relative-heading/relative-heading.js"),import("./lib/lrndesign-imagemap-hotspot.js"),import("../simple-popover/simple-popover.js")}static get styles(){return[s`
        :host {
          display: block;
        }
        :host #buttons {
          position: absolute;
          left: -999999px;
          top: 0;
          overflow: hidden;
          opacity: 0;
        }

        simple-popover {
          max-width: var(--lrndesign-imagemap-popover-maxWidth, 525px);
          max-height: var(--lrndesign-imagemap-popover-maxHeight, 300px);
        }
        simple-popover[for=""] {
          display: none;
        }
        simple-popover .sub-heading > *:first-child {
          margin: 0 0 10px;
        }

        @media print {
          #svg,
          simple-popover {
            display: none;
          }
        }
      `]}render(){return e`
      <figure id="figure">
        <figcaption>
          <relative-heading
            disable-link
            id="heading"
            parent="${this.parent||this.subtopicOf}"
          >
            ${this.label?e` <h1>${this.label}</h1> `:e` <slot name="heading"></slot> `}
          </relative-heading>
          <div id="desc"><slot name="desc"></slot></div>
          <slot name="source" hidden></slot>
          <div id="buttons"></div>
        </figcaption>
        <slot id="svg" name="svg"></slot>
        <simple-popover
          auto
          ?hidden="${!this.__activeHotspot}"
          position="${this.__activeHotspot?this.__activeHotspot.position:"bottom"}"
          .for="${this.__activeHotspot?this.__activeHotspot.id:void 0}"
        >
          <relative-heading
            disable-link
            class="sub-heading"
            parent="heading"
            id="subheading-${this.__activeHotspot?this.__activeHotspot.id:void 0}"
          >
            <h2>${this.__activeHotspot?this.__activeHotspot.label:""}</h2>
          </relative-heading>
          <slot id="details" name="details"></slot>
        </simple-popover>
      </figure>
      <slot></slot>
    `}static get tag(){return"lrndesign-imagemap"}static get properties(){return{label:{type:String},src:{type:String},hotspotDetails:{type:Array,attribute:"hotspot-details"},subtopicOf:{type:String,reflect:!0,attribute:"subtopic-of"},parent:{type:String,reflect:!0,attribute:"parent"},__activeHotspot:{type:Object}}}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),console.log(this.querySelector("[slot=src]")?this.querySelector("[slot=src]"):this.src),this._fetchSvg(this.querySelector("[slot=src]")?this.querySelector("[slot=src]"):this.src)}_fetchSvg(t){fetch(t).then((t=>t.text())).then((t=>this._getSVGHandler(t)))}_getSVGHandler(t){let e=globalThis.document.createElement("div"),s=[];e.innerHTML=t;let i=e.querySelector("svg");i.slot="svg",this.prepend(i),console.log(this.childNodes),i.setAttribute("aria-labelledBy",this._getInfoNode(i,"title")),i.setAttribute("aria-describedBy",this._getInfoNode(i)),this.hotspotDetails=[],this.querySelectorAll("lrndesign-imagemap-hotspot").forEach((t=>{let e={id:t.hotspotId,print:t,hotspot:i.querySelector(`#${t.hotspotId}`),label:t.label,position:t.position||"bottom",details:globalThis.document.createElement("div")};e.hotspot.classList.add("hotspot"),e.hotspot.setAttribute("role","button"),e.hotspot.setAttribute("controls","figure"),e.hotspot.addEventListener("click",(t=>this.openHotspot(e))),t.childNodes.forEach((t=>{e.details.appendChild(t.cloneNode(!0))})),e.details.slot="details",this.append(e.details),this.hotspotDetails.push(e),s.push(t.hotspotId)})),this.hotspotDetails.forEach((e=>{e.print.loadSvg(t,s)}))}_getInfoNode(t,e="desc"){let s="title"===e?"heading":e,i=t.querySelector(e),o=this.shadowRoot.querySelector(`#${s}`);return i||(i=globalThis.document.createElement(e),t.prepend(i),o&&""!=o.innerHTML&&(i.innerHTML,o.html)),this._getId(i)}_getId(t){let e=t?t.getAttribute("id"):void 0;return e||(e="ss-s-s-s-sss".replace(/s/g,Math.floor(65536*(1+Math.random())).toString(16).substring(1)),t.setAttribute("id",e)),e}openHotspot(t){this.__activeHotspot=void 0,this.hotspotDetails.forEach((e=>{e.id===t.id?(e.hotspot.classList.add("selected"),e.details.style.display="block",this.__activeHotspot=e):(e.hotspot.classList.remove("selected"),e.details.style.display="none")}))}closeHotspot(){this.resetHotspots(),this.__activeHotspot.focus()}resetHotspots(){let t=this.querySelectorAll('.hotspot[role="button"]');for(let e=0;e<t.length;e++)t[e].classList.remove("selected")}}customElements.define(LrndesignImagemap.tag,LrndesignImagemap);export{LrndesignImagemap};