/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../lit/index.js";import{LrndesignChart as o}from"../lrndesign-chart.js";import{SimpleColors as s}from"../../simple-colors/simple-colors.js";class LrndesignPie extends(o(s)){constructor(){super(),this.setProperties()}static get properties(){return{...super.properties,chartPadding:{type:Number},donut:{type:Boolean},donutSolid:{type:Boolean},donutWidth:{type:Number},ignoreEmptyValues:{type:Boolean},labelDirection:{type:String},labelOffset:{type:Number},labelPosition:{type:String,attribute:"label-position",reflect:!0},showLabel:{type:Boolean},startAngle:{type:Number},total:{type:Number}}}static get tag(){return"lrndesign-pie"}static get haxProperties(){let t=super.haxProperties,e=[{property:"donut",title:"Donut",inputMethod:"boolean"},{property:"showLabel",title:"Show Label",inputMethod:"boolean"},{property:"startAngle",title:"Start Angle",inputMethod:"number"},{property:"chartPadding",title:"Padding",inputMethod:"number"},{property:"total",title:"Total",description:"\n            Optional total you can specify. By specifying a total value,\n            the sum of the values in the series must be this total in order\n            to draw a full pie. You can use this parameter to draw only parts\n            of a pie or gauge charts.",inputMethod:"number"},{property:"ignoreEmptyValues",title:"Ignore Empty Values",description:"\n            Empty values will be ignored to avoid drawing \n            unncessary slices and labels.",inputMethod:"boolean"}],i=[{property:"donutWidth",title:"Donut Stroke Width",inputMethod:"number"},{property:"donutSolid",title:"Donut Solid",description:"Draw donut segments as shapes instead of strokes.",inputMethod:"boolean"},{property:"labelDirection",title:"Label Direction",description:"Draw donut segments as shapes instead of strokes.",inputMethod:"select",options:{neutral:"neutral",explode:"explode",implode:"implode"}},{property:"labelOffset",title:"Label Offset",description:"\n            Label position offset from the standard position\n            which is half distance of the radius.\n            This value can be either positive or negative.\n            Positive values will position the label away from the center.",inputMethod:"number"},{property:"labelPosition",title:"Label Position",inputMethod:"select",options:{inside:"inside",outside:"outside",center:"center"}}];return t.gizmo.title="Pie Chart",t.gizmo.icon="editor:pie-chart",t.settings.configure=t.settings.configure.concat(e),t.settings.advanced=t.settings.advanced.concat(i),t}get options(){return{...super.options,startAngle:this.startAngle,chartPadding:this.chartPadding,donut:this.donut,total:this.total,donutSolid:this.donutSolid,donutWidth:this.donutWidth,showLabel:this.showLabel,labelOffset:this.labelOffset,labelPosition:this.labelPosition,labelDirection:this.labelDirection,ignoreEmptyValues:this.ignoreEmptyValues}}setProperties(){super.setProperties(),this.scale="ct-square",this.startAngle=0,this.chartPadding=5,this.donut=!1,this.total=void 0,this.donutSolid=!1,this.donutWidth=20,this.showLabel=!0,this.labelOffset=0,this.labelPosition="inside",this.labelDirection="neutral",this.ignoreEmptyValues=!1,this.type="pie"}}customElements.define(LrndesignPie.tag,LrndesignPie);export{LrndesignPie};