/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../lit/index.js";import{LrndesignChart as o}from"../lrndesign-chart.js";import{SimpleColors as s}from"../../simple-colors/simple-colors.js";class LrndesignLine extends(o(s)){constructor(){super(),this.setProperties()}static get properties(){return{...super.properties,...super.lineBarProperties,areaBase:{attribute:"area-base",type:Number},fullWidth:{attribute:"full-width",type:Boolean},lineSmooth:{attribute:"line-smooth",type:Boolean},showArea:{attribute:"show-area",type:Boolean},showLine:{attribute:"show-line",type:Boolean},showPoint:{attribute:"show-point",type:Boolean},showPointLabels:{attribute:"show-point-labels",type:Boolean},pointLabelsAnchor:{attribute:"point-labels-anchor",type:String},pointLabelsOffsetX:{attribute:"point-labels-offset-x",type:Number},pointLabelsOffsetY:{attribute:"point-labels-offset-y",type:Number},pointLabelFunction:{}}}static get tag(){return"lrndesign-line"}static get haxProperties(){let t=super.haxProperties,e=super.lineBarHaxProperties,i=[{property:"pointLabelsAnchor",title:"Show Point Labels",inputMethod:"select",options:{middle:"Middle",start:"Start",end:"End"}},{property:"pointLabelsOffsetX",title:"Point Labels X-Offset",inputMethod:"number"},{property:"pointLabelsOffsetY",title:"Point Labels Y-Offset",inputMethod:"number"},{property:"lineSmooth",title:"Line Smooth",inputMethod:"boolean"},{property:"areaBase",title:"Area Base",description:"\n            The base for the area chart that will be used\n            to close the area shape (is normally 0).\n          ",inputMethod:"number"}];return t.gizmo.title="Link Chart",t.gizmo.icon="editor:show-chart",t.settings.configure=t.settings.configure.concat(e.gridBackground,[{property:"showArea",title:"Show Area",inputMethod:"boolean"},{property:"showLine",title:"Show Link",inputMethod:"boolean"},{property:"showPoint",title:"Show Point",inputMethod:"boolean"},{property:"fullWidth",title:"Full Width",inputMethod:"boolean"},{property:"showPointLabels",title:"Show Point Labels",inputMethod:"boolean"}],e.padding),t.settings.advanced=t.settings.advanced.concat(e.minMax,i,e.xAxis,e.yAxis),t}get options(){return{...super.options,...this.lineBarOptions,areaBase:this.areaBase,fullWidth:this.fullWidth,lineSmooth:this.lineSmooth,showArea:this.showArea,showLine:this.showLine,showPoint:this.showPoint}}get pointLabels(){return this.showPointLabels?{labelOffset:{x:this.pointLabelsOffsetX,y:this.pointLabelsOffsetY},textAnchor:["start","end","middle"].includes(this.pointLabelsAnchor)?this.pointLabelsAnchor:"middle",labelInterpolationFnc:this.pointLabelFunction||void 0}:void 0}updated(t){t.forEach(((t,e)=>{("showPointLabels"===e||e.indexOf("pointLabel")>-1)&&"pluginPointLabels"!==e&&this[e]!==t&&(this.pluginPointLabels=this.pointLabels)})),super.updated&&super.updated(t)}setProperties(){super.setProperties(),this.setBarLineProperties(),this.areaBase=0,this.fullWidth=!1,this.lineSmooth=!0,this.showArea=!1,this.showLine=!0,this.showPoint=!0,this.showPointLabels=!1,this.pointLabelsAnchor="middle",this.pointLabelsOffsetX=0,this.pointLabelsOffsetY=-10,this.type="line"}}customElements.define(LrndesignLine.tag,LrndesignLine);export{LrndesignLine};