/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as r}from"../../../lit/index.js";import{LrndesignChart as i}from"../lrndesign-chart.js";import{SimpleColors as s}from"../../simple-colors/simple-colors.js";class LrndesignBar extends(i(s)){constructor(){super(),this.setProperties()}static get properties(){return{...super.properties,...super.lineBarProperties,axisXOnlyInteger:{attribute:"axis-x-only-integer",type:Boolean},axisXScaleMinSpace:{attribute:"axis-x-min-space",type:Number},distributeSeries:{attribute:"distribute-series",type:Boolean},horizontalBars:{attribute:"horizontal-bars",type:Boolean},referenceValue:{attribute:"reference-value",type:Number},seriesBarDistance:{attribute:"series-bar-distance",type:Number},stackBars:{attribute:"stack-bars",type:Boolean},stackMode:{attribute:"stack-mode",type:Boolean}}}static get tag(){return"lrndesign-bar"}static get haxProperties(){let e=super.haxProperties,t=super.lineBarHaxProperties,r=[{property:"horizontalBars",title:"Horizontal Bars",description:"\n            Inverts the axes of the bar chart in order to draw\n            a horizontal bar chart. Be aware that you also need\n            to invert your axis settings as the Y Axis will now display\n            the labels and the X Axis the values.",inputMethod:"boolean"},{property:"stackBars",title:"Stack Bars",description:"\n            If set to true this property will cause the series bars\n            to be stacked.",inputMethod:"boolean"},{property:"distributeSeries",title:"Distribute Series",description:"\n            If set to true then each bar will represent a series and\n            the data array is expected to be a one dimensional array\n            of data values rather than a series array of series.",inputMethod:"boolean"}],i=[{property:"referenceValue",title:"Reference Value",description:"\n            Unless low/high are explicitly set, bar chart will be\n            centered at zero by default.",inputMethod:"number"},{property:"seriesBarDistance",title:"Series Bar Distance",description:"Specify the distance in pixel of bars in a group.",inputMethod:"number"},{property:"stackMode",title:"Stack Mode",description:'\n            If set to "true" this property will form a total\n            for each series point. This will also influence\n            the y-axis and the overall bounds of the chart.\n            If set to "false" this property will force\n            the stacked bars to draw from the zero line.\n            In stacked mode the "seriesBarDistance" property will have no effect.',inputMethod:"boolean"}];return e.gizmo.title="Bar Chart",e.gizmo.icon="editor:insert-chart",e.settings.configure=e.settings.configure.concat(t.gridBackground,r,t.padding),e.settings.advanced=e.settings.advanced.concat(t.minMax,t.xAxis,[{property:"axisXScaleMinSpace",title:"X-Axis Scale Minimum Space",description:"Specifies minimum height in pixel of scale steps.",inputMethod:"number"},{property:"axisXOnlyInteger",title:"X-Axis Scale (only integers)",description:"Use only integer values (whole numbers) for the scale steps.",inputMethod:"boolean"}],t.yAxis,i),e}get options(){return{...super.options,...this.lineBarOptions,axisX:{onlyInteger:this.axisXOnlyInteger,scaleMinSpace:this.axisXScaleMinSpace},distributeSeries:this.distributeSeries,horizontalBars:this.horizontalBars,referenceValue:this.referenceValue,seriesBarDistance:this.seriesBarDistance,stackBars:this.stackBars,stackMode:this.stackMode}}setProperties(){super.setProperties(),this.setBarLineProperties(),this.axisXOnlyInteger=!1,this.axisXScaleMinSpace=30,this.distributeSeries=!1,this.horizontalBars=!1,this.referenceValue=0,this.seriesBarDistance=15,this.stackBars=!1,this.stackMode=!0,this.type="bar"}}customElements.define(LrndesignBar.tag,LrndesignBar);export{LrndesignBar};