/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../lit/index.js";import{SimpleColors as r}from"../simple-colors/simple-colors.js";import"../paper-avatar/paper-avatar.js";class LrndesignAvatar extends r{static get styles(){return[super.styles,e`
        :host {
          display: block;
          margin: 0;
          padding: 0;
        }

        :host([hidden]) {
          display: none;
        }

        paper-avatar {
          border-radius: var(--lrndesign-avatar-border-radius, 50%);
          max-height: var(--lrndesign-avatar-width, 40px);
          --paper-avatar-width: var(--lrndesign-avatar-width, 40px);
          --paper-avatar-color: var(
            --simple-colors-default-theme-accent-8,
            #444
          );
          --paper-avatar-text-color: var(
            --simple-colors-default-theme-grey-1,
            #fff
          );
        }

        :host([invert]) paper-avatar {
          --paper-avatar-color: var(--simple-colors-default-theme-grey-1, #fff);
          --paper-avatar-text-color: var(
            --simple-colors-default-theme-accent-8,
            #444
          );
        }
      `]}render(){return t` <paper-avatar
      accent-color="${this.accentColor}"
      ?allow-grey="${this.allowGrey}"
      ?dark="${this.dark}"
      .label="${this.label||""}"
      .icon="${this.icon||""}"
      .src="${this.src||""}"
      ?two-chars="${this.twoChars}"
      ?jdenticon="${this.jdenticon}"
    ></paper-avatar>`}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Avatar",description:"Visualize a user account either with an image, icon, initials, or as abstract art.",icon:"image:collections",color:"yellow",tags:["Other","image","media","style","avatar","icon","image","initials","jdenticon","user"],handles:[{type:"image",source:"image"}],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"accentColor",title:"Accent Color",description:"Pick an accent color.",inputMethod:"colorpicker"},{property:"dark",title:"Dark",description:"Use dark text (and light background) for avatar.",inputMethod:"boolean"},{property:"icon",title:"Icon",description:"Optional: Pick an icon for avatar.",inputMethod:"iconpicker"},{property:"src",title:"Image Source",description:"Optional: Upload an image for avatar.",inputMethod:"haxupload",noVoiceRecord:!0},{property:"label",title:"Two-character initials",description:"Label used to create initials or unique Jdenticon.",inputMethod:"textfield"},{property:"twoChars",title:"Two-character initials",description:"When no Jdenticon, image, or icon, use two-character for initials.",inputMethod:"boolean"},{property:"jdenticon",title:"Jdenticon",description:"Optional: Unique icon design based on label.",inputMethod:"boolean"}],advanced:[{property:"allowGrey",title:"Allow Grey",description:"Allows grey if set. Otherwise a color will be assigned",inputMethod:"boolean"}]}}}static get properties(){return{...super.properties,allowGrey:{type:Boolean,attribute:"allow-grey"},icon:{type:String},invert:{type:Boolean,attribute:"invert",reflect:!0},label:{type:String},src:{type:String},twoChars:{type:Boolean,attribute:"two-chars"},color:{type:String},jdenticon:{type:Boolean}}}static get tag(){return"lrndesign-avatar"}constructor(){super(),this.allowGrey=!1,this.dark=!1,this.twoChars=!1,this.jdenticon=!1,this.label="|"}_getAccentColor(){if(this.colors&&!this.allowGrey&&(!this.accentColor||"grey"===this.accentColor)){let t=(this.color||"").replace("-text","");if(t&&this.colors[t])this.accentColor=t;else{let e=this.label||this.icon,r=e&&e.charCodeAt(0)?e.charCodeAt(0):Math.floor(16*Math.random()),a=Object.keys(this.colors);t=a[r%16+1],this.accentColor=a[r%16+1]||a[Math.floor(Math.random()*this.colors.length)]}}}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"color"!=e&&"label"!=e&&"icon"!=e||this._getAccentColor()}))}}customElements.define(LrndesignAvatar.tag,LrndesignAvatar);export{LrndesignAvatar};