/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";import{SchemaBehaviors as o}from"../schema-behaviors/schema-behaviors.js";import"../simple-modal/simple-modal.js";class LrnVocab extends(o(e)){static get styles(){return[i`
        :host {
          display: inline;
          --lrn-vocab-border: 1px dashed #ccc;
        }
        button {
          text-transform: none;
          min-width: unset;
          margin: 0;
          position: relative;
          top: 0px;
          border-radius: 0;
          border-bottom: var(--lrn-vocab-border);
          background: #f5f5f5;
          font-size: 1.1em;
          padding: 2px;
        }
        button:hover {
          background: #bbdefb;
          border-bottom: 1px dashed #2196f3;
        }
      `]}constructor(){super(),setTimeout((()=>{this.addEventListener("click",this.openDialog.bind(this))}),0)}render(){return t` <button>${this.term}</button> `}static get tag(){return"lrn-vocab"}static get properties(){return{...super.properties,term:{type:String,reflect:!0}}}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(e,t){t&&(this._haxstate=t)}haxeditModeChanged(e){this._haxstate=e}openDialog(e){if(this._haxstate)return e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation(),!1;let t=globalThis.document.createElement("div");for(var i in this.children)this.children[i].cloneNode&&t.appendChild(this.children[i].cloneNode(!0));const o=new CustomEvent("simple-modal-show",{bubbles:!0,cancelable:!0,composed:!0,detail:{title:this.term,elements:{content:t},styles:{"--simple-modal-width":"50vw","--simple-modal-max-width":"50vw","--simple-modal-z-index":"100000000","--simple-modal-min-height":"50vh"},invokedBy:this}});this.dispatchEvent(o)}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),globalThis.SimpleModal.requestAvailability()}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Vocab",description:"Vocabulary term",icon:"hax:vocab",color:"red",tags:["Instructional","vocab","term","definition","glossary"],handles:[{type:"inline",text:"term"}],meta:{author:"HAXTheWeb core team",inlineOnly:!0}},settings:{configure:[{property:"term",title:"Term",inputMethod:"textfield",icon:"editor:title",required:!0},{slot:"",title:"Definition",description:"The definitition to display when the term is clicked.",inputMethod:"code-editor",required:!0}],advanced:[]}}}}customElements.define(LrnVocab.tag,LrnVocab);export{LrnVocab};