/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as r}from"../../lit/index.js";import{SchemaBehaviors as i}from"../schema-behaviors/schema-behaviors.js";class LrnTable extends(i(e)){constructor(){super(),setTimeout((()=>{import("../csv-render/csv-render.js")}),0)}static get styles(){return[r`
        :host {
          display: block;
        }
        .hidden-title {
          display: none;
        }
      `]}render(){return t`
      <div typeof="oer:SupportingMaterial">
        <div class="hidden-title" property="oer:name">${this.title}</div>
        <div property="oer:description">
          <slot></slot>
          <csv-render
            data-source="${this.csvFile}"
            caption="${this.title}"
            summary="${this.description}"
          ></csv-render>
        </div>
      </div>
    `}static get tag(){return"lrn-table"}static get properties(){return{...super.properties,title:{type:String},csvFile:{type:String,attribute:"csv-file"},description:{type:String}}}static get haxProperties(){return new URL("./lib/lrn-table.haxProperties.json",import.meta.url).href}}customElements.define(LrnTable.tag,LrnTable);export{LrnTable};