/**
 * Copyright 2022 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t,LitElement as i}from"../../lit/index.js";import{MicroFrontendRegistry as s}from"../micro-frontend-registry/micro-frontend-registry.js";import{store as o}from"../haxcms-elements/lib/core/haxcms-site-store.js";import{toJS as a}from"../../mobx/dist/mobx.esm.js";import{IntersectionObserverMixin as r}from"../intersection-element/lib/IntersectionObserverMixin.js";import{I18NMixin as n}from"../i18n-manager/lib/I18NMixin.js";import"../simple-icon/lib/simple-icons.js";import"../hax-iconset/lib/simple-hax-iconset.js";import{enableServices as l}from"../micro-frontend-registry/lib/microServices.js";l(["haxcms"]);class LessonOverview extends(n(r(i))){static get tag(){return"lesson-overview"}constructor(){super(),this.t=this.t||{},this.t={...this.t,hour:"hour",hours:"hours",minute:"minute",minutes:"minutes"},this.ancestor=null}static get styles(){return[t`
        :host {
          display: inline-flex;
        }
        div ::slotted(lesson-highlight) {
          margin: 8px;
        }
      `]}render(){return e`${this.elementVisible?e` <div class="wrapper">
          <slot name="prefix"></slot>
          <slot></slot>
        </div>`:""}`}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"elementVisible"===t&&this[t]&&this.getSmartData()}))}async getSmartData(e=null){var t={type:"link",__method:"GET"};if(this.ancestor&&(t.ancestor=this.ancestor),e)t.site=e;else{if(a(o.manifest)){var i="";document.querySelector("base")&&(i=globalThis.document.querySelector("base").href),t.site=i,t.ancestor=a(o.activeId),t.cacheBuster=a(o.isLoggedIn)}}if(t.site){this.querySelectorAll("lesson-highlight[smart]").forEach((e=>{e.hidden=!1,e.loading=!0}));const e=await s.call("@haxcms/courseStats",t);200===e.status?this.updateSmartHighlightElements(e.data):this.querySelectorAll("lesson-highlight[smart]").forEach((e=>{e.hidden=!0,e.loading=!1}))}}updateSmartHighlightElements(e){Object.keys(e).forEach((t=>{let i=this.querySelector(`lesson-highlight[smart="${t}"]`);if(i){i.loading=!1;let a=e[t];switch(0===a?i.hidden=!0:i.loaded=!0,t){case"audio":i.title=`${a} Audio`,i.icon="av:music-video";break;case"images":i.title=`${a} Images`,i.icon="image:image";break;case"objectives":i.title=`${a} Objectives`,i.subtitle="Goals for you as you learn",i.icon="editor:format-list-numbered";break;case"dataTables":i.title=`${a} Data tables`,i.icon="image:grid-on";break;case"pages":let r=[];i.title=`${a} Pages`,e.objectives&&r.push(`${e.objectives} learning objectives`),e.images&&r.push(`${e.images} images`),e.dataTables&&r.push(`${e.dataTables} data tables`),i.subtitle=r.join(", "),i.icon="editor:insert-drive-file";break;case"readTime":let n=[];var s=Math.floor(a/60),o=Math.floor(a-60*s);1===s?n.push(`${s} ${this.t.hour}`):0===s||n.push(`${s} ${this.t.hours}`),1===o?n.push(`${o} ${this.t.minute}`):0===o||n.push(`${o} ${this.t.minutes}`),i.title=`Approx. ${n.join(", ")} of reading`,i.subtitle="This is just an estimate of words to read",i.icon="communication:import-contacts";break;case"selfChecks":i.title=`${a} Interactive items`,i.subtitle="Self checks and interactive widgets to learn by applying knowledge",i.icon="hardware:videogame-asset";break;case"video":i.title=`${a} Videos`,e.videoLength&&(i.subtitle=`${toHHMMSS(e.videoLength)} of video`),i.icon="av:play-circle-outline";break;case"videoLength":i.title=`${toHHMMSS(a)} of video`,i.icon="av:play-circle-outline";break;default:i.title=`${a} of ${t}`,i.icon="hardware:videogame-asset"}}}))}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(LessonOverview.tag,LessonOverview);export{LessonOverview};function toHHMMSS(e){var t="",i=parseInt(e,10),s=Math.floor(i/3600),o=Math.floor((i-3600*s)/60);return 0!==s&&(t+=`${s} hour`,1!==s&&(t+="s"),t+=", "),0!==o&&(t+=`${o} minute`,1!==s&&(t+="s")),t}