/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{SimpleIconsetStore as e}from"../simple-icon/lib/simple-iconset.js";import{LitElement as t,html as i,css as s,svg as a}from"../../lit/index.js";import"../simple-icon/lib/simple-icons.js";import{IntersectionObserverMixin as r}from"../intersection-element/lib/IntersectionObserverMixin.js";import{LoadingHelper as o}from"../replace-tag/lib/LoadingHelper.js";export const lazyImageLoader=function(t){return class extends(r(t)){constructor(){super(),this.IOVisibleLimit=.1,this.IOThresholds=[0,.1,.25,.5,.75,1],this.replacementDelay=1e3,this.imageLoaded=!1,this.loadingImg="loading:bars"}updated(t){super.updated&&super.updated(t),t.forEach(((t,i)=>{if("imageLoaded"==i&&!this.imageLoaded&&this.shadowRoot&&this.shadowRoot.querySelector("image")){const t=e.getIcon(this.loadingImg,this);this.shadowRoot.querySelector("image").setAttribute("xlink:href",t)}"elementVisible"==i&&this.elementVisible&&!this.imageLoaded&&(clearTimeout(this.__debouce),this.__debouce=setTimeout((()=>{this.imageLoaded=!0}),this.replacementDelay))}))}_lazyImageLoadComplete(){this.imageLoaded=!0}firstUpdated(t){if(super.firstUpdated&&super.firstUpdated(t),this.shadowRoot.querySelector("image")){const t=e.getIcon(this.loadingImg,this);this.shadowRoot.querySelector("image").setAttribute("xlink:href",t)}var i=this.shadowRoot.querySelector('img[loading="lazy"]');i&&(i.complete?this._lazyImageLoadComplete():(i.addEventListener("load",this._lazyImageLoadComplete.bind(this)),i.addEventListener("error",(()=>{this._lazyImageLoadComplete.bind(this)}))))}static get styles(){let e=[];return super.styles&&(e=super.styles),[e,s`
          img[loading="lazy"] {
            width: 100%;
            margin-top: -200px;
            min-height: 200px;
            float: left;
            opacity: 0;
            transition: opacity 0.3s ease-in-out;
          }
          :host([image-loaded]) img[loading="lazy"] {
            margin-top: unset;
            float: unset;
            opacity: 1;
          }
        `]}static get properties(){return{...super.properties,imageLoaded:{type:Boolean,reflect:!0,attribute:"image-loaded"}}}renderSVGLoader(){return i`${this.imageLoaded?"":a`
      <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="max-height:400px;width:100%;margin:auto;background:#f1f2f3;display:block;z-index:1;position:relative" preserveAspectRatio="xMidYMid" viewBox="0 0 300 200">
      <image
        xlink:href=""
        focusable="false"
        preserveAspectRatio="xMidYMid meet"
      ></image>
      </svg>`}`}}};class lazyImage extends(o(lazyImageLoader(t))){static get tag(){return"lazy-image"}static get properties(){return{...super.properties,src:{type:String,reflect:!0},alt:{type:String,reflect:!0},describedBy:{type:String,attribute:"described-by"}}}static get styles(){return[super.styles,s`
        :host {
          display: block;
        }
        .image-wrap {
          min-height: 250px;
          max-height: 400px;
          overflow: hidden;
        }
      `]}render(){return i`<div class="image-wrap">
      ${this.renderSVGLoader()}
      <img
        src="${this.src}"
        alt="${this.alt}"
        aria-describedby="${this.describedBy||""}"
        loading="lazy"
      />
    </div>`}}customElements.define(lazyImage.tag,lazyImage);export{lazyImage};