/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{JSONOutlineSchemaItem as t}from"./lib/json-outline-schema-item.js";globalThis.JSONOutlineSchema=globalThis.JSONOutlineSchema||{},globalThis.JSONOutlineSchema.requestAvailability=()=>(!globalThis.JSONOutlineSchema.instance&&globalThis.document&&globalThis.document.body&&(globalThis.JSONOutlineSchema.instance=globalThis.document.createElement("json-outline-schema"),globalThis.document.body.appendChild(globalThis.JSONOutlineSchema.instance)),globalThis.JSONOutlineSchema.instance);class JsonOutlineSchema extends HTMLElement{get html(){return"\n<style>\n:host {\n  display: block;\n}\n:host([debug]) {\n  font-family: monospace;\n  white-space: pre;\n  margin: 16px 0px;\n}\n:host([hidden]) {\n  display: none;\n}\n        </style>\n<slot></slot>"}static get tag(){return"json-outline-schema"}constructor(t=!1){super(),this.windowControllers=new AbortController,this.tag=JsonOutlineSchema.tag,this.template=globalThis.document.createElement("template"),this.attachShadow({mode:"open"}),t||this.render(),this.__ready=!1,this.file=null,this.id=this.generateUUID(),this.title="New site",this.author="",this.description="",this.license="by-sa",this.metadata={},this.items=[],this.debug=!1,globalThis.JSONOutlineSchema.instance=this}connectedCallback(){globalThis.ShadyCSS&&globalThis.ShadyCSS.styleElement(this),globalThis.addEventListener("json-outline-schema-debug-toggle",this._toggleDebug.bind(this),{signal:this.windowControllers.signal});const t=new CustomEvent("json-outline-schema-ready",{bubbles:!0,cancelable:!1,composed:!0,detail:!0});this.dispatchEvent(t),this.__ready=!0}_copyAttribute(t,e){const i=this.shadowRoot.querySelectorAll(e),s=this.getAttribute(t),a=null==s?"removeAttribute":"setAttribute";for(const e of i)e[a](t,s)}_setProperty({name:t,value:e}){this[t]=e}render(){this.shadowRoot.innerHTML=null,this.template.innerHTML=this.html,globalThis.ShadyCSS&&globalThis.ShadyCSS.prepareTemplate(this.template,this.tag),this.shadowRoot.appendChild(this.template.content.cloneNode(!0))}disconnectedCallback(){this.windowControllers.abort();const t=new CustomEvent("json-outline-schema-unready",{bubbles:!0,cancelable:!1,detail:!0});this.dispatchEvent(t)}clone(){const t={id:this.id,title:this.title,author:this.author,description:this.description,license:this.license,metadata:this.metadata,items:this.items};return JSON.parse(JSON.stringify(t))}newItem(){return new t}addItem(t){let e=this.validateItem(t);return this.items.push(e),this.items.length}validateItem(e){let i=new t;for(var s in i)void 0!==e[s]&&(i[s]=e[s]);return i}removeItem(t){for(var e in this.items)if(this.items[e].id==t){let t=this.items[e];return delete this.items[e],t}return!1}updateItem(t,e=!1){let i=this.validateItem(t);for(var s in this.items)if(this.items[s].id==i.id)return this.items[s]=i,!e||this.save();return!1}async load(e){if(e){this.file=e;let s=await fetch(e).then((function(t){return t.text()})),a=JSON.parse(s);for(var i in a)void 0!==this[i]&&"items"!==i&&(this[i]=a[i]);if(a.items)for(var i in a.items){let e=a.items[i],s=new t;s.id=e.id,s.indent=e.indent,s.location=e.location,s.slug=e.slug,s.order=e.order,s.parent=e.parent,s.title=e.title,s.description=e.description,s.metadata=e.metadata,this.items[i]=s}return!0}return!1}save(){let t={id:this.id,title:this.title,author:this.author,description:this.description,license:this.license,metadata:this.metadata,items:this.items};return JSON.stringify(t,null,2)}generateUUID(){return"ss-s-s-s-sss".replace(/s/g,this._uuidPart)}_uuidPart(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)}_toggleDebug(t){this.debug=!this.debug,this._triggerDebugPaint(this.debug)}_triggerDebugPaint(t){if(t){let t={file:this.file,id:this.id,title:this.title,author:this.author,description:this.description,license:this.license,metadata:this.metadata,items:this.items},e=globalThis.document.createElement("span");e.innerHTML=JSON.stringify(t,null,2),this.shadowRoot.appendChild(e.cloneNode(!0))}else this.render()}static get observedAttributes(){return["file","id","title","author","description","license","debug"]}attributeChangedCallback(t,e,i){this.debug&&(this.render(),this._triggerDebugPaint(this.debug))}get file(){return this.getAttribute("file")}set file(t){this.__ready&&this.setAttribute("file",t)}get id(){return this.getAttribute("id")}set id(t){this.__ready&&this.setAttribute("id",t)}get title(){return this.getAttribute("title")}set title(t){this.__ready&&this.setAttribute("title",t)}get author(){return this.getAttribute("author")}set author(t){this.__ready&&this.setAttribute("author",t)}get description(){return this.getAttribute("description")}set description(t){this.__ready&&this.setAttribute("description",t)}get license(){return this.getAttribute("license")}set license(t){this.__ready&&this.setAttribute("license",t)}get debug(){return this.getAttribute("debug")}set debug(t){this.__ready&&t?this.setAttribute("debug",t):this.removeAttribute("debug")}updateMetadata(t,e){this.metadata[t]=e,this.debug&&(this.render(),this._triggerDebugPaint(this.debug))}getItemValues(e,i=!1){var s;return s=e?this.validateItem(e):new t,i&&(s.parent=i.id),s}getItemSchema(e="item"){var i,s={$schema:"http://json-schema.org/schema#",title:this.title,type:"object",properties:{}};for(var a in"item"==e?i=new t:(i={file:this.file,id:this.id,title:this.title,author:this.author,description:this.description,license:this.license,metadata:this.metadata},"outline"==e&&(i.items=this.items)),i){let t={title:a,type:"string",value:i[a]};switch(a){case"file":case"id":case"title":case"author":case"description":case"license":case"location":case"parent":t.component={name:"paper-input",valueProperty:"value",properties:{required:!0}};break;case"indent":case"order":t.component={name:"paper-input",valueProperty:"value",properties:{required:!0},attributes:{type:"number"}};case"metadata":case"items":t.type="array",t.items={type:"object",properties:{key:{title:"key",type:"string",component:{name:"paper-input",valueProperty:"value",properties:{required:!0}}},value:{title:"value",type:"string",component:{name:"paper-input",valueProperty:"value",properties:{required:!0}}}}};break;default:console.warn(a)}s.properties[a]=t}return s}itemsToNodes(t=[]){0===t.length&&(t=this.items);let e=this.unflattenItems(t);return this.treeToNodes(e,globalThis.document.createElement("ul"))}treeToNodes(t,e){for(var i in t){let s=globalThis.document.createElement("li");s.innerText=t[i].title,s.setAttribute("data-jos-id",t[i].id),t[i].location&&s.setAttribute("data-jos-location",t[i].location),t[i].slug&&s.setAttribute("data-jos-slug",t[i].slug),void 0!==t[i].metadata&&void 0!==t[i].metadata.published&&s.setAttribute("data-jos-published",t[i].metadata.published),e.appendChild(s),t[i].children&&t[i].children.length>0&&e.appendChild(this.treeToNodes(t[i].children,globalThis.document.createElement("ul")))}return e}unflattenItems(t,e,i){i=void 0!==i?i:[],e=void 0!==e?e:{id:null};let s=t.filter((t=>t.parent===e.id));return s.length&&(e.id?e.children=s:i=s,s.sort(((t,e)=>t.order<e.order?-1:t.order>e.order?1:0)),s.map(((t,e)=>{s[e].order=e})),s.forEach((e=>{this.unflattenItems(t,e)}))),i}scrubElementJOSData(t){for(var e in t.children)t.removeAttribute("data-jos-id"),t.removeAttribute("data-jos-location"),t.removeAttribute("data-jos-slug"),t.children[e].children&&this.scrubElementJOSData(t.children[e])}nodesToItems(t,e=!1){const i=this.getChildOutline(t);return e&&(this.items=i,this.debug&&(this.render(),this._triggerDebugPaint(this.debug))),i}getChildOutline(e,i=0,s=0,a=null){const r=e.cloneNode(!0);let n=[],l={};for(;null!==r.firstChild;){if(void 0!==r.firstChild.tagName){const e=r.firstChild;if(null!==e.firstChild&&void 0!==e.firstChild.tagName){let t=a;void 0!==l.id&&(t=l.id),n=n.concat(this.getChildOutline(e,0,s+1,t))}else l=new t,e.getAttribute("data-jos-id")&&(l.id=e.getAttribute("data-jos-id")),e.getAttribute("data-jos-location")?l.location=e.getAttribute("data-jos-location"):l.location="",e.getAttribute("data-jos-slug")?l.slug=e.getAttribute("data-jos-slug"):l.slug="",l.indent=s,l.order=i,i+=1,l.title=e.innerText,l.parent=a,n.push(l)}r.removeChild(r.firstChild)}return n}}customElements.define(JsonOutlineSchema.tag,JsonOutlineSchema);export{JsonOutlineSchema,t as JSONOutlineSchemaItem};