/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as r}from"../../lit/index.js";class JsonEditor extends e{static get styles(){return[r`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }
      `]}render(){return t` <custom-style>
        <style>
          :host([error]) paper-textarea {
            --iron-autogrow-textarea: {
              background-color: #ffeeee;
            };
          }
          paper-textarea {
            --iron-autogrow-textarea: {
              font-family: "Lucida Console", Monaco, monospace;
              font-weight: 600;
              white-space: pre;
              line-height: 20px;
              padding: 9.5px;
              margin: 0 0 10px;
              font-size: 13px;
              color: #000000;
              word-break: break-all;
              word-wrap: break-word;
              background-color: #f5f5f5;
              border: 1px solid #ccc;
              border-radius: 4px;
              transition: 0.3s linear all;
            };
          }
        </style>
      </custom-style>
      <paper-textarea
        label="${this.label}"
        value="${this.value}"
        @value-changed="${this.valueEvent}"
        error-message="Invalid JSON!"
        ?readonly="${this.disabled}"
        ?invalid="${this.error}"
        max-rows="${this.maxRows}"
      ></paper-textarea>`}static get properties(){return{...super.properties,label:{type:String},error:{type:Boolean,reflect:!0},disabled:{type:Boolean,reflect:!0},maxRows:{type:Number,reflect:!0,attribute:"max-rows"},value:{type:String,reflect:!1},formatTest:{type:String,attribute:"format-test"},currentData:{type:Object,attribute:"current-data"}}}static get tag(){return"json-editor"}constructor(){super(),this.label="JSON data",this.error=!1,this.disabled=!1,this.maxRows=0,this.value="",import("../../@polymer/paper-input/paper-textarea.js")}updated(e){e.forEach(((e,t)=>{if(["currentData","value"].includes(t)){let e=`${t.replace(/([a-z0-9]|(?=[A-Z]))([A-Z])/g,"$1-$2").toLowerCase()}-changed`;this.dispatchEvent(new CustomEvent(e,{detail:{value:this[t]}}))}"value"==t&&(this.formatTest=this._computeFormattedValue(this[t]),this.currentData=this._computeCurrentData(this[t]),this._valueChanged(this[t]))}))}valueEvent(e){this.value=e.detail.value}_valueChanged(e,t){try{JSON.parse(e)&&(this.error=!1)}catch(e){this.error=!0}}_computeFormattedValue(e){try{let t=JSON.stringify(JSON.parse(t),null,2);t!==e&&(this.value=t)}catch(e){}}_computeCurrentData(e){try{return JSON.parse(e)}catch(e){}}}customElements.define(JsonEditor.tag,JsonEditor);export{JsonEditor};