import{html as i,css as t}from"../../lit/index.js";import{SimpleColors as e}from"../simple-colors/simple-colors.js";import{I18NMixin as a}from"../i18n-manager/lib/I18NMixin.js";import"../simple-icon/lib/simple-icons.js";import"../simple-icon/lib/simple-icon-button.js";import"../hax-iconset/lib/simple-hax-iconset.js";import{DDD as o}from"../d-d-d/d-d-d.js";class InlineAudio extends(a(o)){static get tag(){return"inline-audio"}static get properties(){return{...super.properties,source:{type:String},icon:{type:String},aria:{type:String},title:{type:String},playing:{type:Boolean,reflect:!0},shiny:{type:Boolean,reflect:!0}}}static get styles(){return[super.styles,t`
        :host {
          display: inline-flex;
          vertical-align: middle;
          color: var(--ddd-theme-default-white);
          --inline-audio-padding: 0px 4px;
          --inline-audio-margin: 0;
          --inline-audio-icon-padding: 0px 4px 0px 0px;
        }

        .container {
          display: inline-flex;
          align-items: center;
          padding: var(--inline-audio-padding);
          margin: var(--inline-audio-margin);
          background-color: var(--ddd-theme-default-coalyGray);
          min-width: 48px;
          border-radius: 4px;
          cursor: pointer;
          position: relative;
          z-index: 1;
        }

        :host([shiny]) .container {
          background-color: var(--simple-colors-default-theme-accent-2);
        }

        .progress-bar {
          height: 100%;
          background-color: var(--simple-colors-default-theme-accent-5);
          transition: width 0.1s;
          position: absolute;
          border-radius: 4px;
          top: 0;
          left: 0;
          z-index: -1;
        }

        .progress {
          height: 100%;
          background-color: var(--simple-colors-default-theme-accent-5);
          position: absolute;
          border-radius: 4px;
          top: 0;
          left: 0;
          z-index: -1;
          animation: progress-bar 1s linear forwards;
        }

        .container:focus-within {
          outline: 2px solid var(--simple-colors-default-theme-accent-6);
        }

        .icon {
          padding: var(--inline-audio-icon-padding);
          --simple-icon-color: var(--ddd-theme-default-white);
          --simple-icon-button-border-radius: none;
          --simple-icon-button-focus-color: var(--ddd-theme-default-white);
          --simple-icon-button-focus-opacity: var(
            --inline-audio-button-focus-opacity,
            0.8
          );
          --simple-icon-width: var(--inline-audio-width, 36px);
          --simple-icon-height: var(--inline-audio-height, 36px);
        }

        .icon::part(button):focus {
          outline: none;
        }
      `]}constructor(){super(),this._haxstate=!1,this.playing=!1,this.shiny=!1,this.canPlay=!1,this.t=this.t||{},this.t.play="Play",this.t.pause="Pause",this.t.selectToPlayRelatedAudioClip="Select to play related audio clip",this.t.selectToPauseRelatedAudioClip="Select to pause related audio clip",this.source="",this.icon="av:play-arrow",this.aria=this.t.selectToPlayRelatedAudioClip,this.title=this.t.play,this.addEventListener("click",this.__clickEvent)}handleProgress(){this.__audio.ended&&this.audioController(!1);const i=this.__audio.currentTime/this.__audio.duration*100;this.shadowRoot.querySelector(".progress").style.width=`${i}%`,this.__audio.paused||requestAnimationFrame((()=>this.handleProgress()))}handlePlaythrough(){setTimeout((()=>{this.canPlay=!0,this.audioController(!0)}),500)}audioController(i){i?(this.__audio.play(),this.playing=!0):(this.__audio.pause(),this.playing=!1)}load(i){this.__audio.src=i,this.__audio.load()}play(){this.audioController(!0)}pause(){this.audioController(!1)}__clickEvent(i){if(this._haxstate)i.preventDefault(),i.stopPropagation(),i.stopImmediatePropagation();else try{this.shadowRoot.getSelection().toString()||(this.__audio.hasAttribute("src")?this.canPlay&&(this.__audio.paused?this.audioController(!0):this.audioController(!1)):(this.icon="hax:loading",this.load(this.source)))}catch(i){}}updated(i){super.updated&&super.updated(i),i.forEach(((i,t)=>{"playing"===t&&void 0!==i&&(this.dispatchEvent(new CustomEvent("playing-changed",{detail:{value:this[t]}})),this[t]?(this.icon="av:pause",this.title=this.t.pause,this.aria=this.t.selectToPauseRelatedAudioClip):(this.icon="av:play-arrow",this.title=this.t.play,this.aria=this.t.selectToPlayRelatedAudioClip))}))}firstUpdated(i){super.firstUpdated&&super.firstUpdated(i),this.__audio=this.shadowRoot.querySelector(".player")}render(){return i` <div class="container">
      <simple-icon-button
        part="icon"
        class="icon"
        title="${this.title}"
        label="${this.aria}"
        icon="${this.icon}"
      ></simple-icon-button>
      <slot></slot>
      <audio
        class="player"
        hidden
        type="audio/mpeg"
        @canplaythrough="${this.handlePlaythrough}"
        @timeupdate="${this.handleProgress}"
      ></audio>
      <div part="progress-bar" class="progress-bar"></div>
      <div part="progress" class="progress"></div>
    </div>`}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(i,t){t&&(this._haxstate=t)}haxeditModeChanged(i){this._haxstate=i}}customElements.define(InlineAudio.tag,InlineAudio);export{InlineAudio};