import{LitElement as t,html as e,css as o}from"../../../lit/index.js";import{ImgPanZoom as i}from"../../img-pan-zoom/img-pan-zoom.js";import{FullscreenBehaviors as r}from"../../fullscreen-behaviors/fullscreen-behaviors.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import{normalizeEventPath as n}from"../../utils/utils.js";class ImgViewViewer extends(r(i)){static get styles(){return[o`
        :host {
          display: block;
          height: var(--img-view-viewer-height, 500px);
          --hexagon-color: var(--img-view-viewer-focus-borderColor, blue);
        }
        :host([hidden]),
        *[hidden] {
          display: none !important;
        }
        .sr-only {
          position: absolute;
          left: -9999999px;
          width: 0;
          overflow: hidden;
        }
        #viewer {
          display: block;
          position: relative;
          height: calc(var(--img-view-viewer-height, 500px) - 104px);
          width: auto;
          border: 1px solid var(--img-view-viewer-borderColor, #ddd);
        }
        #loader {
          display: none;
          position: relative;
          display: flex;
          flex-direction: column;
          align-items: center;
          justify-content: space-around;
          width: 100%;
          height: var(--img-view-viewer-height, 500px);
          margin-bottom: calc(0px - var(--img-view-viewer-height, 104px));
          z-index: 1;
        }
        hexagon-loader {
          position: absolute;
          opacity: 0;
          transition: opacity 700ms;
          margin: auto;
        }
        hexagon-loader[loading] {
          opacity: 1;
        }
        #container {
          display: flex;
          flex-direction: column;
          align-items: stretch;
          justify-content: space-between;
          height: 100%;
          background-color: var(--img-view-viewer-backgroundColor, white);
          color: var(--img-view-viewer-color, black);
        }
        #container > * {
          flex: 1 1 auto;
        }
        .misc-item,
        .button-group {
          display: flex;
          align-items: stretch;
          justify-content: center;
        }
        .misc-item {
          align-items: center;
          padding: 5px;
        }
        #top,
        #bottom {
          margin: 0;
          flex: 1 0 46px;
          border: 1px solid var(--img-view-viewer-borderColor, #ddd);
        }
        #top > *,
        #bottom > * {
          margin: 0;
        }
        #top > *:not(:first-child),
        #bottom > *:not(:first-child) {
          border-left: 1px solid var(--img-view-viewer-borderColor, #ddd);
        }
        button {
          border: none;
          background-color: transparent;
          color: var(--img-view-viewer-color);
        }
        button[disabled] {
          opacity: 0.5;
          cursor: not-allowed;
        }
        button.flex-grow {
          flex: 1 0 auto;
        }
        button p {
          display: flex;
          align-items: center;
          justify-content: flex-start;
        }
        button.icon-right p {
          flex-direction: row-reverse;
          justify-content: end;
        }
        button[aria-pressed="true"] {
          --img-view-viewer-backgroundColor: var(
            --img-view-viewer-toggled-backgroundColor,
            #eee
          );
        }

        button:focus,
        button:hover,
        #viewer:focus-within {
          outline: 1px solid var(--img-view-viewer-focus-borderColor, blue);
          z-index: 2;
        }
        simple-tooltip:not(:defined) {
          display: none;
        }
        #placeholder {
          position: relative;
          max-height: 0;
          overflow: visible;
        }
        #info {
          position: absolute;
          bottom: 0;
          right: 0;
          padding: 5px;
          background-color: var(--img-view-viewer-backgroundColor, white);
          border: 1px solid var(--img-view-viewer-borderColor, #ddd);
        }
        table {
          border-collapse: collapse;
        }
        th,
        td {
          padding: 2px 5px;
          line-height: 140%;
          border-top: 1px solid var(--img-view-viewer-borderColor, #ddd);
        }
        th {
          font-weight: normal;
          text-align: left;
        }
        kbd {
          border-radius: 2px;
          padding: 1px 3px;
          font-family: sans-serif;
          font-size: 80%;
          background: var(--img-view-viewer-toggled-backgroundColor, #eee);
          border: 1px solid var(--img-view-viewer-borderColor, #ddd);
        }
        input[type="number"] {
          max-width: 4em;
          border: 1px solid var(--img-view-viewer-borderColor, #ddd);
        }
      `]}constructor(){super(),this.minZoomImageRatio=1,this.maxZoomPixelRatio=3,this.__screenfullLoaded=!1,import("../../simple-tooltip/simple-tooltip.js")}render(){return e`
      ${this.dzi?"":e`
            ${this.hideSpinner?"":e`
                  <div id="loader" ?hidden="${this.loaded}">
                    <hexagon-loader
                      ?loading=${this.loading||!this.loaded}
                      item-count="4"
                    ></hexagon-loader>
                  </div>
                  <img-loader
                    ?loaded="${this.loaded}"
                    @loaded-changed="${this.loadedChangedEvent}"
                    ?loading="${this.loading}"
                    @loading-changed="${this.loadingChangedEvent}"
                    src="${this.loadSrc}"
                    described-by="${this.describedBy||""}"
                  ></img-loader>
                `}
          `}
      <div id="container">
        ${this.getToolbars("top")}
        <div>
          <div
            id="viewer"
            style="height:calc(var(--img-view-viewer-height, 500px) - ${this.toolbarsHeight}px)"
          ></div>
        </div>
        <div id="placeholder">
          <div id="info" ?hidden="${!this.info}">${this.info}</div>
        </div>
        ${this.getToolbars("bottom")}
      </div>
    `}static get tag(){return"img-view-viewer"}static get properties(){let t={...super.properties};return delete t.src,delete t.sources,{...t,disabled:{type:Boolean,reflect:!0,attribute:"disabled"},figures:{type:Array},infoToggled:{type:Boolean,attribute:"info-mode",reflect:!0},kbdToggled:{type:Boolean,attribute:"keyboard-help-mode",reflect:!0},toolbars:{type:Object,attribute:"toolbars",reflect:!0},__screenfullLoaded:{type:Boolean}}}get toolbarsHeight(){let t=0,e=this.customToolbars||this.toolbars;return e.top&&(t+=52),e.bottom&&(t+=52),t}getToolbars(t="bottom"){let e=this.customToolbars||this.toolbars,o=!(!e||!e[t])&&e[t];return o?this._item(o,"top"===t):""}get homebutton(){return{id:"homebutton",icon:"home",text:"return image to home position"}}get fullscreenbutton(){return{id:"fullscreenbutton",icon:"fullscreen",toggleProp:"__fullscreen",enabledProp:"fullscreenEnabled",text:e` toggle fullscreen `}}get fullscreenTarget(){return this.shadowRoot&&this.shadowRoot.querySelector("#container")?this.shadowRoot.querySelector("#container"):this}get navigatorbutton(){return{id:"navigatorbutton",icon:"picture-in-picture",toggleProp:"navigatorToggled",shownProp:"showNavigator",enabledProp:"showNavigator",text:"toggle nav window"}}get infobutton(){return{id:"infobutton",icon:"info-outline",toggleProp:"infoToggled",hiddenProp:"noSources",text:"toggle information"}}get kbdbutton(){return{id:"kbdbutton",icon:"help-outline",toggleProp:"kbdToggled",text:"toggle keyboard shorcuts help",details:e`
        <table>
          <caption>
            Keyboard Shortcuts (when image has focus)
          </caption>
          <tbody>
            <tr>
              <th scope="row">pan up</th>
              <td><kbd>w</kbd> or <kbd>&uarr;</kbd></td>
            </tr>
            <tr>
              <th scope="row">pan down</th>
              <td><kbd>s</kbd> or <kbd>&darr;</kbd></td>
            </tr>
            <tr>
              <th scope="row">pan left</th>
              <td><kbd>a</kbd> or <kbd>&larr;</kbd></td>
            </tr>
            <tr>
              <th scope="row">pan right</th>
              <td><kbd>d</kbd> or <kbd>&rarr;</kbd></td>
            </tr>
            <tr>
              <th scope="row">home</th>
              <td><kbd>0</kbd></td>
            </tr>
            <tr>
              <th scope="row">zoom out</th>
              <td><kbd>-</kbd> or <kbd>_</kbd></td>
            </tr>
            <tr>
              <th scope="row">zoom in</th>
              <td><kbd>+</kbd> or <kbd>=</kbd></td>
            </tr>
            <tr>
              <th scope="row">rotate clockwise</th>
              <td><kbd>r</kbd></td>
            </tr>
            <tr>
              <th scope="row">rotate counterclockwise</th>
              <td><kbd>shift+r</kbd></td>
            </tr>
          </tbody>
        </table>
      `}}get flipbutton(){return{id:"flipbutton",icon:"image:flip",text:"flip horizontal",toggleProp:"flipToggled"}}get rotategroup(){return{id:"rotategroup",type:"toolbar-group",contents:[this.rotateccwbutton,this.rotatecwbutton]}}get rotateccwbutton(){return{id:"rotateccwbutton",icon:"image:rotate-left",text:"rotate counterclockwise"}}get rotatecwbutton(){return{id:"rotatecwbutton",icon:"image:rotate-right",text:"rotate clockwise"}}get pangroup(){return{id:"pangroup",type:"toolbar-group",contents:[this.panleftbutton,this.panupbutton,this.pandownbutton,this.panrightbutton]}}get panleftbutton(){return{id:"panleftbutton",icon:"arrow-back",text:"pan left"}}get panupbutton(){return{id:"panupbutton",icon:"arrow-upward",text:"pan up"}}get pandownbutton(){return{id:"pandownbutton",icon:"arrow-downward",text:"pan down"}}get panrightbutton(){return{id:"panrightbutton",icon:"arrow-forward",text:"pan right"}}get zoomgroup(){return{id:"zoomgroup",type:"toolbar-group",contents:[this.zoominbutton,this.zoomoutbutton]}}get zoominbutton(){return{id:"zoominbutton",icon:"zoom-in",text:"zoom in"}}get zoomoutbutton(){return{id:"zoomoutbutton",icon:"zoom-out",text:"zoom out"}}get prevbutton(){return{id:"prevbutton",showText:!0,icon:"chevron-left",text:"prev",disabledProp:"prevDisabled",flexGrow:!0}}get nextbutton(){return{id:"nextbutton",icon:"chevron-right",iconRight:!0,disabledProp:"nextDisabled",text:"next",showText:!0,flexGrow:!0}}get pages(){return this.figures||[]}get noSources(){this.pages.length}get prevDisabled(){return this.page<=0}get nextDisabled(){return this.page+1>=this.pages.length}get info(){return this.kbdToggled&&this.kbdbutton.details?this.kbdbutton.details:this.infoToggled&&this.figures&&this.figures[this.page]&&this.figures[this.page].info?this.figures[this.page].info:void 0}get pageXofY(){return`${(this.page||0)+1} of ${this.pages.length}`}get navXofY(){return{id:"navXofY",type:"misc-item",contents:e`
        <p>
          <label for="pageX" class="sr-only">Page</label>
          <input
            ?disabled="${this.disabled}"
            id="pageX"
            type="number"
            min="1"
            max="${this.pages.length}"
            value="${this.page+1}"
            @change="${t=>this._xOfYClick(t,this.disabled)}"
          />
          of ${this.pages.length}
        </p>
      `}}get defaultToolbars(){return{bottom:{id:"bottom",type:"toolbar-group",contents:["prevbutton","homebutton","rotategroup","zoomgroup","pageXofY","pangroup","fullscreenbutton","nextbutton"]}}}_item(t={},o=!1){return"string"==typeof t&&this[t]&&(t=this[t]),"object"!=typeof t?e` <div class="misc-item">${t}</div> `:t&&void 0===t.contents?this._button(t,o):this._group(t,o)}_group(t={},o=!1){return"string"==typeof t&&this[t]&&(t=this[t]),t?e`
          <div
            .id="${t.id||void 0}"
            class="button-group ${t.type||""}"
          >
            ${Array.isArray(t.contents)?(t.contents||[]).map((t=>this._item(t,o))):t.contents}
          </div>
        `:""}_button(t={},o=!1){return"string"==typeof t&&this[t]&&(t=this[t]),t?t.toggleProp&&this[t.toggleProp]?e`
            <button
              .id="${t.id||void 0}"
              aria-pressed="${this[t.toggleProp]?"true":"false"}"
              class="${this._buttonClass(t)}"
              @click="${e=>this._toolbarButtonClick(t.id,e,this._buttonDisabled(t))}"
              controls="container"
              ?disabled="${this._buttonDisabled(t)}"
              ?hidden="${this._buttonHidden(t)}"
            >
              ${this._buttonInner(t)} ${this._buttonTooltip(t)}
            </button>
          `:e`
            <button
              .id="${t.id||void 0}"
              class="${this._buttonClass(t)}"
              @click="${e=>this._toolbarButtonClick(t.id,e,this._buttonDisabled(t))}"
              controls="container"
              ?disabled="${this._buttonDisabled(t)}"
              ?hidden="${this._buttonHidden(t)}"
            >
              ${this._buttonInner(t)}
            </button>
            ${this._buttonTooltip(t,o)}
          `:""}_buttonDisabled(t){return t.disabledProp&&this[t.disabledProp]||t.enabledProp&&!this[t.enabledProp]||this.disabled}_buttonHidden(t){return t.hiddenProp&&this[t.hiddenProp]||t.shownProp&&!this[t.shownProp]}_buttonClass(t){return`${t.iconRight?"icon-right":""}${t.flexGrow?" flex-grow":""}`}_buttonInner(t){return t?e`
          <p>
            <simple-icon-lite
              aria-hidden="true"
              icon="${t.icon}"
            ></simple-icon-lite>
            <span class="${t.icon&&!t.showText?"sr-only":""}"
              >${t.text}</span
            >
          </p>
        `:""}_buttonTooltip(t,o=!1){return t&&t.id?e`
          <simple-tooltip
            for="${t.id}"
            position="${o?"bottom":"top"}"
            >${t.text}</simple-tooltip
          >
        `:""}get src(){return this.figures&&this.figures[0]?this.figures[0].src:void 0}get loadSrc(){return this.figures&&this.figures[this.page]?this.figures[this.page].src:void 0}get sources(){return this.figures?this.figures.map((t=>t.src)).slice(1):void 0}_setFullscreen(t){}_toolbarButtonClick(t,e,o=!1){o||(this.dispatchEvent(new CustomEvent("toolbar-button-click",{bubbles:!0,cancelable:!0,composed:!0,detail:{buttonId:t,eventType:e,viewer:this}})),"homebutton"===t&&this.resetZoom(),"panupbutton"===t&&this.pan(0,.2),"pandownbutton"===t&&this.pan(0,-.2),"panleftbutton"===t&&this.pan(.2,0),"panrightbutton"===t&&this.pan(-.2,0),"zoominbutton"===t&&this.zoomIn(.2),"zoomoutbutton"===t&&this.zoomOut(.2),"rotateccwbutton"===t&&this.rotate(-90),"rotatecwbutton"===t&&this.rotate(90),"navigatorbutton"===t&&(this.navigatorToggled=!this.navigatorToggled),"fullscreenbutton"===t&&this.toggleFullscreen(),"flipbutton"===t&&(this.flipToggled=!this.flipToggled),"infobutton"===t&&(this.kbdToggled=!1,this.infoToggled=!this.infoToggled),"kbdbutton"===t&&(this.infoToggled=!1,this.kbdToggled=!this.kbdToggled),"nextbutton"===t&&(this.page=Math.min(this.page+1,this.pages.length-1)),"prevbutton"===t&&(this.page=Math.max(0,this.page-1)))}_xOfYClick(t,e){this._toolbarButtonClick("navXofY",t,e),e||this.goToPageXofY(t)}goToPageXofY(t){var e=n(t);this.page=e?e[0].value-1:t.target.value}loadedChangedEvent(t){this.loaded=t.detail.value,this.loaded&&(this.loading=!1)}loadingChangedEvent(t){this.loading=t.detail.value}_addImage(){this.viewer.addSimpleImage({url:this.loadSrc,index:this.page,clone:!0})}_addTiledImage(){this.viewer.addTiledImage({tileSource:this.loadSrc,index:this.page,clone:!0})}}customElements.define(ImgViewViewer.tag,ImgViewViewer);export{ImgViewViewer};