import{LitElement as e,html as t,css as i}from"../../lit/index.js";import"../es-global-bridge/es-global-bridge.js";class ImgPanZoom extends e{static get styles(){return[i`
        :host {
          display: block;
          position: relative;
          height: var(--img-pan-zoom-height, 500px);
        }
        #viewer {
          position: relative;
          height: 100%;
          width: 100%;
        }
        #loader {
          display: none;
          position: relative;
          display: flex;
          flex-direction: column;
          align-items: center;
          justify-content: space-around;
          width: 100%;
          height: calc(var(--img-pan-zoom-height, 500px) - 100px);
          margin-bottom: calc(100px - var(--img-pan-zoom-height, 500px));
          z-index: 1;
        }
        hexagon-loader {
          position: absolute;
          opacity: 0;
          transition: opacity 700ms;
          margin: auto;
        }
        hexagon-loader[hidden] {
          display: none;
        }
        hexagon-loader[loading] {
          opacity: 1;
        }
      `]}render(){return t`
      <!-- Only preload regular images -->
      ${this.dzi?"":t`
            ${this.hideSpinner||this.loaded?"":t`
                  <div id="loader">
                    <hexagon-loader
                      ?loading=${this.loading||!this.loaded}
                      item-count="4"
                      size="small"
                    ></hexagon-loader>
                  </div>
                `}
            <img-loader
              ?loaded="${this.loaded}"
              @loaded-changed="${this.loadedChangedEvent}"
              ?loading="${this.loading}"
              @loading-changed="${this.loadingChangedEvent}"
              src="${this.src||(this.sources||[])[0]}"
              described-by="${this.describedBy||""}"
            ></img-loader>
          `}

      <!-- Openseadragon -->
      <div id="viewer"></div>
    `}static get tag(){return"img-pan-zoom"}static get properties(){return{src:{type:String},sources:{type:Array},page:{type:Number,attribute:"page"},describedBy:{type:String,attribute:"described-by"},dzi:{type:Boolean},fadeIn:{type:Boolean,attribute:"fade-in"},fullscreenToggled:{type:Boolean,attribute:"fullscreen-toggled",reflect:!0},flipToggled:{type:Boolean,attribute:"flip-toggled",reflect:!0},loading:{type:Boolean},hideSpinner:{type:Boolean,attribute:"hide-spinner"},loaded:{type:Boolean},showNavigationControl:{type:Boolean,attribute:"show-navigation-control"},showNavigator:{type:Boolean,attribute:"show-navigator"},zoomPerClick:{type:Number,attribute:"zoom-per-click"},zoomPerScroll:{type:Number,attribute:"zoom-per-scroll"},animationTime:{type:Number,attribute:"animation-time"},navPrevNextWrap:{type:Boolean,attribute:"nav-prev-next-wrap"},showRotationControl:{type:Boolean,attribute:"show-rotation-control"},minZoomImageRatio:{type:Number,attribute:"min-zoom-image-ratio"},maxZoomPixelRatio:{type:Number,attribute:"max-zoom-pixel-ratio"},constrainDuringPan:{type:Boolean,attribute:"constrain-during-pan"},visibilityRatio:{type:Number,attribute:"visibility-ratio"},navigatorAutoFade:{type:Boolean,attribute:"navigator-auto-fade",reflect:!0},navigatorPosition:{type:String,attribute:"navigator-position",reflect:!0},navigatorTop:{type:String,attribute:"navigator-top",reflect:!0},navigatorBottom:{type:String,attribute:"navigator-bottom",reflect:!0},navigatorLeft:{type:String,attribute:"navigator-left",reflect:!0},navigatorRight:{type:String,attribute:"navigator-right",reflect:!0},navigatorHeight:{type:String,attribute:"navigator-height",reflect:!0},navigatorWidth:{type:String,attribute:"navigator-width",reflect:!0},navigatorToggled:{type:Boolean,attribute:"navigator-toggled",reflect:!0},sequenceMode:{type:Boolean,attribute:"sequence-mode"},preserveViewport:{type:Boolean,attribute:"preserve-viewport"},showReferenceStrip:{type:Boolean,attribute:"show-reference-strip"},referenceStripScroll:{type:String,attribute:"reference-strip-scroll"},previousButton:{type:String},nextButton:{type:String},homeButton:{type:String},zoomInButton:{type:String},zoomOutButton:{type:String},fullScreenButton:{type:String}}}constructor(){super(),this.windowControllers=new AbortController,this.page=0,this.loading=!1,this.dzi=!1,this.fadeIn=!0,this.hideSpinner=!1,this.fullscreenToggled=!1,this.flipToggled=!1,this.showNavigationControl=!1,this.showNavigator=!1,this.navigatorAutoFade=!1,this.navigatorPosition=!1,this.navigatorToggled=!1,this.zoomPerClick=2,this.zoomPerScroll=1.2,this.animationTime=1.2,this.navPrevNextWrap=!1,this.showRotationControl=!1,this.minZoomImageRatio=1,this.maxZoomPixelRatio=1.1,this.constrainDuringPan=!1,this.visibilityRatio=1,this.sequenceMode=!1,this.preserveViewport=!1,this.showReferenceStrip=!1,this.referenceStripScroll="horizontal";let e=`${new URL("./img-pan-zoom.js",import.meta.url).href.replace("/img-pan-zoom.js","/")}lib/openseadragon/openseadragon.min.js`;globalThis.addEventListener("es-bridge-openseadragon-loaded",this._openseadragonLoaded.bind(this),{signal:this.windowControllers.signal}),globalThis.ESGlobalBridge.requestAvailability().load("openseadragon",e),import("../hexagon-loader/hexagon-loader.js"),import("./lib/img-loader.js")}updated(e){e.forEach(((e,t)=>{"loading"==t&&this.dispatchEvent(new CustomEvent("loading-changed",{detail:{value:this[t]}})),"loaded"==t&&(this._loadedChanged(this[t],e),this.dispatchEvent(new CustomEvent("loaded-changed",{detail:{value:this[t]}}))),"navigatorToggled"==t&&this.viewer&&(this.viewer.navigator.element.style.display=this.navigatorToggled?"inline-block":"none"),"fullscreenToggled"==t&&this._setFullscreen(),"flipToggled"==t&&this.viewer&&this.viewer.viewport&&this.viewer.viewport.setFlip(this.flipToggled),"page"==t&&this.viewer&&this.viewer.goToPage(Math.max(0,Math.min(this.page,(this.viewer.tileSources||[]).length-1)))}))}_openseadragonLoaded(){try{if(globalThis.OpenSeadragon)this._initOpenSeadragon();else{let e=setInterval((()=>{globalThis.OpenSeadragon&&(this._initOpenSeadragon(),clearInterval(e))}),1)}}catch(e){console.warn(e)}}connectedCallback(){super.connectedCallback(),this.animationConfig={fade:{name:"fade-in-animation",node:this.shadowRoot.querySelector("#viewer")}},setTimeout((()=>{this.dzi&&this._openseadragonLoaded()}),0)}disconnectedCallback(){super.disconnectedCallback(),this.windowControllers.abort()}_initOpenSeadragon(){setTimeout((()=>{var e=[this.src].filter((e=>!!e));this.dzi||(e=e.map((e=>({type:"image",url:e,buildPyramid:!1})))),this.viewer||(this.viewer=new OpenSeadragon({element:this.shadowRoot.querySelector("#viewer"),prefixUrl:`${new URL("./img-pan-zoom.js",import.meta.url).href}/../lib/openseadragon/images/`,visibilityRatio:this.visibilityRatio,constrainDuringPan:this.constrainDuringPan,showNavigationControl:this.showNavigationControl,showNavigator:this.showNavigator,zoomPerClick:this.zoomPerClick,zoomPerScroll:this.zoomPerScroll,animationTime:this.animationTime,navPrevNextWrap:this.navPrevNextWrap,showRotationControl:this.showRotationControl,minZoomImageRatio:this.minZoomImageRatio,maxZoomPixelRatio:this.maxZoomPixelRatio,showNavigationControl:this.showNavigationControl,navigatorAutoFade:this.navigatorAutoFade,navigatorPosition:this.navigatorPosition,navigatorLeft:this.navigatorLeft,navigatorTop:this.navigatorTop,navigatorRight:this.navigatorRight,navigatorBottom:this.navigatorBottom,navigatorWidth:this.navigatorWidth,navigatorHeight:this.navigatorHeight,sequenceMode:this.sequenceMode,preserveViewport:this.preserveViewport,showReferenceStrip:this.showReferenceStrip,referenceStripScroll:this.referenceStripScroll,flipped:this.flipToggled,previousButton:this.previousButton,nextButton:this.nextButton,homeButton:this.homeButton,fullScreenButton:this.fullScreenButton,zoomInButton:this.zoomInButton,zoomOutButton:this.zoomOutButton,tileSources:e})),this.viewer&&(this.viewer.goToPage(0),this._setFullscreen(),this.viewer.navigator&&this.viewer.navigator.element&&(this.viewer.navigator.element.style.display=this.navigatorToggled?"inline-block":"none")),this.viewer.addHandler("zoom",(e=>this.dispatchEvent(new CustomEvent("zoom",{detail:{value:e}})))),this.viewer.addHandler("page",(e=>this.dispatchEvent(new CustomEvent("page",{detail:{value:e}})))),this.viewer.addHandler("pan",(e=>this.dispatchEvent(new CustomEvent("pan",{detail:{value:e}})))),this.viewer.addHandler("rotate",(e=>this.dispatchEvent(new CustomEvent("pan",{detail:{value:e}})))),this.viewer.addHandler("update-viewport",(e=>this.dispatchEvent(new CustomEvent("update-viewport",{detail:{value:e}})))),this.viewer.addHandler("viewport-changed",(e=>this.dispatchEvent(new CustomEvent("viewport-changed",{detail:{value:e}})))),this.init=!0}),100)}_setFullscreen(e=this.fullscreenToggled){this.viewer&&this.viewer.setFullScreen(e)}destroy(){this.viewer.destroy()}rotateTo(e=90){this.viewer.viewport.setRotation(e)}rotate(e=90){this.rotateTo(e+this.viewer.viewport.getRotation())}pan(e=0,t=.2){this.viewer.viewport.getBounds();this.viewer.viewport.panBy(new OpenSeadragon.Point(e,t))}zoomIn(e=.7){var t=this.viewer.viewport.getZoom()+e;t<this.viewer.viewport.getMaxZoom()&&this.viewer.viewport.zoomTo(t)}zoomOut(e=.7){var t=this.viewer.viewport.getZoom(),i=this.viewer.viewport.getMinZoom(),o=t-e;o>i?this.viewer.viewport.zoomTo(o):i!=t&&this.resetZoom()}toggleFullscreen(e=!this.fullscreenToggled){this.fullscreenToggled=e}toggleFlip(e=!this.flipToggled){this.flipToggled=e}resetZoom(){this.viewer.viewport.goHome()}_srcChanged(){this.dzi&&this.init&&this._addTiledImage()}loadedChangedEvent(e){this.loaded=e.detail.value,this.loaded&&(this.loading=!1)}loadingChangedEvent(e){this.loading=e.detail.value}_loadedChanged(){this.loaded&&(this.init?this._addImage():setTimeout((()=>{this._openseadragonLoaded()}),100))}_addImage(){this.viewer.addSimpleImage({url:this.src,index:0,replace:!0})}_addTiledImage(){this.viewer.addTiledImage({tileSource:this.src,index:0,replace:!0})}}customElements.define(ImgPanZoom.tag,ImgPanZoom);export{ImgPanZoom};