import{LitElement as t,html as i,css as o}from"../../lit/index.js";import"../simple-icon/simple-icon.js";import"../simple-icon/lib/simple-icons.js";import"../simple-icon/lib/simple-icon-button.js";import"../img-pan-zoom/img-pan-zoom.js";class ImageInspector extends t{static get styles(){return[o`
        :host {
          display: block;
          overflow: hidden;
        }

        simple-icon-button {
          display: inline-flex;
          --simple-icon-width: 36px;
          --simple-icon-height: 36px;
          margin: 0 4px;
          padding: 0 4px;
          border-radius: 0;
          background-color: var(--image-inspector-background-color, #fdfdfd);
          transition: 0.3s all ease-in-out;
        }
        simple-icon-button:hover,
        simple-icon-button:focus,
        simple-icon-button:active {
          background-color: var(
            --image-inspector-background-color-active,
            #dddddd
          );
        }

        img-pan-zoom.top-rotated {
          top: 150px;
          pointer-events: none; /** disable pointer events when rotated bc of HTML canvas issue */
          height: var(--image-inspector-height-rotated, 600px);
        }
        img-pan-zoom {
          --img-pan-zoom-height: var(--image-inspector-height, 600px);
        }
        .wrap {
          justify-content: center;
          display: flex;
        }
        .internal-btn-wrap {
          border: 2px solid black;
          background-color: var(--image-inspector-background-color, #fdfdfd);
        }
      `]}constructor(){super(),this.noLeft=!1,this.degrees=0,this.src=""}render(){return i`
      <div class="wrap">
        <div class="internal-btn-wrap">
          <simple-icon-button
            label="Zoom in"
            icon="zoom-in"
            @click="${this.zoomIn}"
          ></simple-icon-button>
          <simple-icon-button
            label="Zoom out"
            icon="zoom-out"
            @click="${this.zoomOut}"
          ></simple-icon-button>
          <simple-icon-button
            label="Rotate right"
            icon="image:rotate-right"
            @click="${this.rotateRight}"
          ></simple-icon-button>
          <simple-icon-button
            label="Mirror image"
            icon="image:flip"
            @click="${this.mirrorImage}"
          ></simple-icon-button>
          <a href="${this.src}" target="_blank" rel="noopener noreferrer">
            <simple-icon-button
              label="Open in new window"
              icon="launch"
            ></simple-icon-button>
          </a>
          <slot name="toolbar"></slot>
        </div>
      </div>
      <img-pan-zoom id="img" src="${this.src}"></img-pan-zoom>
      <slot></slot>
    `}static get tag(){return"image-inspector"}static get properties(){return{noLeft:{type:Boolean,attribute:"no-left"},degrees:{type:Number,reflect:!0},src:{type:String},hoverClass:{type:String,attribute:"hover-class"}}}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.__img=this.shadowRoot.querySelector("#img")}rotateRight(){this.degrees+=90,this.__img.style.transform="rotate("+this.degrees+"deg)",this.__img.classList.contains("top-rotated")?this.__img.classList.remove("top-rotated"):this.__img.classList.add("top-rotated")}mirrorImage(){"scaleX(1)"===this.__img.style.transform?this.__img.style.transform="scaleX(-1)":this.__img.style.transform="scaleX(1)"}zoomIn(){this.__img.zoomIn()}zoomOut(){this.__img.zoomOut()}}customElements.define(ImageInspector.tag,ImageInspector);export{ImageInspector};