import{html as t,css as i}from"../../lit/index.js";import{SchemaBehaviors as e}from"../schema-behaviors/schema-behaviors.js";import{IntersectionObserverMixin as o}from"../intersection-element/lib/IntersectionObserverMixin.js";import{I18NMixin as r}from"../i18n-manager/lib/I18NMixin.js";import{SimpleColors as s}from"../simple-colors/simple-colors.js";class ImageCompareSlider extends(r(o(e(s)))){static get styles(){return[i`
        :host {
          display: block;
        }
        :host([hidden]) {
          display: none !important;
        }
        a11y-compare-image {
          max-width: var(--image-compare-slider-max-width, 400px);
        }
        a11y-compare-image img {
          max-width: var(--image-compare-slider-max-width, 400px);
          max-height: var(--image-compare-slider-max-height, 600px);
        }
      `]}constructor(){super(),this.opacity=!1,this.topAlt="",this.bottomAlt="",this.position=50,this.accentColor="blue",this.t={slideToCompareImages:"Slide to compare images"},this.registerLocalization({context:this,basePath:import.meta.url,locales:["es"]})}render(){return t`${this.elementVisible?t`
          <a11y-compare-image
            label="${this.t.slideToCompareImages}"
            accent-color="${this.accentColor}"
            ?dark="${this.dark}"
            ?opacity="${this.opacity}"
            position="${this.position}"
          >
            <div slot="heading">
              ${this.title?t` <h2>${this.title}</h2> `:""}
              <slot name="heading"></slot>
            </div>
            <div id="description" slot="description">
              <slot name="description"></slot>
            </div>
            <img
              slot="bottom"
              src="${this.bottomSrc}"
              alt="${this.bottomAlt}"
              aria-describedby="${this.bottomDescriptionId||"description"}"
            />
            <img
              slot="top"
              src="${this.topSrc}"
              alt="${this.topAlt}"
              aria-describedby="${this.topDescriptionId||"description"}"
            />
          </a11y-compare-image>
        `:""}`}static get tag(){return"image-compare-slider"}static get properties(){return{...super.properties,bottomAlt:{type:String,attribute:"bottom-alt"},bottomDescriptionId:{type:String,attribute:"bottom-description-id"},bottomSrc:{type:String,attribute:"bottom-src"},opacity:{type:Boolean},position:{type:Number},title:{type:String},topAlt:{type:String,attribute:"top-alt"},topDescriptionId:{type:String,attribute:"top-description-id"},topSrc:{type:String,attribute:"top-src"}}}updated(t){super.updated&&super.updated(t),t.forEach(((t,i)=>{"elementVisible"===i&&this[i]&&import("../a11y-compare-image/a11y-compare-image.js")}))}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(ImageCompareSlider.tag,ImageCompareSlider);export{ImageCompareSlider};