/**
 * Copyright 2021 collinkleest
 * @license MIT, see License.md for full text.
 */
import{LitElement as e,html as t,css as r}from"../../lit/index.js";class HexPicker extends e{static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Hex Picker",description:"Hexcode color picker",icon:"image:colorize",color:"grey",tags:["Other","dev","developer"],handles:[],meta:{author:"collinkleest",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"value",title:"Value",description:"Default hex value",inputMethod:"textfield"},{property:"disabled",title:"Disabled",description:"Disable the text field",inputMethod:"boolean"},{property:"largeDisplay",title:"Large Display",description:"Include color in large display",inputMethod:"boolean"}],advanced:[]},demoSchema:[{tag:"hex-picker",properties:{org:"haxtheweb",repo:"webcomponents"},content:""}]}}static get properties(){return{...super.properties,value:{type:String,reflect:!0},disabled:{type:Boolean,reflect:!0},largeDisplay:{type:Boolean,reflect:!0,attribute:"large-display"}}}static get styles(){return[r`
        :host {
          --color-picker-width: 200px;
          --color-picker-input-margin: 5px;
          --color-picker-input-padding: 5px;
          display: flex;
          flex-direction: column;
        }

        .input-container {
          display: inline-flex;
          align-items: center;
          box-sizing: border-box;
          width: var(--color-picker-width);
        }

        .color-square {
          background-color: #000000ff;
          border: 1px dotted black;
          width: var(--color-picker-square-width, 15px);
          height: var(--color-picker-square-height, 15px);
          margin-left: -35px;
        }

        .slider-container {
          width: var(--color-picker-width);
        }

        fieldset {
          border: none;
          display: flex;
          align-items: center;
        }

        .text-input {
          margin-top: var(--color-picker-input-margin);
          margin-bottom: var(--color-picker-input-margin);
          padding: var(--color-picker-input-padding);
          width: calc(
            var(--color-picker-width) - 8px - var(--color-picker-input-margin)
          );
        }

        .large-display {
          width: var(--color-picker-width);
          height: var(--color-picker-lg-block-height, 100px);
          background-color: #000000ff;
          border: 1px dotted black;
          border-radius: 2px;
        }
      `]}static get tag(){return"hex-picker"}constructor(){super(),this.value="#000000FF",this._rValue=0,this._gValue=0,this._bValue=0,this._oValue=255,this.disabled=!1}render(){return t`
      ${this.largeDisplay?t`<div class="large-display"></div>`:""}
      <div class="input-container">
        <input
          aria-label="HEX code"
          class="text-input"
          maxlength="9"
          @input="${this._inputChanged}"
          @keydown="${this._validateInput}"
          .disabled=${this.disabled}
        />
        <div class="color-square"></div>
      </div>
      <div class="slider-container">
        ${this.renderFieldSet("R")} ${this.renderFieldSet("G")}
        ${this.renderFieldSet("B")} ${this.renderFieldSet("O")}
      </div>
    `}_validateInput(e){String.fromCharCode(e.which).match(/[0-9A-Fa-f\b]/g)||39===e.which||37===e.which||e.preventDefault()}_padHex(e){return e.length<2?"0"+e:e}_computeHex(){let e=this._rValue.toString(16),t=this._gValue.toString(16),r=this._bValue.toString(16),i=this._oValue.toString(16);return"#"+this._padHex(e)+this._padHex(t)+this._padHex(r)+this._padHex(i)}_inputChanged(e){let t=e.target.value;t.startsWith("#")||(t="#"+t),this.shadowRoot.querySelector(".color-square").style.backgroundColor=t,this.value=t,this.largeDisplay&&(this.shadowRoot.querySelector(".large-display").style.backgroundColor=t),this._dispatchChange(t);let r=this._hexToRgb(t);null!==r&&this._updateSliders(r)}_updateSliders(e){this.shadowRoot.querySelector("#R").value=e.r,this.shadowRoot.querySelector("#R_out").value=e.r,this.shadowRoot.querySelector("#G").value=e.g,this.shadowRoot.querySelector("#G_out").value=e.g,this.shadowRoot.querySelector("#B").value=e.b,this.shadowRoot.querySelector("#B_out").value=e.b,this.shadowRoot.querySelector("#O").value=e.o,this.shadowRoot.querySelector("#O_out").value=e.o}_hexToRgb(e){return 4===e.length?{r:parseInt(e[1]+"F",16),g:parseInt(e[2]+"F",16),b:parseInt(e[3]+"F",16),o:0}:5===e.length?{r:parseInt(e[1]+"F",16),g:parseInt(e[2]+"F",16),b:parseInt(e[3]+"F",16),o:parseInt(e[4]+"F",16)}:7===e.length?{r:parseInt(e[1]+e[2],16),g:parseInt(e[3]+e[4],16),b:parseInt(e[5]+e[6],16),o:0}:9===e.length?{r:parseInt(e[1]+e[2],16),g:parseInt(e[3]+e[4],16),b:parseInt(e[5]+e[6],16),o:parseInt(e[7]+e[8],16)}:{r:0,g:0,b:0,o:0}}_fieldSetChange(e){let t=this.shadowRoot.querySelector(`#${e.target.id}_out`),r=this.shadowRoot.querySelector(".color-square"),i=this.shadowRoot.querySelector("input");t.value=e.target.value,"R"===e.target.id?this._rValue=parseInt(e.target.value,10):"G"===e.target.id?this._gValue=parseInt(e.target.value,10):"B"===e.target.id?this._bValue=parseInt(e.target.value,10):"O"===e.target.id&&(this._oValue=parseInt(e.target.value,10));let a=this._computeHex();r.style.backgroundColor=a,i.value=a,this.largeDisplay&&(this.shadowRoot.querySelector(".large-display").style.backgroundColor=a),this._dispatchChange(a)}_dispatchChange(){this.dispatchEvent(new CustomEvent("value-changed",{bubbles:!0,cancelable:!1,composed:!1,detail:this}))}renderFieldSet(e){return t`
      <fieldset>
        <label for="${e}">${e}</label>
        <input
          @input=${this._fieldSetChange}
          type="range"
          min="0"
          max="255"
          id="${e}"
          step="1"
          value="0"
        />
        <output for="${e}" id="${e}_out">0</output>
      </fieldset>
    `}updated(e){e.forEach(((e,t)=>{if("value"===t&&this[t]){this.shadowRoot.querySelector(".color-square").style.backgroundColor=this.value,this.shadowRoot.querySelector("input").value=this.value,this.largeDisplay&&(this.shadowRoot.querySelector(".large-display").style.backgroundColor=this.value);let e=this._hexToRgb(this.value);null!==e&&this._updateSliders(e)}}))}}customElements.define(HexPicker.tag,HexPicker);export{HexPicker};