/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import{HAXCMSLitElementTheme as i}from"../haxcms-elements/lib/core/HAXCMSLitElementTheme.js";import{HAXCMSRememberRoute as a}from"../haxcms-elements/lib/core/utils/HAXCMSRememberRoute.js";import{HAXCMSThemeParts as s}from"../haxcms-elements/lib/core/utils/HAXCMSThemeParts.js";import{SimpleColorsSuper as o}from"../simple-colors/simple-colors.js";import{store as n}from"../haxcms-elements/lib/core/haxcms-site-store.js";import{autorun as r,toJS as l}from"../../mobx/dist/mobx.esm.js";import{varExists as c,varGet as d}from"../utils/utils.js";import"../anchor-behaviors/anchor-behaviors.js";import"../disqus-embed/lib/haxcms-site-disqus.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icon-button-lite.js";import"../simple-icon/lib/simple-icons.js";import"../haxcms-elements/lib/ui-components/layout/site-region.js";import"../full-width-image/full-width-image.js";import"../haxcms-elements/lib/ui-components/query/site-query.js";import"../date-card/lib/date-chip.js";import"../accent-card/accent-card.js";import{DDDSuper as m}from"../d-d-d/d-d-d.js";import"../haxcms-elements/lib/ui-components/active-item/site-active-title.js";class HaxorSlevin extends(s(o(m(i)))){static get styles(){return[super.styles,t`
        :host {
          display: block;
          background-color: var(--ddd-theme-default-coalyGray);
          color: var(--ddd-theme-default-white);
          transition:
            0.6s ease-in-out color,
            0.6s ease-in-out background-color;
        }
        site-modal:not(:defined),
        site-rss-button:not(:defined),
        site-share-widget:not(:defined),
        site-active-title:not(:defined),
        site-git-corner:not(:defined),
        social-share-link:not(:defined) {
          display: none;
        }
        :host([hidden]) {
          display: none;
        }

        /**
        * Hide the slotted content during edit mode. This must be here to work.
        */
        :host([edit-mode]) #slot {
          display: none;
        }
        :host([edit-mode]) accent-card {
          opacity: 0.2;
          pointer-events: none;
        }
        accent-card {
          overflow: hidden;
          font-weight: normal;
        }
        #slot {
          min-height: 50vh;
        }
        site-active-title {
          font-size: 36px;
        }
        site-modal {
          display: inline-flex;
        }
        .wrapper {
          padding-bottom: 80px;
          padding-top: 64px;
        }
        #home {
          max-width: 1032px;
          padding-left: 20px;
          padding-right: 20px;
          margin: 0 auto;
        }
        :host([selected-page="1"]) #home {
          display: none;
        }
        :host([selected-page="0"]) .contentcontainer-wrapper {
          display: none;
        }
        .contentcontainer-wrapper {
          max-width: 900px;
          margin: 0 auto;
          box-sizing: border-box;
          padding-left: 20px;
          padding-right: 20px;
        }
        full-width-image {
          --full-width-image-font-size: 54px;
        }
        date-chip {
          float: right;
          --date-chip-font-size: 40px;
          --date-chip-month-font-size: 24px;
          margin: -64px 16px 16px;
        }
        .article-link,
        .article-link-bottom {
          text-decoration: none;
          opacity: 0.9;
          -webkit-filter: saturate(30%);
          filter: saturate(30%);
          transition:
            0.3s ease-in-out opacity,
            0.3s ease-in-out filter;
          cursor: pointer;
        }
        .article-link:nth-of-type(1) {
          -webkit-filter: saturate(80%);
          filter: saturate(80%);
        }
        .article-link:nth-of-type(2n) {
          -webkit-filter: saturate(30%);
          filter: saturate(30%);
        }
        .article-link accent-card::part(image) {
          -webkit-filter: saturate(0%);
          filter: saturate(0%);
          transition: 0.3s ease-in-out all;
        }
        .article-link:nth-of-type(1) accent-card::part(image) {
          -webkit-filter: saturate(80%);
          filter: saturate(80%);
        }
        .article-link:nth-of-type(2n) accent-card::part(image) {
          -webkit-filter: saturate(30%);
          filter: saturate(30%);
        }
        .article-link:focus accent-card::part(image),
        .article-link:hover accent-card::part(image) {
          -webkit-filter: saturate(200%);
          filter: saturate(200%);
        }
        .article-link-bottom:focus,
        .article-link-bottom:hover,
        .article-link:focus,
        .article-link:hover {
          opacity: 1;
          -webkit-filter: saturate(100%);
          filter: saturate(100%);
        }
        .article-link:hover span {
          text-decoration: underline;
        }
        .header-wrapper {
          padding: 12px 24px;
          display: flex;
          margin: 0 auto;
          z-index: 100;
          color: var(--simple-colors-default-theme-accent-1);
          justify-content: center;
          box-shadow: 0 4px 12px 0 rgba(0, 0, 0, 0.15);
          background-color: var(--simple-colors-default-theme-accent-10);
        }
        .header-wrapper div {
          display: inline-flex;
        }
        .backbutton {
          height: 54px;
          cursor: pointer;
          text-align: center;
          line-height: 32px;
          background-color: transparent;
          border: none;
          display: inline-flex;
          color: var(--simple-colors-default-theme-accent-1);
          min-width: 100px;
          text-transform: unset;
          margin: 0px 16px;
        }

        .social-float {
          top: 160px;
          position: fixed;
          z-index: 99;
          margin-left: -10vw;
          opacity: 1;
          transition: 0.2s opacity linear;
        }
        .social-float.disable-items {
          pointer-events: none;
          opacity: 0.2 !important;
        }
        .social-float ul {
          padding: 0;
          margin: 0;
          list-style: none;
        }

        site-share-widget {
          --site-share-widget-bg: var(--haxcms-color, rgba(255, 0, 116, 1));
        }
        site-share-widget:hover,
        site-share-widget:focus,
        site-share-widget:active {
          --site-share-widget-bg: var(--haxcms-system-action-color, blue);
        }

        social-share-link {
          --social-share-button-color: var(
            --simple-colors-default-theme-accent-1
          );
          --social-share-button-bg: var(--simple-colors-default-theme-accent-7);
          --social-share-button-padding: 8px;
          --social-share-button-border-radius: 50%;
          --social-share-button-hover-bg: var(
            --simple-colors-default-theme-accent-10
          );
          --social-share-button-hover-color: var(
            --simple-colors-default-theme-accent-2
          );
        }

        .annoy-user {
          color: var(--simple-colors-default-theme-accent-12);
          background-color: var(--simple-colors-default-theme-accent-2);
          display: block;
          position: fixed;
          bottom: 0;
          left: 0;
          overflow: hidden;
          right: 0;
          box-shadow: 0 -3px 10px 0 rgba(0, 0, 0, 0.0785);
          padding: 10px 0;
          height: 36px;
          z-index: 100;
          opacity: 1;
          transition: 0.2s opacity linear;
        }
        .annoy-user.disable-items {
          pointer-events: none;
          opacity: 0 !important;
        }
        simple-icon-lite {
          height: 40px;
          width: 40px;
          --simple-icon-height: 40px;
          --simple-icon-width: 40px;
          display: flex;
          padding-right: 20px;
        }
        .annoy-user span {
          flex: 1 1 auto;
          height: 40px;
          display: flex;
          vertical-align: middle;
          line-height: 40px;
        }
        .annoy-inner strong {
          padding: 0 4px;
        }
        .annoy-user .rss {
          margin-left: 50px;
        }
        .annoy-inner {
          max-width: 800px;
          margin: 0 auto;
          display: flex;
        }
        .subtitle {
          font-family: "Lucida Grande", "Lucida Sans Unicode", "Lucida Sans",
            Geneva, Arial, sans-serif;
          letter-spacing: -0.02em;
          font-weight: 300;
          font-style: normal;
          letter-spacing: 0;
          font-size: 28px;
          line-height: 1.22;
          letter-spacing: -0.012em;
        }
        site-rss-button {
          margin: 0 4px;
          padding: 0;
          color: var(--simple-colors-default-theme-accent-12);
          --site-rss-color: var(--simple-colors-default-theme-accent-10);
          --site-rss-bg-color: var(--simple-colors-default-theme-accent-10);
          --site-rss-simple-icon-button-padding: 0 4px;
          --site-rss-simple-icon-button-margin: 0;
        }

        @media screen and (max-width: 800px) {
          #contentcontainer,
          #home {
            padding-left: 8px;
            padding-right: 8px;
            transition: 0.5s opacity ease-in-out;
          }
          .hide-small {
            display: none !important;
          }
          .annoy-user {
            display: none;
          }
        }
      `]}render(){return e`
      <header class="header-wrapper">
        <div>
          <site-modal
            @site-modal-click="${this.siteModalClick}"
            icon="icons:search"
            title="Search site"
            button-label="Search"
            dark
          >
            <site-search></site-search>
          </site-modal>
        </div>
        <div>
          <simple-icon-button-lite
            class="backbutton"
            @click="${this._goBack}"
            icon="${this.icon}"
          >
            <span class="hide-small">Home</span>
          </simple-icon-button-lite>
        </div>
        <site-region name="header"></site-region>
      </header>
      <div class="wrapper">
        <div id="home">
          <site-query
            @result-changed="${this.__mainPostsChanged}"
            limit="10"
            sort='{"created": "ASC"}'
          ></site-query>
          ${this.__mainPosts.map((t=>e` <a class="article-link" href="${t.slug}">
                <accent-card
                  image-align="center"
                  image-valign="top"
                  accent-background
                  accent-color="${this.color}"
                  accent-heading
                  horizontal
                  image-src="${t.metadata&&t.metadata.image?t.metadata.image:this.image}"
                >
                  <div slot="heading"><h3>${t.title}</h3></div>
                  <p slot="content">
                    <date-chip
                      unix
                      timestamp="${t.metadata.created}"
                      accent-color="${this.color}"
                    ></date-chip>
                    ${t.description}
                  </p>
                </accent-card></a
              >`))}
          <site-region name="footerPrimary"></site-region>
        </div>
        <main class="contentcontainer-wrapper">
          <article id="contentcontainer">
            <site-region name="contentTop"></site-region>
            <site-git-corner position="right"></site-git-corner>
            ${this.activeItem&&this.activeItem.metadata&&this.activeItem.metadata.image?e`<full-width-image
                  source="${this.activeItem.metadata.image}"
                  caption="${this.activeItem.title}"
                ></full-width-image>`:e`<site-active-title></site-active-title>`}
            <h3 class="subtitle" .hidden="${!this.subtitle}">
              ${this.subtitle}
            </h3>
            <section id="slot">
              <slot></slot>
            </section>
            <site-region name="contentBottom"></site-region>
          </article>
          <site-query
            @result-changed="${this.__followUpPostsChanged}"
            limit="6"
            start-index="${this.activeManifestIndexCounter}"
            sort='{"created": "ASC"}'
          ></site-query>
          ${this.__followUpPosts.map((t=>e`
              <a class="article-link-bottom" href="${t.slug}">
                <accent-card
                  image-align="center"
                  image-valign="top"
                  accent-background
                  accent-color="${this.color}"
                  accent-heading
                  horizontal
                  image-src="${t.metadata&&t.metadata.image?t.metadata.image:this.image}"
                >
                  <div slot="heading"><h3>${t.title}</h3></div>
                  <div slot="subheading">
                    <simple-datetime
                      unix
                      timestamp="${t.metadata.created}"
                    ></simple-datetime>
                  </div>
                  <div slot="content">
                    <p>${t.description}</p>
                  </div>
                </accent-card></a
              >
            `))}
          <nav class="social-float hide-small ${this.stateClass}">
            <ul>
              <li>
                <social-share-link
                  title="Share on twitter"
                  button-style
                  mode="icon-only"
                  message="${this.shareMsg}"
                  type="Twitter"
                >
                </social-share-link>
              </li>
              <li>
                <social-share-link
                  title="Share on LinkedIn"
                  button-style
                  mode="icon-only"
                  message="${this.shareMsg}"
                  url="${this.shareUrl}"
                  type="LinkedIn"
                >
                </social-share-link>
              </li>
              <li>
                <social-share-link
                  title="Share on Facebook"
                  button-style
                  mode="icon-only"
                  url="${this.shareUrl}"
                  message="${this.shareMsg}"
                  type="Facebook"
                >
                </social-share-link>
              </li>
              <li>
                <social-share-link
                  title="Share on Pinterest"
                  button-style
                  mode="icon-only"
                  message="${this.shareMsg}"
                  image="${this.activeImage}"
                  url="${this.shareUrl}"
                  type="Pinterest"
                >
                </social-share-link>
              </li>
            </ul>
          </nav>
          <footer class="annoy-user ${this.stateClass}">
            <div class="annoy-inner">
              <simple-icon-lite
                icon="${this.icon}"
                class="hide-small"
              ></simple-icon-lite>
              <span class="hide-small">
                Never miss a story from <strong>${this.title}</strong> use RSS
                today!
              </span>
              <span class="rss">
                <site-rss-button type="atom"></site-rss-button>
                <site-rss-button type="rss"></site-rss-button>
              </span>
              <site-share-widget
                alt="Share on social media"
              ></site-share-widget>
            </div>
          </footer>
        </main>
      </div>
    `}static get tag(){return"haxor-slevin"}__mainPostsChanged(e){this.__mainPosts=e.detail.value}__followUpPostsChanged(e){var t=[];if(this.activeItem&&this.activeItem.metadata&&this.activeItem.metadata.relatedItems){this.activeItem.metadata.relatedItems.split(",").map((e=>{n.findItem(e)&&t.push(l(n.findItem(e)))}))}else t=e.detail.value;this.__followUpPosts=t}static get properties(){return{...super.properties,color:{type:String},selectedPage:{type:Number,reflect:!0,attribute:"selected-page"},activeManifestIndexCounter:{type:Number},activeItem:{type:Object},stateClass:{type:String},__mainPosts:{type:Array},__followUpPosts:{type:Array}}}_getStateClass(e){return e?"disable-items":""}_getColor(e){if(e&&c(e,"metadata.theme.variables.cssVariable"))return e.metadata.theme.variables.cssVariable.replace("--simple-colors-default-theme-","").replace("-7","")}siteModalClick(e){import("../haxcms-elements/lib/ui-components/site/site-search.js")}constructor(){super(),this.icon="icons:search",this.__disposer=[],this.__mainPosts=[],this.__followUpPosts=[],this.activeItem={},this.selectedPage=0,this.activeManifestIndexCounter=0,r((e=>{let t=l(n.location);this._noticeLocationChange(t),this.__disposer.push(e)})),r((e=>{let t=l(n.manifest);this.color=this._getColor(t),this.title=d(t,"title",""),this.image=d(t,"metadata.theme.variables.image","assets/banner.jpg"),this.icon=d(t,"metadata.theme.variables.icon","icons:record-voice-over"),this.author=d(t,"metadata.author",{}),this.__disposer.push(e)})),r((e=>{this.activeManifestIndexCounter=l(n.activeManifestIndexCounter),this.__disposer.push(e)})),r((e=>{this.activeTitle=l(n.activeTitle),this.shareUrl=globalThis.document.location.href,this.shareMsg=this.activeTitle+" "+this.shareUrl,this.__disposer.push(e)})),r((e=>{this.activeItem=l(n.activeItem),this.__disposer.push(e)}))}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),import("../haxcms-elements/lib/ui-components/active-item/site-share-widget.js"),import("../haxcms-elements/lib/ui-components/active-item/site-git-corner.js"),import("../haxcms-elements/lib/ui-components/site/site-rss-button.js"),import("../social-share-link/social-share-link.js"),import("../haxcms-elements/lib/ui-components/layout/site-modal.js"),setTimeout((()=>{let e=l(n.location);this._noticeLocationChange(e)}),1e3)}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"editMode"==t&&(this.stateClass=this._getStateClass(this[t]))}))}_noticeLocationChange(e){if(!e||void 0===e.route)return;const t=e.route.name;"home"===t||"404"===t?this.selectedPage=0:(globalThis.scrollTo({top:0,left:0}),this.selectedPage=1,setTimeout((()=>{globalThis.AnchorBehaviors.getTarget(n.themeElement)}),1e3)),setTimeout((()=>{globalThis.dispatchEvent(new Event("resize"))}),50)}disconnectedCallback(){for(var e in this.__disposer)this.__disposer[e].dispose();super.disconnectedCallback()}_goBack(e){globalThis.history.pushState(null,null,n.location.baseUrl),globalThis.dispatchEvent(new PopStateEvent("popstate")),globalThis.scrollTo({top:0,left:0});const t=new CustomEvent("json-outline-schema-active-item-changed",{bubbles:!0,cancelable:!0,composed:!0,detail:{}});this.dispatchEvent(t),this.selectedPage=0}}customElements.define(HaxorSlevin.tag,HaxorSlevin);export{HaxorSlevin};