/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t}from"../../../../../@polymer/polymer/polymer-element.js";let MinimalistTemplate=i=>class extends i{constructor(){super(),import("../../../../scroll-button/scroll-button.js"),import("../active-item/site-active-title.js"),import("../active-item/site-active-fields.js"),import("../blocks/site-children-block.js"),import("../layout/site-footer.js"),import("../layout/site-modal.js"),import("../navigation/site-breadcrumb.js"),import("../navigation/site-top-menu.js"),import("../navigation/site-menu-button.js"),import("../navigation/site-menu.js"),import("../site/site-rss-button.js"),import("../site/site-print-button.js"),import("../site/site-title.js")}static get template(){return t`
        <site-top-menu
          noink
          notitle
          showindex
          sticky
          conditions='{"parent": "$firstId"}'
        >
          <div slot="prefix" class="spacing">
            <site-title icon="home" notitle></site-title>
          </div>
          <div slot="prefix" class="spacing">
            <site-print-button></site-print-button>
          </div>
        </site-top-menu>
        <site-active-fields fields="{{activeItemFields}}"></site-active-fields>
        <header
          class="masthead"
          style$="background-image: url('[[activeItemFields.images.0.src]]');"
          alt$="[[activeItemFields.images.0.alt]]"
        >
          <div class="overlay"></div>
          <div class="container">
            <div class="row">
              <div class="col-lg-10 col-md-10 mx-auto">
                <div class="page-heading">
                  <h1>[[activeItemFields.title]]</h1>
                  <h2>[[activeItemFields.subtitle]]</h2>
                  <span class="subheading"></span>
                </div>
              </div>
            </div>
          </div>
        </header>
        <div class="container">
          <div id="contentcontainer">
            <div id="slot"><slot></slot></div>
          </div>
        </div>
        <hr />
        <site-top-menu
          noink
          notitle
          indicator="none"
          position="top"
          showindex
          conditions='{"parent": "$firstId"}'
        >
          <div slot="prefix" class="spacing">
            <site-title icon="home" notitle position="top"></site-title>
          </div>
          <div slot="prefix" class="spacing">
            <site-print-button position="top"></site-print-button>
          </div>
          <div slot="prefix" class="spacing">
            <site-menu-button type="prev" position="top"></site-menu-button>
          </div>
          <div slot="suffix" class="spacing">
            <site-menu-button type="next" position="top"></site-menu-button>
          </div>
        </site-top-menu>
        <hr />
        <site-footer></site-footer>
        <scroll-button position="right" label="Back to top"> </scroll-button>
      `}};class Minimalist extends(MinimalistTemplate(HTMLElement)){}customElements.define("minimalist-template",Minimalist);export{MinimalistTemplate,Minimalist};