/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t}from"../../../../../lit/index.js";import"../../../../grid-plate/grid-plate.js";let BasicTemplate=i=>class extends i{constructor(){super(),import("../../../../simple-icon/simple-icon.js"),import("../../../../simple-icon/lib/simple-icons.js"),import("../../../../scroll-button/scroll-button.js"),import("../active-item/site-active-title.js"),import("../blocks/site-children-block.js"),import("../blocks/site-outline-block.js"),import("../blocks/site-recent-content-block.js"),import("../layout/site-footer.js"),import("../layout/site-modal.js"),import("../navigation/site-breadcrumb.js"),import("../navigation/site-dot-indicator.js"),import("../navigation/site-menu-button.js"),import("../navigation/site-menu.js"),import("../navigation/site-top-menu.js"),import("../query/site-query-menu-slice.js"),import("../query/site-query.js"),import("../site/site-print-button.js"),import("../site/site-rss-button.js"),import("../site/site-search.js"),import("../site/site-title.js"),import("../magic/active-when-visible.js")}render(){return t`
        <site-top-menu noink indicator="arrow" arrow-size="8">
          <site-title slot="prefix" class="spacing"></site-title>
          <site-modal
            slot="suffix"
            icon="maps:directions"
            title="View site map"
            button-label="Site map"
          >
            <site-menu></site-menu>
          </site-modal>
          <site-modal
            slot="suffix"
            icon="icons:search"
            title="Search site"
            button-label="Search"
          >
            <site-search></site-search>
          </site-modal>
        </site-top-menu>
        <div class="container">
          <site-breadcrumb></site-breadcrumb>
          <grid-plate layout="1-3" class="grid-wrapper" ignore-hax>
            <div slot="col-1" class="left-col">
              <div class="menu-buttons">
                <site-menu-button type="prev" position="top"></site-menu-button>
                <site-menu-button type="next" position="top"></site-menu-button>
              </div>
              <site-active-title
                dynamic-methodology="ancestor"
              ></site-active-title>
              <site-children-block
                dynamic-methodology="ancestor"
              ></site-children-block>

              <div class="buttons">
                <site-rss-button type="atom"></site-rss-button>
                <site-rss-button type="rss"></site-rss-button>
                <site-print-button
                  slot="suffix"
                  type="ancestor"
                ></site-print-button>
              </div>
            </div>
            <div id="contentcontainer" slot="col-2">
              <div id="slot"><slot></slot></div>
            </div>
          </grid-plate>
        </div>
        <site-footer></site-footer>
        <scroll-button position="right" label="Back to top"></scroll-button>
      `}};class Basic extends(BasicTemplate(HTMLElement)){}customElements.define("basic-template",Basic);export{BasicTemplate,Basic};