/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as i,html as t,css as e}from"../../../../../lit/index.js";import{store as s}from"../../core/haxcms-site-store.js";import{autorun as o,toJS as l}from"../../../../../mobx/dist/mobx.esm.js";import{HAXCMSI18NMixin as r}from"../../core/utils/HAXCMSI18NMixin.js";import"../../../../simple-icon/lib/simple-icon-lite.js";import"../../../../simple-icon/lib/simple-icons.js";import{HAXCMSThemeParts as n}from"../../core/utils/HAXCMSThemeParts.js";class SiteTitle extends(n(r(i))){static get styles(){return[super.styles,e`
        :host {
          display: block;
          text-rendering: optimizelegibility;
          position: relative;
          color: inherit;
          --simple-icon-width: 32px;
          --simple-icon-height: 32px;
        }
        a {
          color: inherit;
          display: var(--site-title-link-display, block);
          text-decoration: var(--site-title-link-text-decoration);
        }
        simple-icon-lite {
          margin-right: 8px;
        }
        a h1 {
          display: var(--site-title-link-h1-display, block);
          color: inherit;
          text-rendering: optimizelegibility;
          font-family: var(--site-title-heading-font-family);
          font-size: var(--site-title-heading-font-size);
          margin: var(--site-title-heading-margin);
          padding: var(--site-title-heading-padding);
          text-align: var(--site-title-heading-text-align);
          text-rendering: var(--site-title-heading-text-rendering);
          font-weight: var(--site-title-heading-font-weight);
          line-height: var(--site-title-heading-font-size);
        }
      `]}static get tag(){return"site-title"}constructor(){super(),this.HAXCMSI18NMixinBase="../../../",this.__disposer=[],this.icon=null,this.t={home:"Home"},this.notitle=!1,o((i=>{this.siteTitle=l(s.siteTitle),this.__disposer.push(i)})),o((i=>{this.homeLink=l(s.homeLink),this.__disposer.push(i)})),o((i=>{this.editMode=l(s.editMode),this.__disposer.push(i)}))}_editClick(i){(this.disabled||this.editMode)&&i.preventDefault()}render(){return t`
      <a
        href="${this.homeLink}"
        title="${this.t.home}"
        @click="${this._editClick}"
        .part="${this.editMode?"edit-mode-active":""}"
        ?disabled="${this.disabled||this.editMode}"
      >
        <simple-icon-lite
          ?hidden="${!this.icon}"
          icon="${this.icon}"
        ></simple-icon-lite>
        ${this.notitle?"":t` <h1>${this.siteTitle}</h1> `}
      </a>
    `}static get properties(){return{...super.properties,disabled:{type:Boolean,reflect:!0},editMode:{type:Boolean,attribute:"edit-mode",reflect:!0},siteTitle:{type:String,attribute:"site-title"},homeLink:{type:String,attribute:"home-link"},icon:{type:String},notitle:{type:Boolean,reflect:!0}}}disconnectedCallback(){for(var i in this.__disposer)this.__disposer[i].dispose();super.disconnectedCallback()}}customElements.define(SiteTitle.tag,SiteTitle);export{SiteTitle};