/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../../../lit/index.js";import"../../../../simple-fields/lib/simple-fields-field.js";import"../../../../simple-icon/simple-icon.js";import"../../../../simple-icon/lib/simple-icons.js";import"../../../../iframe-loader/lib/loading-indicator.js";import{store as a,HAXcmsStore as s}from"../../core/haxcms-site-store.js";import{HAXCMSI18NMixin as r}from"../../core/utils/HAXCMSI18NMixin.js";import{DDD as l}from"../../../../d-d-d/d-d-d.js";import"../../../../simple-fields/lib/simple-tag.js";import"../../../../lunr-search/lunr-search.js";import"../../../../simple-datetime/simple-datetime.js";class SiteSearch extends(r(l)){static get styles(){return[super.styles,i`
        :host {
          display: block;
          color: light-dark(var(--ddd-primary-4), var(--ddd-accent-6));
        }
        [hidden] {
          display: none;
        }
        a.result {
          display: block;
          background-color: var(
            --site-search-result-background-color,
            var(--ddd-theme-default-limestoneLight, #ddd)
          );
          color: var(--site-search-result-color, #222222);
          padding: var(--ddd-spacing-2);
          margin: var(--ddd-spacing-2) 0;
          font-weight: var(--ddd-font-weight-regular);
          transition: background-color 0.3s ease-in-out;
        }

        .result:hover,
        .result:focus {
          background-color: var(
            --site-search-result-background-color-hover,
            var(--ddd-theme-default-infoLight)
          );
          color: var(
            --site-search-link-color-hover,
            var(--ddd-theme-default-info, #000)
          );
          text-decoration: none;
          outline: 3px solid var(--ddd-theme-default-info);
        }
        .result .title {
          font-size: var(--ddd-font-size-xs);
          margin: 0 0 var(--ddd-spacing-4) 0;
          font-weight: var(--ddd-font-weight-medium);
        }
        .result {
          color: var(--site-search-link-color, #444444);
          text-decoration: none;
        }
        simple-datetime {
          color: var(--site-search-link-color, #444444);
        }
        simple-icon-lite {
          --simple-icon-height: 12px;
          --simple-icon-width: 12px;
          vertical-align: baseline;
        }
        .result .link-text {
          font-size: 12px;
          color: var(--site-search-link-text-color, #999999);
          font-style: italic;
          padding-left: 8px;
        }
        .results-found-text {
          font-family: var(--ddd-font-secondary);
          margin-bottom: 1.5rem;
          padding-bottom: 0.5rem;
        }
        #search {
          flex-grow: 2;
          margin-right: 4px;
          margin-bottom: 0;
          font-size: var(--ddd-font-size-xs);
        }
        .page-title-icon {
          --simple-icon-height: 32px;
          --simple-icon-width: 32px;
          margin-right: 8px;
          vertical-align: middle;
        }
        simple-tag {
          margin: 0 4px;
        }
      `]}static get tag(){return"site-search"}constructor(){super(),this.HAXCMSI18NMixinBase="../../../",this.t=this.t||{},this.t={...this.t,search:"Search",results:"results",found:"Found",typeAtLeast3LettersToStartSearch:"Type at least 3 letters to start search"},this.whileLoading=!1,this.hideInput=!1,this.search="",this.showPath=!1,this.showDate=!1,this.__results=[]}render(){return t`
      <simple-fields-field
        ?hidden="${this.hideInput}"
        id="search"
        always-float-label
        label="${this.t.search}"
        placeholder="${this.t.typeAtLeast3LettersToStartSearch}.."
        type="text"
        value="${this.search}"
        @value-changed="${this._searchValueChanged}"
      >
        <simple-icon icon="search" slot="prefix"></simple-icon>
      </simple-fields-field>
      ${this.search.length>0?t`
            <h1 class="results-found-text">
              ${this.t.found} ${this.__results.length} ${this.t.results}.
            </h1>
          `:t``}
      <lunr-search id="lunr"></lunr-search>
      <loading-indicator
        full
        ?loading="${this.whileLoading}"
      ></loading-indicator>
      ${this.__results.map((e=>t`
          <a
            class="result"
            .href="${e.slug?e.slug:e.location}"
            @click="${this.selectionMade}"
          >
            <div class="title">
              ${e.icon?t`<simple-icon-lite
                    class="page-title-icon"
                    icon="${e.icon}"
                  ></simple-icon-lite>`:""}
              ${e.title}<span
                ?hidden="${!this.showPath}"
                class="link-text"
                aria-hidden="true"
                >(${e.location})</span
              >
              ${e.tags&&""!=e.tags?t`${e.tags.split(",").map((e=>t`<simple-tag value="${e.trim()}"></simple-tag>`))}`:""}
            </div>
            <div class="date" ?hidden="${!this.showDate}">
              <simple-datetime format="M jS" .timestamp="${e.created}" unix
                >${e.created}</simple-datetime
              >
            </div>
            ${e.breadcrumb?t`<div>
                  ${e.breadcrumb.map(((e,i)=>t`${0!=i?t`<simple-icon-lite
                            icon="icons:chevron-right"
                          ></simple-icon-lite>`:""}${e.title}`))}
                </div>`:""}
            <div>${e.description}..</div>
          </a>
        `))}
    `}selectionMade(e){this.dispatchEvent(new CustomEvent("search-item-selected",{detail:{value:e.detail}})),globalThis.dispatchEvent(new CustomEvent("simple-modal-hide",{bubbles:!0,cancelable:!0,detail:{}}))}_searchValueChanged(e){if(this.search=e.detail.value,this.search){"search"!==a.getInternalRoute()&&globalThis.history.replaceState({},null,"x/search");const e=new URLSearchParams(globalThis.location.search);e.set("search",this.search),globalThis.history.replaceState({},"",decodeURIComponent(`./x/search?${e}`))}}async __resultsChanged(e){if(e.detail.value){setTimeout((()=>{this.whileLoading=!1}),100);let t=e.detail.value;await t.map((async e=>{let t=await a.findItemAsObject(e.location,"slug","item");var i=[{title:t?t.title:""}];let s=t;for(;s&&null!=s.parent;)s=await a.manifest.items.find((e=>e.id==s.parent)),s&&i.unshift({title:s.title});e.breadcrumb=i,t&&(e.slug=t.slug,t.metadata&&t.metadata.pageType&&(e.type=t.metadata.pageType),t.metadata&&t.metadata.icon&&(e.icon=t.metadata.icon),t.metadata&&t.metadata.tags&&(e.tags=t.metadata.tags))})),this.__results=[...t]}else this.__results=[]}static get properties(){return{...super.properties,dataSource:{type:String,attribute:"data-source"},whileLoading:{type:Boolean},showDate:{type:Boolean,attribute:"show-date"},showPath:{type:Boolean,attribute:"show-path"},hideInput:{type:Boolean,attribute:"hide-input"},search:{type:String},__results:{type:Array},t:{type:Object}}}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this.shadowRoot.querySelector("#lunr").addEventListener("results-changed",this.__resultsChanged.bind(this))}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"search"==t&&this[t]&&(this._searchChanged(this[t],e),this.shadowRoot.querySelector("#lunr").search=this[t]),"dataSource"==t&&this[t]&&(this.shadowRoot.querySelector("#lunr").dataSource=this[t])}))}_searchChanged(e,t){e.length>=3&&(this.whileLoading=!0,void 0===this.dataSource&&(this.dataSource="lunrSearchIndex.json"))}}customElements.define(SiteSearch.tag,SiteSearch);export{SiteSearch};