/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as i,css as e}from"../../../../../lit/index.js";import{HAXCMSThemeParts as s}from"../../core/utils/HAXCMSThemeParts.js";import{HAXCMSI18NMixin as o}from"../../core/utils/HAXCMSI18NMixin.js";import"../../../../simple-icon/lib/simple-icons.js";import"../../../../simple-icon/lib/simple-icon-button.js";import"../../../../simple-tooltip/simple-tooltip.js";class SiteRSSButton extends(o(s(t))){static get styles(){return[super.styles,e`
        :host {
          display: inline-flex;
          color: var(--site-rss-button-color, inherit);
        }
        a {
          text-decoration: var(--site-rss-text-decoration);
          outline: none;
          color: var(--site-rss-button-color, inherit);
        }
        simple-icon-button-lite {
          color: var(--site-rss-button-color, inherit);
        }
        simple-tooltip {
          --simple-tooltip-background: var(
            --haxcms-tooltip-background-color,
            #000000
          );
          --simple-tooltip-opacity: 1;
          --simple-tooltip-text-color: var(--haxcms-tooltip-color, #ffffff);
          --simple-tooltip-delay-in: 0;
          --simple-tooltip-border-radius: 0;
        }
      `]}static get tag(){return"site-rss-button"}constructor(){super(),this.HAXCMSI18NMixinBase="../../../",this.t={rssFeed:"RSS Feed",atomFeed:"ATOM Feed"},this._link={title:this.t.rssFeed},this.href="rss.xml",this.icon="communication:rss-feed",this.type="rss",this.raised=!1,this.position="auto"}render(){return i`
      <a
        ?disabled="${this.disabled}"
        tabindex="-1"
        href="${this.href}"
        .id="btn${this.type}"
        target="_blank"
        rel="noopener noreferrer"
        .part="${this.editMode?"edit-mode-active":""}"
      >
        <simple-icon-button-lite
          icon="${this.icon}"
          label="${this._link.title}"
          @click="${this.print}"
          ?disabled="${this.disabled}"
          .part="${this.editMode?"edit-mode-active":""}"
        ></simple-icon-button-lite>
      </a>
      <simple-tooltip
        .for="btn${this.type}"
        position="${this.position}"
        offset="14"
      >
        ${this._link.title}
      </simple-tooltip>
    `}static get properties(){return{...super.properties,disabled:{type:Boolean,reflect:!0},_link:{type:Object},href:{type:String},icon:{type:String},type:{type:String},position:{type:String}}}updated(t){super.updated&&super.updated(t),t.forEach(((t,i)=>{"type"==i&&this._generateLink(this[i]),"t"==i&&this._generateLink(this.type)}))}_generateLink(t){if(this._link&&this._link.href&&globalThis.document.head.removeChild(this._link),t){let i=globalThis.document.createElement("link");i.rel="alternate","rss"===t?(i.href="rss.xml",i.title=this.t.rssFeed,i.type="application/rss+xml",this.icon="communication:rss-feed"):"atom"===t&&(i.href="atom.xml",i.title=this.t.atomFeed,i.type="application/atom+xml",this.icon="communication:rss-feed"),this.href=i.href,globalThis.document.head.appendChild(i),this._link=i}}}customElements.define(SiteRSSButton.tag,SiteRSSButton);export{SiteRSSButton};