/**
 * Copyright 2022 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../../../lit/index.js";import{store as s}from"../../core/haxcms-site-store.js";import{HAXCMSI18NMixin as n}from"../../core/utils/HAXCMSI18NMixin.js";import{wipeSlot as o,lightChildrenToShadowRootSelector as r,unwrap as l}from"../../../../utils/utils.js";import{enableServices as a}from"../../../../micro-frontend-registry/lib/microServices.js";import{MicroFrontendRegistry as h}from"../../../../micro-frontend-registry/micro-frontend-registry.js";import"../../../../citation-element/citation-element.js";import{IntersectionObserverMixin as c}from"../../../../intersection-element/lib/IntersectionObserverMixin.js";import"../../../../simple-icon/lib/simple-icon-lite.js";import"../../../../hax-iconset/lib/simple-hax-iconset.js";a(["haxcms"]);class SiteRemoteContent extends(n(c(e))){static get styles(){return[i`
        :host {
          display: block;
        }
        #slot {
          display: none;
        }
        :host(:not([hide-reference])) #content {
          border-left: 10px solid #eeeeee;
          margin-left: -10px;
        }
        :host([breakreference]) #slot {
          display: block;
        }
        :host([breakreference]) #content {
          display: none;
          border-left: unset;
          margin-left: unset;
        }
        :host([loading]) .loading {
          margin: 8px 0 0 -12px;
          font-size: 2px;
          width: 20px;
          height: 20px;
          --simple-icon-height: 20px;
          --simple-icon-width: 20px;
          position: absolute;
        }
        :host([player][loading]) .loading {
          margin: 8px 0px 0px -12px;
          font-size: 2px;
          height: 100%;
          --simple-icon-height: 100px;
          --simple-icon-width: 100px;
          width: 400px;
          display: flex;
          justify-content: center;
          position: relative;
          top: 25px;
          left: 25px;
        }

        :host([player][loading]) .loading simple-icon-lite {
          height: 100%;
        }
      `]}static get tag(){return"site-remote-content"}constructor(){super(),this.HAXCMSI18NMixinBase="../../../",this.__disposer=[],this.player=!1,this.circularBlock=!1,this.itemManifest={},this.loading=!1,this.uuid=null,this.hideReference=!1,this.siteurl="",this.showTitle=!1,this.breakreference=!1,this._remoteTitle=null,this.t.selectPage="Select page";let e=this,t=0;for(;e&&e.tagName;)e=e.parentNode,e&&e.tagName&&"SITE-REMOTE-CONTENT"===e.tagName&&(t++,t>=3&&(this.circularBlock=!0))}render(){return t`
      ${this.elementVisible?t`
            <div class="loading">
              ${this.loading?t`<simple-icon-lite icon="hax:loading"></simple-icon-lite>`:""}
            </div>
            ${this.showTitle&&this._remoteTitle?t`<h3>${this._remoteTitle}</h3>`:""}
            <div id="slot"><slot></slot></div>
          `:""}
      <div id="content"></div>
    `}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{if(this.elementVisible){if(("uuid"===t||"elementVisible"===t)&&this[t]&&!this.breakreference&&!this.loading&&!this.circularBlock){this.loading=!0;let e=this.siteurl;""==e&&globalThis.HAXCMS&&globalThis.location&&(e=`${globalThis.location.origin}${globalThis.HAXCMS.instance.store.location.baseUrl}`),h.call("@haxcms/pageCache",{site:e,type:"link",uuid:this.uuid,data:!0},this.renderContentResponse.bind(this))}if("siteurl"!==t||!globalThis.HaxStore||this.loading||this.circularBlock||(clearTimeout(this.__debounce),this.__debounce=setTimeout((()=>{this.loading=!0,this.__refresh=!0,globalThis.HaxStore.instance.refreshActiveNodeForm()}),1500)),"breakreference"===t&&this[t]){const e=this.shadowRoot.querySelector("#content");let t=e.firstElementChild;for(;t;)this.appendChild(t),t=e.firstElementChild}else if("breakreference"===t&&!this[t]&&e&&!this.circularBlock){this.loading=!0,o(this);let e=this.siteurl;""==e&&globalThis.HAXCMS&&globalThis.location&&(e=`${globalThis.location.origin}${globalThis.HAXCMS.instance.store.location.baseUrl}`),h.call("@haxcms/pageCache",{site:e,type:"link",uuid:this.uuid,data:!0},this.renderContentResponse.bind(this))}}}))}renderContentResponse(e){if(e.data){globalThis.HaxStore&&!this.breakreference&&globalThis.HaxStore.instance.activeBodyIgnoreActive(!0);const a=this.shadowRoot.querySelector("#content");o(a);let h=globalThis.document.createElement("div"),c=e.data.content.replace(/<script[\s\S]*?>/gi,"&lt;script&gt;");if(c=c.replace(/<\/script>/gi,"&lt;/script&gt;"),h.innerHTML=c,this.appendChild(h),l(h),this._remoteTitle=e.data.title,this.loading=!1,this.breakreference||r(this,"#content"),!this.hideReference&&this.itemManifest&&this.itemManifest.title&&e.data&&!this.breakreference){globalThis.HaxStore.instance.activeBodyIgnoreActive(!1);var t=new Date,i=t.getDate(),s=t.getMonth()+1,n=t.getFullYear();if(!this.nextElementSibling||this.nextElementSibling&&"CITATION-ELEMENT"!==this.nextElementSibling.tagName){let t=globalThis.document.createElement("citation-element");t.title=`${this.itemManifest.title} - ${e.data.title}`,t.source=`${e.data.site}${e.data.slug}`,t.date=`${i}/${s}/${n}`,t.scope="sibling",t.license=this.itemManifest.license,t.creator=this.itemManifest.metadata.author.name,this.insertAdjacentElement("afterend",t)}else if(this.nextElementSibling&&"CITATION-ELEMENT"===this.nextElementSibling.tagName){let t=this.nextElementSibling;t.title=`${this.itemManifest.title} - ${e.data.title}`,t.source=`${e.data.site}${e.data.slug}`,t.date=`${i}/${s}/${n}`,t.scope="sibling",t.license=this.itemManifest.license,t.creator=this.itemManifest.metadata.author.name}}}}static get properties(){return{...super.properties,uuid:{type:String},player:{type:Boolean,reflect:!0},siteurl:{type:String},showTitle:{type:Boolean,attribute:"show-title"},_remoteTitle:{type:String},loading:{type:Boolean,reflect:!0},breakreference:{type:Boolean,reflect:!0},hideReference:{type:Boolean,reflect:!0,attribute:"hide-reference"}}}firstUpdated(e){if(super.firstUpdated(e),this.children.length>0){let e=this.shadowRoot.querySelector("#content");o(e),r(this,"#content")}}static get haxProperties(){return{type:"grid",canScale:!1,canEditSource:!1,gizmo:{title:"Remote Content",description:"Reuse content from one site in another.",icon:"hax:remote",color:"grey",tags:["Resource","haxcms","content","remote","reference","url","resource"],handles:[],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"siteurl",title:"Site address",description:"Paste address to reference content from if not the current site",inputMethod:"textfield"},{property:"uuid",title:"Item",description:"Item to render for the link / title data",inputMethod:"textfield"},{property:"breakreference",title:"Break reference",description:"Checking this box copies the remote content for editing locally but removes the association. It will no longer get updates when the reference material updates.",inputMethod:"boolean"},{property:"showTitle",title:"Show title",description:"Toggle on to render the title of the resource being displayed",inputMethod:"boolean"}]},demoSchema:[{tag:"site-remote-content",properties:{showTitle:!0,_remoteTitle:"Select content"},content:"<div>Select content to load</div>"}],saveOptions:{unsetAttributes:["t","_remote-title"]}}}haxHooks(){return{progressiveEnhancement:"haxprogressiveEnhancement",setupActiveElementForm:"haxsetupActiveElementForm"}}haxprogressiveEnhancement(e){if(this.shadowRoot&&this.shadowRoot.querySelector("#content"))return this.shadowRoot.querySelector("#content").innerHTML}async haxsetupActiveElementForm(e){if(globalThis.HAXCMS){if(0===Object.keys(this.itemManifest).length||this.__refresh)if(this.__refresh=!1,this.siteurl){const e=await h.call("@haxcms/siteManifest",{site:this.siteurl});e.data&&(this.itemManifest=e.data)}else this.itemManifest=s.getManifest(!0);var t=[{text:this.t.selectPage,value:null}];this.itemManifest.items.forEach((e=>{if(e.id!=this.itemId){let i=e,s="- ";for(;i&&null!=i.parent;)i=this.itemManifest.items.find((e=>e.id==i.parent)),i&&(s="--"+s);t.push({text:s+e.title,value:e.id})}})),e.settings.configure.forEach(((i,s)=>{"uuid"===i.property?(e.settings.configure[s].disabled=!1,e.settings.configure[s].inputMethod="select",e.settings.configure[s].itemsList=t,this.breakreference&&(e.settings.configure[s].disabled=!0)):"siteurl"===i.property&&(e.settings.configure[s].disabled=!1,this.breakreference&&(e.settings.configure[s].disabled=!0))})),this.loading=!1}}}customElements.define(SiteRemoteContent.tag,SiteRemoteContent);export{SiteRemoteContent};