/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as i,css as e}from"../../../../../lit/index.js";import{HAXCMSThemeParts as o}from"../../core/utils/HAXCMSThemeParts.js";import{HAXCMSI18NMixin as r}from"../../core/utils/HAXCMSI18NMixin.js";import"../../../../simple-icon/lib/simple-icons.js";import"../../../../simple-icon/lib/simple-icon-button-lite.js";import"../../../../simple-tooltip/simple-tooltip.js";class SitePrintButton extends(r(o(t))){static get styles(){return[super.styles,e`
        :host {
          display: inline-flex;
          text-rendering: optimizelegibility;
          position: relative;
          color: var(--site-print-button-color, inherit);
        }
        simple-icon-button {
          color: var(--site-print-button-color, inherit);
        }
        simple-tooltip {
          --simple-tooltip-background: var(
            --haxcms-tooltip-background-color,
            #000000
          );
          --simple-tooltip-opacity: 1;
          --simple-tooltip-text-color: var(--haxcms-tooltip-color, #ffffff);
          --simple-tooltip-delay-in: 0;
          --simple-tooltip-border-radius: 0;
        }
      `]}static get tag(){return"site-print-button"}constructor(){super(),this.HAXCMSI18NMixinBase="../../../",this.t={printPage:"Print page",printSite:"Print site",printOutline:"Print outline"},this.icon="icons:print",this.position="auto",this.type="page"}render(){return i`
      <simple-icon-button-lite
        .id="btn${this.type}"
        icon="${this.icon}"
        @click="${this.print}"
        label="${this.makeLabel(this.type,this.t)}"
        ?disabled="${this.disabled}"
      ></simple-icon-button-lite>
      <simple-tooltip
        .for="btn${this.type}"
        position="${this.position}"
        offset="14"
      >
        ${this.makeLabel(this.type,this.t)}
      </simple-tooltip>
    `}updated(t){super.updated&&super.updated(t),t.forEach(((t,i)=>{"editMode"===i&&(this[i]?this.setAttribute("part","edit-mode-active"):this.removeAttribute("part"))}))}static get properties(){return{...super.properties,icon:{type:String},disabled:{type:Boolean,reflect:!0},label:{type:String},position:{type:String},type:{type:String}}}makeLabel(t,i){switch(t){case"page":return`${i.printPage}`;case"site":return`${i.printSite}`;default:return`${i.printOutline}`}}async print(t){globalThis.open(globalThis.location.href+"?format=print-"+this.type,"","left=0,top=0,width=800,height=800,toolbar=0,scrollbars=0,status=0,noopener=1,noreferrer=1")}}customElements.define(SitePrintButton.tag,SitePrintButton);export{SitePrintButton};