/**
 * Copyright 2022 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as s,nothing as i}from"../../../../../lit/index.js";import{store as l}from"../../core/haxcms-site-store.js";import{HAXCMSI18NMixin as r}from"../../core/utils/HAXCMSI18NMixin.js";import"../../../../simple-fields/lib/simple-tags.js";import"../../../../simple-fields/lib/simple-fields-field.js";import"../../../../simple-icon/lib/simple-icon-button-lite.js";import"../../../../simple-icon/lib/simple-icon-lite.js";import"../../../../grid-plate/grid-plate.js";import{mediaKeys as a}from"../magic/site-view.js";import{autorun as o}from"../../../../../mobx/dist/mobx.esm.js";import{SimpleColors as p}from"../../../../simple-colors/simple-colors.js";export function loadViewsForm(){const e=l.getManifest(!0);var t=[{text:"Select page",value:null}];return e.items.forEach((s=>{let i=s,l="- ";for(;i&&null!=i.parent;)i=e.items.find((e=>e.id==i.parent)),i&&(l="--"+l);t.push({text:l+s.title,value:s.id})})),[{property:"settings",inputMethod:"collapse",properties:[{property:"displayFormat",title:"Display format",accordion:!0,expanded:!1,properties:[{property:"displayedAs",title:"Displayed as",description:"How the entire display should be rendered",inputMethod:"select",options:{list:"List",table:"Table",card:"Card",contentplayer:"Content Player"}},{property:"displayOf",title:"Results as",description:"How do you want each result to appear",inputMethod:"select",options:{title:"Title",full:"Full content",fullRemote:"Full content (remote load)",blocks:"Blocks"}}]},{property:"filters",title:"Filters",accordion:!0,expanded:!1,properties:[{property:"parent",title:"Parent",description:"Limit results to those that have this item as it's parent",inputMethod:"select",itemsList:t},{property:"tags",title:"Tags",description:"Filter by tags, comma separated",inputMethod:"text"},{property:"title",title:"Title",description:"Filter by title",inputMethod:"text"},{property:"blockFilter",title:"Block filter",description:"Filter by block type",inputMethod:"select",options:a}]}]}]}export class SiteViewsRoute extends(r(p)){static get tag(){return"site-views-route"}static get styles(){return[super.styles,s`
        :host {
          display: block;
          font-size: 16px;
        }
        h3 {
          margin: 4px 0;
          padding: 0;
        }
        a {
          text-decoration: none;
          font-size: 16px;
        }
        [data-active] {
          background-color: var(--simple-colors-default-theme-accent-1);
        }
        a11y-collapse,
        simple-fields {
          --a11y-collapse-heading-color: var(
            --simple-colors-default-theme-grey-12
          );
          color: var(--simple-colors-default-theme-grey-12);
          background-color: var(--simple-colors-default-theme-grey-1);
        }
        simple-icon-button-lite {
          border-radius: 0;
          font-size: 16px;
        }
        .views-controls {
          display: none;
        }
        :host([is-logged-in]) .views-controls {
          display: block;
        }
        /* list display */
        .list {
          margin: 0;
          padding: 0;
          list-style: none;
        }
        .list-item {
          margin: 0;
          padding: 16px;
          border-bottom: 1px solid var(--simple-colors-default-theme-grey-3);
        }
        .list-item:hover {
          background-color: var(--simple-colors-default-theme-grey-2);
        }
        .list-link a {
          font-size: 32px;
        }
        .list-breadcrumb {
          font-size: 10px;
        }
        .overview {
          padding: 0;
          margin: 0;
          list-style: none;
          font-size: 12px;
        }
      `]}constructor(){super(),this.HAXCMSI18NMixinBase="../../../",this.search=globalThis.location.search,this.t.selectPage="Select Page",this.t.title="Title",this.t.parent="Parent",this.t.block="Block",this.t.tags="Tags",this.isLoggedIn=!1,this.accentColor="grey",this.loading=!1,this._searchDebounce=null,this.__disposer=this.__disposer?this.__disposer:[],o((e=>{this.isLoggedIn=l.isLoggedIn,this.__disposer.push(e)})),o((e=>{let t=new URLSearchParams(l.currentRouterLocation.search);const s=Object.fromEntries(t);this.shadowRoot?(this.shadowRoot.querySelector("#schema").fields=loadViewsForm(),setTimeout((()=>{this.shadowRoot.querySelector("#schema").value={settings:{displayFormat:{displayedAs:s.display||"list",displayOf:s.displayOf||"title"},filters:{title:s.title||"",parent:s.parent||"",tags:s.tags||"",blockFilter:s.blockFilter||""}}}}),0)):this.params=s,this.__disposer.push(e)}))}disconnectedCallback(){for(var e in this.__disposer)this.__disposer[e].dispose();this._ready=!1,super.disconnectedCallback()}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this._ready=!0,this.shadowRoot.querySelector("#schema").fields=loadViewsForm(),setTimeout((()=>{this.shadowRoot.querySelector("#schema").value={settings:{displayFormat:{displayedAs:this.params.display||"list",displayOf:this.params.displayOf||"title"},filters:{title:this.params.title||"",parent:this.params.parent||"",tags:this.params.tags||"",blockFilter:this.params.blockFilter||""}}}}),0)}formValuesChanged(e){clearTimeout(this._formDebounce),this._formDebounce=setTimeout((()=>{const t=new URLSearchParams(globalThis.location.search),s=e.detail.value.settings;if(this._ready&&s&&s.displayFormat&&s.filters){if(s.displayFormat.displayedAs&&t.set("display",s.displayFormat.displayedAs),s.displayFormat.displayOf&&(t.set("displayOf",s.displayFormat.displayOf),this.shadowRoot.querySelector("#schema").formElements["settings.filters.blockFilter"]&&(this.shadowRoot.querySelector("#schema").formElements["settings.filters.blockFilter"].element.hidden="blocks"!==s.displayFormat.displayOf)),s.filters.title?t.set("title",s.filters.title):t.delete("title"),s.filters.parent&&"null"!=s.filters.parent?t.set("parent",s.filters.parent):t.delete("parent"),s.filters.tags?t.set("tags",s.filters.tags):t.delete("tags"),s.filters.blockFilter&&"blocks"===s.displayFormat.displayOf){let e=s.filters.blockFilter;parseInt(e)&&a[parseInt(e)]&&(e=a[e]),t.set("blockFilter",e)}else t.delete("blockFilter");globalThis.history.pushState({},"",decodeURIComponent(`./x/views?${t}`)),this.search=`?${decodeURIComponent(t)}`}}),600)}iconForDisplay(e){switch(e){case"list":default:return"hax:module";case"table":return"editable-table:col-striped";case"card":return"image:grid-on";case"contentplayer":return"hax:multimedia"}}render(){return t` <grid-plate
        cols="1-1"
        disable-responsive
        class="views-controls"
      >
        <div slot="col-1">
          <form id="form">
            <simple-fields
              id="schema"
              @value-changed="${this.formValuesChanged}"
            ></simple-fields>
          </form>
        </div>
        <div slot="col-2">
          <ul class="overview">
            <li>
              Display:
              <simple-icon-lite
                icon="${this.iconForDisplay(this.params.display)}"
              ></simple-icon-lite>
              ${this.params.display} of ${this.params.displayOf}
            </li>
            <li>
              Filters:
              <ul>
                ${this.params.title?t`<li>${this.t.title}: ${this.params.title}</li>`:i}
                ${this.params.parent?t`<li>${this.t.parent}: ${this.params.parent}</li>`:i}
                ${this.params.tags?t`<li>${this.t.tags}: ${this.params.tags}</li>`:i}
                ${this.params.blockFilter?t`<li>${this.t.block}: ${this.params.blockFilter}</li>`:i}
                <label>Search query for use in embedded views</label
                ><textarea cols="40" rows="5">${this.search}</textarea>
              </ul>
            </li>
          </ul>
        </div>
      </grid-plate>
      ${this.loading?t`<h3>Loading...</h3>`:t`<h3 class="views-controls">
            Results
            <simple-icon-button-lite icon="refresh" @click="${this.refreshData}"
              >Refresh</simple-icon-button-lite
            >
          </h3>`}
      <site-view
        search="${this.search}"
        @loading-changed="${this.syncLoad}"
      ></site-view>
      <slot></slot>`}refreshData(e){this.shadowRoot.querySelector("site-view").rebuildSearchResults()}syncLoad(e){this.loading=e.detail.value}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{if("search"===t&&e&&this.search){const e=new URLSearchParams(this.search),t=Object.fromEntries(e);this.params=t,t.display||(e.set("display",this.params.display||"list"),globalThis.history.replaceState({},"",decodeURIComponent(`./x/views?${e}`)))}"params"===t&&e&&this.params&&this.shadowRoot&&this.shadowRoot.querySelector("site-view").rebuildSearchResults()}))}static get properties(){return{...super.properties,loading:{type:Boolean,reflect:!0},isLoggedIn:{type:Boolean,reflect:!0,attribute:"is-logged-in"},params:{type:Object},search:{type:String}}}}customElements.define(SiteViewsRoute.tag,SiteViewsRoute);