/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e,LitElement as i}from"../../../../../lit/index.js";import{store as o}from"../../core/haxcms-site-store.js";import{autorun as s,toJS as n}from"../../../../../mobx/dist/mobx.esm.js";import"../query/site-query.js";import"../../../../simple-icon/simple-icon.js";import"../../../../simple-icon/lib/simple-icons.js";import"../../../../simple-icon/lib/simple-icon-button.js";class SiteTopMenu extends i{static get tag(){return"site-top-menu"}constructor(){super(),this.windowControllers=new AbortController,this.__disposer=[],this.activeId=null,this.sticky=!1,this.indicator="line",this.notitle=!1,this.showindex=!1,this.mobileMenuOpen=!1,this.arrowSize=6,this.sort={order:"ASC"},this.conditions={parent:null},this.mobileTitle="Navigation",this.editMode=!1,this.__items=[]}static get styles(){return[e`
        :host {
          display: block;
          --site-top-menu-bg: var(--haxcms-color, #ffffff);
          --site-top-menu-indicator-arrow: 6px;
          transition: 0.2s opacity linear;
          opacity: 1;
        }
        :host([edit-mode]) {
          opacity: 0.2;
          pointer-events: none;
        }
        :host([sticky]) {
          position: fixed;
          top: 0;
          left: 0;
          right: 0;
          z-index: 1000;
        }
        .wrapper {
          display: flex;
          justify-content: var(
            --site-top-menu-wrapper-justify-content,
            space-evenly
          );
          background-color: var(--site-top-menu-bg);
        }
        :host .wrapper ::slotted(div.spacing) {
          display: inline-flex;
        }
        .spacing {
          display: inline-flex;
        }
        .link,
        .link button {
          color: var(--site-top-menu-link-color, #444444);
        }
        button {
          cursor: pointer;
          text-transform: unset;
          background-color: var(--site-top-menu-link-bg-color, transparent);
          min-width: unset;
          border: none;
          transition: background-color 0.2s ease-in-out;
        }
        button:focus,
        button:hover {
          color: var(--site-top-menu-link-color-hover);
          background-color: var(
            --site-top-menu-link-bg-color-hover,
            transparent
          );
        }
        .active {
          color: var(--site-top-menu-link-active-color, #000000);
        }
        #indicator {
          transition: 0.4s ease-in-out all;
          transition-delay: 0.2s;
          position: relative;
          width: 0;
          height: 0;
          visibility: hidden;
        }
        :host([indicator="line"]) #indicator {
          border-bottom: 2px solid var(--site-top-menu-indicator-color, #000000);
        }
        :host([indicator="arrow"]) #indicator {
          border-left: var(--site-top-menu-indicator-arrow) solid transparent;
          border-right: var(--site-top-menu-indicator-arrow) solid transparent;
          border-bottom: var(--site-top-menu-indicator-arrow) solid
            var(--site-top-menu-indicator-color, #000000);
        }
        #indicator.activated {
          visibility: visible;
          position: absolute;
        }
        :host([notitle]) .spacing .link-title {
          display: none;
        }
        .spacing .link-index {
          display: none;
        }
        :host([showindex]) .spacing .link-index {
          display: inline-flex;
        }
        .mobile-button {
          display: none;
        }
        .link-list {
          padding: 0;
          margin: 0;
          list-style: none;
        }
        @media screen and (max-width: 640px) {
          .wrapper {
            display: block;
          }
          .wrapper .spacing {
            display: none;
          }
          .wrapper .mobile-button {
            display: inline-block;
            color: var(--site-top-menu-link-color, #444444);
            line-height: 32px;
            --simple-icon-width: 32px;
            --simple-icon-height: 32px;
            padding: 8px;
          }
          .mobiletitle {
            font-size: 24px;
            line-height: 32px;
            display: inline-block;
            vertical-align: middle;
          }
          .wrapper .mobile-button:hover {
            color: var(--site-top-menu-link-color-hover);
          }
          .wrapper .mobile-button .wrapper {
            display: block;
          }
          .link {
            text-decoration: none;
          }
          .link button {
            display: block;
            width: 100%;
          }
        }
        @media screen and (max-width: 640px) {
          #indicator {
            display: none !important;
          }
          .wrapper.responsive {
            position: relative;
          }
          .wrapper.responsive .spacing {
            float: none;
            display: block;
            text-align: left;
          }
        }
      `]}__resultChanged(t){null===t.detail.value?this.__items=[]:this.__items=[...t.detail.value]}render(){return t`
      <site-query
        @result-changed="${this.__resultChanged}"
        .sort="${this.sort}"
        .conditions="${this.conditions}"
      ></site-query>
      <div id="wrapper" class="wrapper">
        <simple-icon-button-lite
          class="mobile-button"
          icon="menu"
          id="menu"
          title="Open navigation"
        >
          <span class="mobiletitle">${this.mobileTitle}</span>
        </simple-icon-button-lite>
        <ul class="link-list">
          <slot name="prefix"></slot>
          ${this.__items.map(((e,i)=>t`
              ${!0===e.metadata.hideInMenu||!1===e.metadata.published?"":t`
                    <li class="spacing">
                      <a
                        data-id="${e.id}"
                        class="link"
                        tabindex="-1"
                        title="Go to ${e.title}"
                        href="${e.slug}"
                        part="a"
                        itemprop="url"
                      >
                        <button id="item-${e.id}" part="button">
                          <span class="link-index"
                            >${this.humanIndex(i)}</span
                          >
                          <span class="link-title" itemprop="name"
                            >${e.title}</span
                          >
                        </button>
                      </a>
                    </li>
                  `}
            `))}
          <slot name="suffix"></slot>
        </ul>
      </div>
      <div id="indicator" part="indicator"></div>
    `}updated(t){super.updated&&super.updated(t),t.has("activeId")&&this._activeIdChanged(this.activeId),t.has("mobileMenuOpen")&&this.manageOpen(this.mobileMenuOpen)}static get properties(){return{__items:{type:Array},activeId:{type:String},sticky:{type:Boolean,reflect:!0},indicator:{type:String,reflect:!0},notitle:{type:Boolean,reflect:!0},showindex:{type:Boolean,reflect:!0},arrowSize:{type:Number,attribute:"arrow-size"},sort:{type:Object},conditions:{type:Object},mobileTitle:{type:String,attribute:"mobile-title"},editMode:{type:Boolean,reflect:!0,attribute:"edit-mode"},mobileMenuOpen:{type:Boolean,reflect:!0,attribute:"mobile-menu-open"}}}humanIndex(t){return t+1}toggleOpen(t){this.mobileMenuOpen=!this.mobileMenuOpen}manageOpen(t){var e=this.shadowRoot.querySelector("#wrapper");t?e.classList.add("responsive"):e.classList.remove("responsive")}_activeIdChanged(t){if(this.mobileMenuOpen=!1,"none"!=this.indicator)if(t){this.shadowRoot.querySelector("#indicator").classList.add("activated");let e=null;if(this.shadowRoot.querySelector('[data-id="'+t+'"]'))e=this.shadowRoot.querySelector('[data-id="'+t+'"]');else{const i=o.getManifestItems(!0);let s=i.find((e=>e.id==t));for(;null===e&&s&&null!=s.parent;)s=i.find((t=>t.id==s.parent)),s&&this.shadowRoot.querySelector('[data-id="'+s.id+'"]')&&(e=this.shadowRoot.querySelector('[data-id="'+s.id+'"]'))}this._prevEl&&this._prevEl.classList.remove("active"),e&&(e.classList.add("active"),setTimeout((()=>{let t=e.getBoundingClientRect();"arrow"==this.indicator?(this.shadowRoot.querySelector("#indicator").style.left=t.left+e.offsetWidth/2-this.arrowSize+"px",this.shadowRoot.querySelector("#indicator").style.top=t.bottom):(this.shadowRoot.querySelector("#indicator").style.left=t.left+"px",this.shadowRoot.querySelector("#indicator").style.top=t.bottom,this.shadowRoot.querySelector("#indicator").style.width=e.offsetWidth+"px"),this._prevEl=e}),0))}else this.shadowRoot.querySelector("#indicator").classList.remove("activated")}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.shadowRoot.querySelector("#menu").addEventListener("click",this.toggleOpen.bind(this)),s((t=>{this.editMode=n(o.editMode),this.__disposer.push(t)})),setTimeout((()=>{s((t=>{this.activeId=n(o.activeId),this.__disposer.push(t)}))}),50),globalThis.addEventListener("resize",(()=>{this._activeIdChanged(this.activeId)}),{signal:this.windowControllers.signal}),setTimeout((()=>{globalThis.dispatchEvent(new Event("resize"))}),3e3)}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();this.windowControllers.abort(),super.disconnectedCallback()}}customElements.define(SiteTopMenu.tag,SiteTopMenu);export{SiteTopMenu};