/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../../../lit/index.js";import{store as o}from"../../core/haxcms-site-store.js";import{autorun as a,toJS as s}from"../../../../../mobx/dist/mobx.esm.js";import"../../core/micros/haxcms-button-add.js";import"../../../../map-menu/map-menu.js";import{localStorageGet as r}from"../../../../utils/utils.js";import{HAXCMSThemeParts as n}from"../../core/utils/HAXCMSThemeParts.js";class SiteMenu extends(n(e)){static get styles(){return[super.styles,i`
        :host {
          display: block;
          position: relative;
        }
        map-menu {
          padding: var(--site-menu-padding);
          background-color: var(--site-menu-background-color);
          color: var(--site-menu-color, inherit);
          --map-menu-container-padding: var(--site-menu-container-padding);
          --map-menu-container-background-color: var(
            --site-menu-container-background-color
          );
          --map-menu-container-color: var(--site-menu-container-color);
          --map-menu-item-active-item-color: var(
            --site-menu-item-active-item-color
          );
          --map-menu-font-size: var(--site-menu-font-size, 18px);
          overflow-y: var(
            --map-menu-overflow,
            var(--map-menu-overflow-y, auto)
          );
          overflow-x: var(
            --map-menu-overflow,
            var(--map-menu-overflow-x, hidden)
          );
          scrollbar-color: var(--site-menu-scrollbar-color, #252737);
          scrollbar-width: thick;
        }
        map-menu:not(:defined) {
          display: none;
        }
        :host([is-flex]) map-menu {
          overflow-y: visible;
          overflow-x: visible;
        }

        map-menu::-webkit-scrollbar-track {
          border-radius: 0;
          background-color: var(--site-menu-scrollbar-color, #252737);
        }

        map-menu::-webkit-scrollbar {
          width: 8px;
          background-color: var(--site-menu-scrollbar-color, #252737);
        }

        map-menu::-webkit-scrollbar-thumb {
          border-radius: 2px;
          -webkit-box-shadow: inset 0 0 4px
            var(--site-menu-scrollbar-thumb-color, #999999);
          box-shadow: inset 0 0 4px
            var(--site-menu-scrollbar-thumb-color, #999999);
          background-color: var(--site-menu-scrollbar-thumb-color, #999999);
        }
        .ops {
          position: absolute;
          display: block;
          left: 0px;
          height: 40px;
          bottom: -40px;
          z-index: 2;
          margin: 0 4px 0 0;
        }
        .ops .op {
          --simple-icon-height: 16px;
          --simple-icon-width: 16px;
          margin: 4px;
        }
      `]}static get tag(){return"site-menu"}constructor(){super(),this.hideActiveIndicator=!1,this.preventAutoScroll=!1,this.trackIcon="",this.editControls=!1,this.isFlex=!1,this.isHorizontal=!1,this.maxDepth=5,this.__disposer=[],a((e=>{this.routerManifest=Object.assign({},s(o.routerManifest)),this.__disposer.push(e)}))}render(){return t`
      <map-menu
        .part="map-menu ${this.editMode?"edit-mode-active":""}"
        .manifest="${this.routerManifest}"
        ?edit-controls="${this.editControls}"
        ?is-flex="${this.isFlex}"
        ?is-horizontal="${this.isHorizontal}"
        max-depth="${this.maxDepth}"
        ?active-indicator="${!this.hideActiveIndicator}"
        ?auto-scroll="${!this.preventAutoScroll}"
        @active-item="${this.mapMenuActiveChanged}"
        @map-menu-operation-selected="${this.mapMenuOperationSelected}"
      ></map-menu>
      ${this.editControls?t` <div class="ops">
            <haxcms-button-add
              class="op"
              type="sibling"
              label="Add page"
              action-id="null"
            ></haxcms-button-add>
          </div>`:""}
    `}clickLink(e){let t=this.shadowRoot.querySelector("map-menu").shadowRoot.querySelector("#"+e);t&&(t.shadowRoot.querySelector("a")?t.shadowRoot.querySelector("a").click():t.shadowRoot.querySelector("#"+e)&&t.shadowRoot.querySelector("#"+e).shadowRoot.querySelector("a").click())}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this.dispatchEvent(new CustomEvent("super-daemon-define-option",{bubbles:!0,cancelable:!0,composed:!0,detail:{title:"Go to page in this site",icon:"link",tags:["Site","navigation"],eventName:"super-daemon-run-program",context:["CMS"],path:"/site/navigation",value:{name:"Go to page",context:["CMS"],program:async(e,t)=>{let i=[];const o=this.routerManifest;return o&&o.items.length>0&&o.items.forEach((async t=>{(t.title.toLowerCase().includes(e.toLowerCase())||""===e)&&i.push({title:t.title,icon:"link",tags:["CMS","page"],value:{target:this,method:"clickLink",args:[t.id]},context:["CMS"],eventName:"super-daemon-element-method",path:"site/navigation/page"})})),i}}}})),this.dispatchEvent(new CustomEvent("super-daemon-define-option",{bubbles:!0,cancelable:!0,composed:!0,detail:{title:"Link to site page",icon:"hax:file-link-outline",tags:["Search","pages","links"],eventName:"super-daemon-run-program",path:"/sources/site-pages",context:["HAX","/"],priority:-1,value:{name:"Search pages",context:["HAX","/"],program:async(e,t)=>{let i=[];const o=this.routerManifest;return o&&o.items.length>0&&o.items.forEach((async t=>{(t.title.toLowerCase().includes(e.toLowerCase())||""===e)&&i.push({title:t.title,icon:"link",tags:["CMS","page"],value:{value:"a",eventName:"insert-tag",properties:{href:t.slug,"data-uuid":t.id},content:t.title},context:["HAX","/","/sources/site-pages"],eventName:"hax-super-daemon-insert-tag",path:"/sources/site-pages"})})),i}}}})),a((e=>{this.isFlex||(this.editControls=s(o.isLoggedIn))})),a((e=>{this.activeId=s(o.activeId),this.__disposer.push(e),setTimeout((()=>{this.shadowRoot.querySelector("map-menu").selected=this.activeId}),100)}))}static get properties(){return{...super.properties,routerManifest:{type:Object},editControls:{type:Boolean,attribute:"edit-controls"},isFlex:{type:Boolean,attribute:"is-flex"},isHorizontal:{type:Boolean,attribute:"is-horizontal",reflect:!0},maxDepth:{type:Number,attribute:"max-depth"},activeId:{type:String,attribute:"active-id"},hideActiveIndicator:{type:Boolean,attribute:"hide-active-indicator"},preventAutoScroll:{type:Boolean,attribute:"prevent-auto-scroll"},trackIcon:{type:String,attribute:"track-icon"}}}disconnectedCallback(){for(var e in this.__disposer)this.__disposer[e].dispose();super.disconnectedCallback()}mapMenuActiveChanged(e){e.detail.trackIcon=this.trackIcon;try{let i=r("HAXCMSSystemData");if(i.manifests)for(var t in void 0===i.manifests[this.routerManifest.id]&&(i.manifests[this.routerManifest.id]={accessData:{}}),i.manifests[this.routerManifest.id].accessData||(i.manifests[this.routerManifest.id].accessData={}),i.manifests[this.routerManifest.id].accessData[e.detail.id]={timestamp:Math.floor(Date.now()/1e3),trackIcon:this.trackIcon},this.routerManifest.items)this.routerManifest.items[t].id===e.detail.id&&(this.routerManifest.items[t].metadata.accessData=i.manifests[this.routerManifest.id].accessData[e.detail.id]);globalThis.localStorage.setItem("HAXCMSSystemData",JSON.stringify(i))}catch(e){}}mapMenuHoveredChanged(e){console.log(e.detail)}}customElements.define(SiteMenu.tag,SiteMenu);export{SiteMenu};