/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../../../lit/index.js";import{store as o}from"../../core/haxcms-site-store.js";import{autorun as s,toJS as n}from"../../../../../mobx/dist/mobx.esm.js";import{DDDPulseEffectSuper as r}from"../../../../d-d-d/d-d-d.js";import{HAXCMSThemeParts as a}from"../../core/utils/HAXCMSThemeParts.js";import{HAXCMSI18NMixin as l}from"../../core/utils/HAXCMSI18NMixin.js";import"../../../../simple-icon/lib/simple-icon-lite.js";import"../../../../simple-icon/lib/simple-icons.js";class SiteMenuButton extends(l(a(r(t)))){static get styles(){return[super.styles,i`
        :host {
          display: block;
          font-size: 16px;
        }
        :host([disabled]) {
          pointer-events: none;
          opacity: 0.3;
        }
        a {
          display: block;
          height: 100%;
          width: 100%;
          color: var(--site-menu-button-link-color);
          text-decoration: var(--site-menu-button-link-decoration, underline);
        }
        button {
          display: flex;
          cursor: pointer;
          transition:
            color,
            outline 0.2s ease;
          outline: 2px transparent;
          min-width: unset;
          background-color: var(
            --site-menu-button-button-background-color,
            transparent
          );
          border: 0;
          border-radius: var(--site-menu-button-button-border-radius, 0);
          height: var(--site-menu-button-button-height, 100%);
          width: var(--site-menu-button-button-width, 100%);
          justify-content: center;
          align-items: center;
          padding: 0;
          margin: 0;
        }
        button:hover,
        button:focus,
        button:active {
          outline: 2px solid var(--site-menu-button-button-hover-color, inherit);
          background-color: var(
            --site-menu-button-button-hover-background-color,
            inherit
          );
        }
        button:hover simple-icon-lite,
        button:focus simple-icon-lite,
        button:active simple-icon-lite {
          color: var(--site-menu-button-button-hover-color, inherit);
        }
        simple-icon-lite {
          display: block;
          font-size: 16px;
          transition: 0.2s color ease;
          --simple-icon-width: var(--site-menu-button-icon-width, 32px);
          --simple-icon-height: var(--site-menu-button-icon-height, 32px);
          color: light-dark(
            var(--site-menu-button-icon-fill-color, black),
            var(--ddd-theme-default-linkLight)
          );
        }
        simple-tooltip {
          --simple-tooltip-background: var(
            --haxcms-tooltip-background-color,
            #000000
          );
          --simple-tooltip-opacity: 1;
          --simple-tooltip-text-color: var(--haxcms-tooltip-color, #ffffff);
          --simple-tooltip-delay-in: 0;
          --simple-tooltip-border-radius: 0;
        }
      `]}static get tag(){return"site-menu-button"}constructor(){super(),this.HAXCMSI18NMixinBase="../../../",this.disabled=!1,this.icon="",this.position="right",this.t={noPreviousPage:"no previous page",noNextPage:"no next page"},this.hideLabel=!1,this.__disposer=this.__disposer?this.__disposer:[],s((t=>{this.activeRouterManifestIndex=n(o.activeRouterManifestIndex),this.__disposer.push(t)})),s((t=>{this.routerManifest=n(o.routerManifest),this.__disposer.push(t)})),s((t=>{this.editMode=n(o.editMode),this.__disposer.push(t)})),import("../../../../simple-tooltip/simple-tooltip.js")}render(){return e`
      <a
        tabindex="-1"
        ?disabled="${this.disabled}"
        aria-disabled="${this.disabled}"
        aria-label="${this.label}"
        .part="${this.editMode?"edit-mode-active link":"link"}"
      >
        <button
          id="menulink"
          noink
          ?disabled="${this.disabled}"
          ?raised="${this.raised}"
          aria-label="${this.label}"
          .part="${this.editMode?"edit-mode-active button":"button"}"
        >
          <slot name="prefix"></slot>
          <simple-icon-lite icon="${this.icon}"></simple-icon-lite>
          <slot name="suffix"></slot>
        </button>
      </a>
      ${this.hideLabel?"":e`
            <simple-tooltip
              for="menulink"
              offset="8"
              .position="${this.position}"
            >
              ${this.label}
            </simple-tooltip>
          `}
    `}static get properties(){return{...super.properties,type:{type:String,reflect:!0},activeRouterManifestIndex:{type:Number},routerManifest:{type:Object},link:{type:String},editMode:{type:Boolean,reflect:!0,attribute:"edit-mode"},disabled:{type:Boolean,reflect:!0,attribute:"disabled"},label:{type:String},hideLabel:{type:Boolean,attribute:"hide-label"},icon:{type:String},position:{type:String},raised:{type:Boolean}}}updated(t){super.updated&&super.updated(t),(t.has("type")||t.has("activeRouterManifestIndex"))&&("next"===this.type&&0===this.activeRouterManifestIndex?this.dataPulse="1":this.dataPulse=null),t.forEach(((t,e)=>{"type"==e&&this._typeChanged(this[e],t),"link"==e&&this._linkChanged(this[e]),"label"==e&&this.dispatchEvent(new CustomEvent(`${e}-changed`,{detail:{value:this[e]}})),["type","activeRouterManifestIndex","routerManifest"].includes(e)&&this.routerManifest&&(this.link=this.pageLink(this.type,this.activeRouterManifestIndex,this.routerManifest.items),this.label=this.pageLinkLabel(this.type,this.activeRouterManifestIndex,this.routerManifest.items)),["type","activeRouterManifestIndex","routerManifest","editMode","link"].includes(e)&&this.routerManifest&&(this.disabled=this.pageLinkStatus(this.type,this.activeRouterManifestIndex,this.routerManifest.items,this.editMode,this.link))}))}_linkChanged(t){null==t?this.shadowRoot.querySelector("a").removeAttribute("href"):this.shadowRoot.querySelector("a").setAttribute("href",t)}_typeChanged(t){"prev"===t?(this.icon||(this.icon="icons:chevron-left"),this.position||(this.position="right")):"next"===t?(this.icon||(this.icon="icons:chevron-right"),this.position||(this.position="left")):(this.icon="",this.direction=""),this.dispatchEvent(new CustomEvent("super-daemon-define-option",{bubbles:!0,cancelable:!0,composed:!0,detail:{title:t+" page",icon:this.icon,tags:["CMS","page","navigation"],value:{target:this,method:"clickLink"},context:"CMS",eventName:"super-daemon-element-method",path:"CMS/navigation/page/next"}}))}clickLink(t){this.shadowRoot.querySelector("a").click()}pageLink(t,e,i){return"prev"===t&&i?e>0&&i[e-1]?i[e-1].slug:null:"next"===t&&i&&e<i.length-1&&i[e+1]?i[e+1].slug:null}pageLinkStatus(t,e,i,o,s){if(o||null==s)return!0;if("prev"===t){if(0===e||-1===e)return!0}else if("next"===t&&i&&e>=i.length-1)return!0;return!1}pageLinkLabel(t,e,i){return"prev"===t&&i?0!==e&&-1!==e&&i[e-1]?i[e-1].title:this.t.noPreviousPage:"next"===t&&i?e>=i.length-1||!i[e+1]?this.t.noNextPage:i[e+1].title:void 0}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();super.disconnectedCallback()}}customElements.define(SiteMenuButton.tag,SiteMenuButton);export{SiteMenuButton};