/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../../../lit/index.js";import{store as o}from"../../core/haxcms-site-store.js";import{autorun as s,toJS as r}from"../../../../../mobx/dist/mobx.esm.js";class SiteDotIndicator extends t{static get styles(){return[i`
        :host {
          display: block;
          --site-dot-indicator-color: white;
        }
        :host([sticky="left"]) {
          position: fixed;
          left: 8px;
          z-index: 1000;
          top: 25vh;
        }
        :host([sticky="right"]) {
          position: fixed;
          right: 8px;
          z-index: 1000;
          top: 25vh;
        }
        :host([sticky="left"]) ol,
        :host([sticky="right"]) ol {
          display: grid;
        }
        ol {
          padding-left: 0;
          margin-left: 0;
        }
        li {
          transition: 0.3s all ease-in-out;
          display: inline-block;
          width: 10px;
          height: 10px;
          margin: 2px;
          text-indent: -999px;
          cursor: pointer;
          background-color: rgba(0, 0, 0, 0.1);
          border: 1px solid var(--site-dot-indicator-color);
          border-radius: 10px;
        }
        a {
          width: 12px;
          height: 12px;
          display: block;
          margin: 0;
          padding: 0;
        }
        .active {
          width: 12px;
          height: 12px;
          margin: 1px;
          background-color: var(--site-dot-indicator-color);
        }
      `]}constructor(){super(),this.__disposer=[],this.scrollOnActive=!1}static get tag(){return"site-dot-indicator"}render(){return e` <ol id="list"></ol> `}static get properties(){return{activeId:{type:String,attribute:"active-id"},routerManifest:{type:Object},sticky:{type:String,reflect:!0},scrollOnActive:{type:Boolean,attribute:"scroll-on-active"}}}updated(t){t.forEach(((t,e)=>{"activeId"==e&&this._activeIdChanged(this[e],t),"routerManifest"==e&&this._routerManifestChanged(this[e],t)}))}_activeIdChanged(t,e){if(t){let i=this.shadowRoot.querySelector('[data-item="'+t+'"');if(i&&i.classList.add("active"),e){let t=this.shadowRoot.querySelector('[data-item="'+e+'"');t&&t.classList.remove("active")}}}_routerManifestChanged(t){for(;null!==this.shadowRoot.querySelector("#list").firstChild;)this.shadowRoot.querySelector("#list").removeChild(this.shadowRoot.querySelector("#list").firstChild);for(var e in t.items){let i=globalThis.document.createElement("li");i.setAttribute("data-item",t.items[e].id),i.setAttribute("title",t.items[e].title),this.activeId===t.items[e].id&&i.classList.add("active");let o=globalThis.document.createElement("a");o.href=t.items[e].slug,i.appendChild(o),this.shadowRoot.querySelector("#list").appendChild(i)}}connectedCallback(){super.connectedCallback(),s((t=>{this.routerManifest=r(o.routerManifest),this.__disposer.push(t)})),s((t=>{this.activeId=r(o.activeId),this.__disposer.push(t)})),this.scrollOnActive&&this.shadowRoot.querySelector("#list").addEventListener("click",(()=>{this.parentElement.querySelector("#"+this.activeId).scrollIntoView({behavior:"smooth",block:"end",inline:"nearest"})}))}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();this.scrollOnActive&&this.shadowRoot.querySelector("#list").removeEventListener("click",(()=>{this.parentElement.querySelector("#"+this.activeId).scrollIntoView({behavior:"smooth",block:"end",inline:"nearest"})})),super.disconnectedCallback()}}customElements.define(SiteDotIndicator.tag,SiteDotIndicator);export{SiteDotIndicator};