/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../../../lit/index.js";import{store as s}from"../../core/haxcms-site-store.js";import"../../../../simple-icon/lib/simple-icon-lite.js";import"../../../../simple-icon/lib/simple-icons.js";import{autorun as r,toJS as d}from"../../../../../mobx/dist/mobx.esm.js";import{DDD as o}from"../../../../d-d-d/d-d-d.js";import{DDDBreadcrumb as a}from"../../../../d-d-d/lib/DDDStyles.js";import{HAXCMSI18NMixin as l}from"../../core/utils/HAXCMSI18NMixin.js";class SiteBreadcrumb extends(l(o)){static get styles(){return[super.styles,a,i`
        :host {
          display: block;
        }
        ol.breadcrumb {
          font-weight: var(--ddd-font-weight-light);
          margin: var(--site-breadcrumb-margin, var(--ddd-spacing-6) 0);
          padding: 0;
          pointer-events: auto;
          font-size: var(
            --site-breadcrumb-font-size,
            var(--ddd-font-size-4xs, 16px)
          );
          list-style: "/";
          gap: var(--ddd-spacing-2);
          display: flex;
          flex-flow: row;
          color: var(--ddd-theme-default-link);
          line-height: normal;
          text-align: start;
        }
        ol.breadcrumb li {
          font-size: var(
            --site-breadcrumb-font-size,
            var(--ddd-font-size-4xs, 16px)
          );
        }
        ol.breadcrumb li a {
          vertical-align: text-top;
          display: inline-block;
          padding: 0 var(--ddd-spacing-2);
          font-family: var(--ddd-font-navigation);
          font-weight: var(--ddd-font-weight-regular);
          text-decoration: none;
          font-size: var(
            --site-breadcrumb-font-size,
            var(--ddd-font-size-4xs, 16px)
          );
          color: var(
            --site-breadcrumb-color,
            var(--ddd-theme-default-link, #383f45)
          );
        }
        ol.breadcrumb li:first-child a {
          padding-left: 0;
        }
        ol.breadcrumb li:last-child a {
          color: var(--site-breadcrumb-last-color, black);
          pointer-events: none;
        }
      `]}static get tag(){return"site-breadcrumb"}constructor(){super(),this.__disposer=[],this.items=[],this.includeHome=!1,this.t=this.t||{},this.t={...this.t,home:"Home"}}render(){return e` ${this.items.length>0?e`
          <ol
            class="breadcrumb"
            itemscope
            itemtype="https://schema.org/BreadcrumbList"
          >
            ${this.items.map((t=>e`<li
                  itemprop="itemListElement"
                  itemscope
                  itemtype="https://schema.org/ListItem"
                >
                  <a itemprop="item" href="${t.slug}">${t.title}</a>
                </li>`))}
          </ol>
        `:""}`}static get properties(){return{items:{type:Array},editMode:{type:Boolean,reflect:!0,attribute:"edit-mode"},includeHome:{type:Boolean,reflect:!0,attribute:"include-home"}}}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),r((t=>{this.editMode=d(s.editMode),this.__disposer.push(t)})),r((t=>{this._activeItemChanged(d(s.activeItem)),this.__disposer.push(t)}))}_activeItemChanged(t){const e=t;if(e&&this.shadowRoot){var i=[{title:e.title,slug:e.slug}];let t=e,r=d(s.routerManifest);for(;t&&null!=t.parent;)t=r.items.find((e=>e.id==t.parent)),t&&i.unshift({title:t.title,slug:t.slug});this.includeHome&&i.unshift({title:this.t.home,slug:s.homeLink}),this.includeHome||1!==i.length?this.includeHome&&2===i.length&&i[0].slug===i[1].slug?this.items=[]:this.items=[...i]:this.items=[]}}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();super.disconnectedCallback()}}customElements.define(SiteBreadcrumb.tag,SiteBreadcrumb);export{SiteBreadcrumb};