/**
 * Copyright 2022 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e,render as i,nothing as a}from"../../../../../lit/index.js";import{unsafeHTML as s}from"../../../../../lit/directives/unsafe-html.js";import{store as l}from"../../core/haxcms-site-store.js";import{MicroFrontendRegistry as r}from"../../../../micro-frontend-registry/micro-frontend-registry.js";import{enableServices as o}from"../../../../micro-frontend-registry/lib/microServices.js";import"../../../../simple-fields/lib/simple-tags.js";import"../../../../simple-fields/lib/simple-fields-field.js";import"../../../../simple-icon/lib/simple-icon-button-lite.js";import"../../../../simple-icon/lib/simple-icon-lite.js";import"../../../../hax-iconset/lib/simple-hax-iconset.js";import"../../../../editable-table/lib/editable-table-display.js";import"../../../../play-list/play-list.js";import"../site/site-remote-content.js";import{iconFromPageType as d}from"../../../../course-design/lib/learning-component.js";import{SimpleColors as n}from"../../../../simple-colors/simple-colors.js";import{autorun as p,toJS as c}from"../../../../../mobx/dist/mobx.esm.js";export const mediaKeys=["audio","selfChecks","objectives","authorNotes","images","h5p","headings","dataTables","specialTags","links","placeholders","siteremotecontent","video"];export class SiteView extends n{static get tag(){return"site-view"}static get styles(){return[super.styles,e`
        :host {
          display: block;
          font-size: 16px;
        }
        h3 {
          margin: 4px 0;
          padding: 0;
        }
        editable-table-display::part(tag-link),
        a {
          text-decoration: none;
          font-size: 16px;
        }
        [data-active] {
          background-color: var(--simple-colors-default-theme-accent-1);
        }
        simple-icon-button-lite {
          border-radius: 0;
          font-size: 16px;
        }
        :host([loading]) .loading {
          width: 100%;
          --simple-icon-height: 50px;
          --simple-icon-width: 50px;
        }
        /* list display */
        .list {
          margin: 0;
          padding: 0;
          list-style: none;
        }
        .list-item {
          margin: 0;
          padding: 16px;
          border-bottom: 1px solid var(--simple-colors-default-theme-grey-3);
        }
        .list-item:hover {
          background-color: var(--simple-colors-default-theme-grey-2);
        }
        .list-link a {
          font-size: 32px;
        }
        .list-breadcrumb {
          font-size: 10px;
        }

        .overview {
          padding: 0;
          margin: 0;
          list-style: none;
          font-size: 12px;
        }

        /* editable table display */
        editable-table-display,
        editable-table-display::part(table),
        table,
        tr,
        th,
        td {
          font-size: 16px;
        }
        editable-table-display {
          --simple-icon-width: 50px;
          --simple-icon-height: 36px;
        }
      `]}constructor(){super(),this.loading=!1,this.dark=!1,this.accentColor="cyan",this.results=[],this.params={},this.search=null,this._searchDebounce=null,this.__disposer=this.__disposer?this.__disposer:[],o(["haxcms"]),p((t=>{this.dark=c(l.darkMode),setTimeout((()=>{this.requestUpdate()}),0),this.__disposer.push(t)}))}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();super.disconnectedCallback()}static get haxProperties(){return{canScale:!1,canEditSource:!1,gizmo:{title:"Site View",description:"A dynamic block that queries and displays certain information based on criteria",icon:"hax:view-gallery",color:"grey",tags:["Other","site","views","data","display","filter","view"],handles:[],meta:{author:"HAXTheWeb core team",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"search",title:"View URL",description:"URL containing criteria for generating the view. You can obtain this from the Views page.",inputMethod:"textfield",required:!0}]},demoSchema:[{tag:"site-view",properties:{search:"?display=list&displayOf=title&parent=__ACTIVE__"},content:""}]}}rebuildSearchResults(){clearTimeout(this._searchDebounce),this._searchDebounce=setTimeout((async()=>{if(this.shadowRoot&&!this.loading){const t=l.getManifest(!0);let e=globalThis.document.querySelector("base").href;e||(e="/");const i={type:"site",site:{file:e+"site.json",id:t.id,title:t.title,author:t.author,description:t.description,license:t.license,metadata:t.metadata,items:t.items},link:e,...this.params};this.loading=!0;const a=await r.call("@haxcms/views",i);a.data&&(this.results=[...a.data]),this.loading=!1}}),100)}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.rebuildSearchResults()}render(){return t` ${this.loading?t`<div class="loading">
          ${this.loading?t`<simple-icon-lite icon="hax:loading"></simple-icon-lite>`:""}
        </div> `:t` ${0!==this.results.length||this.loading?a:t`<h4>No results found</h4>`}
          ${"list"===this.params.display?this.listTemplate(this.dark,this.accentColor):a}
          ${"table"===this.params.display?this.tableTemplate(this.dark,this.accentColor):a}
          ${"card"===this.params.display?this.cardTemplate(this.dark,this.accentColor):a}
          ${"contentplayer"===this.params.display?this.contentplayerTemplate(this.dark,this.accentColor):a}
          <slot></slot>`}`}contentplayerTemplate(){return t`<play-list id="contentplayertemplate"></play-list>`}listTemplate(){return t` <ul class="list">
      ${this.results.map((e=>t` <li class="list-item">
            ${"blocks"===this.params.displayOf?mediaKeys.map((t=>e.media&&e.media[t]&&"string"==typeof e.media[t]&&this.params.blockFilter===t?s(e.media[t]):a)):t`<div class="play-list-item">
                  ${"title"===this.params.displayOf?t`<div class="list-link">
                          <a href="${e.slug}">${e.title}</a>
                        </div>
                        <div class="list-breadcrumb">
                          ${this.calculateBreadcrumb(e).map((e=>t` <span>${e.title}</span> `))}
                        </div>
                        ${e.metadata.tags&&""!=e.metadata.tags?e.metadata.tags.split(",").map((i=>t`<a href="x/views?tags=${i.trim()}">
                                    <simple-tag
                                      auto-accent-color
                                      value="${i.trim()}"
                                      accent-color="${e.accentColor}"
                                    ></simple-tag
                                  ></a>`)):a}`:"full"===this.params.displayOf?s(`<h3>${e.title}</h3>`+e.contents):t`<site-remote-content
                          player
                          hide-reference
                          uuid="${e.id}"
                          show-title
                        ></site-remote-content>`}
                </div>`}
          </li>`))}
    </ul>`}tableTemplate(e,i){return t` <editable-table-display
      accent-color="cyan"
      bordered
      caption="Content matching your search criteria"
      numeric-styles
      column-header
      printable
      downloadable
      sort
      striped
    >
      <table>
        <tr>
          <th>Icon</th>
          <th>Type</th>
          <th>Title</th>
          <th>Tags</th>
          <th>Updated</th>
          <th>Created</th>
          <th>Status</th>
        </tr>
        ${this.results.map((s=>t` <tr>
              <td>
                ${s.metadata.pageType?t`<simple-icon
                      ?dark="${e}"
                      accent-color="${i}"
                      title="${s.metadata.pageType}"
                      icon="${d(s.metadata.pageType)}"
                    ></simple-icon>`:a}
              </td>
              <td>
                ${s.metadata.pageType?s.metadata.pageType:a}
              </td>
              <td>
                <a href="${s.slug}" style="color:inherit">${s.title}</a>
              </td>
              <td>
                ${s.metadata.tags&&""!=s.metadata.tags?s.metadata.tags.split(",").map((e=>t`<a
                            part="tag-link"
                            href="x/views?tags=${e.trim()}"
                          >
                            <simple-tag
                              auto-accent-color
                              value="${e.trim()}"
                              accent-color="${s.accentColor}"
                            ></simple-tag
                          ></a>`)):a}
              </td>
              <td>
                <simple-datetime
                  format="m/j/y"
                  timestamp="${s.metadata.created}"
                  unix
                  class="info-date"
                ></simple-datetime>
              </td>
              <td>
                <simple-datetime
                  format="m/j/y"
                  timestamp="${s.metadata.updated}"
                  unix
                  class="info-date"
                ></simple-datetime>
              </td>
              <td>
                ${!1!==s.metadata.published?"published":"unpublished"}
              </td>
            </tr>`))}
      </table>
    </editable-table-display>`}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{if("loading"===e&&this.dispatchEvent(new CustomEvent("loading-changed",{detail:{value:this.loading}})),"search"===e){const t=new URLSearchParams(this.search),e=Object.fromEntries(t);this.params={...this.params,...e},"__ACTIVE__"===this.params.parent&&(this.params.parent=l.activeItem.id),this.rebuildSearchResults()}"results"===e&&t&&this.results&&"contentplayer"===this.params.display&&setTimeout((()=>{this.renderPlayListTemplate()}),0)}))}renderPlayListTemplate(){let e=globalThis.document.createElement("template");i(t`${this.results.map((e=>t` ${"blocks"===this.params.displayOf?mediaKeys.map((t=>e.media&&e.media[t]&&"string"==typeof e.media[t]&&this.params.blockFilter===t?s(e.media[t]):a)):t`<div class="play-list-item">
                ${"title"===this.params.displayOf?t`<div class="list-link">
                        <a href="${e.slug}">${e.title}</a>
                      </div>
                      <div class="list-breadcrumb">
                        ${this.calculateBreadcrumb(e).map((e=>t` <span>${e.title}</span> `))}
                      </div>`:"full"===this.params.displayOf?s(`<h3>${e.title}</h3>`+e.contents):t`<site-remote-content
                        player
                        hide-reference
                        uuid="${e.id}"
                        show-title
                      ></site-remote-content>`}
              </div>`}`))}`,e),this.shadowRoot.querySelector("#contentplayertemplate").appendChild(e)}cardTemplate(){return t`${this.results.map((e=>t` <accent-card accent-color="red" horizontal accent-heading>
          <div slot="heading">${e.title}</div>
          <div slot="subheading">
            ${e.metadata.tags&&""!=e.metadata.tags?e.metadata.tags.split(",").map((i=>t`<a href="x/views?tags=${i.trim()}">
                        <simple-tag
                          auto-accent-color
                          value="${i.trim()}"
                          accent-color="${e.accentColor}"
                        ></simple-tag
                      ></a>`)):a}
          </div>
          <div slot="content"><a href="${e.slug}">Link to content</a></div>
        </accent-card>`))}`}calculateBreadcrumb(t){let e=[];const i=l.getManifest(!0);let a=t;for(;a&&null!=a.parent;)a=i.items.find((t=>t.id==a.parent)),a&&e.unshift({title:a.title});return e}static get properties(){return{...super.properties,search:{type:String},results:{type:Array},loading:{type:Boolean,reflect:!0},params:{type:Object}}}}customElements.define(SiteView.tag,SiteView);