/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../../../lit/index.js";import{store as s}from"../../core/haxcms-site-store.js";class ActiveWhenVisible extends t{static get styles(){return[i`
        :host {
          display: block;
        }
        a {
          height: 10px;
          width: 10px;
          float: left;
          pointer-events: none;
          background-color: transparent;
        }
      `]}static get tag(){return"active-when-visible"}render(){return e`
      <div>
        <a
          id="a"
          .href="${this._a}"
          .name="#${this.itemId}"
          aria-hidden="true"
        ></a>
        <slot></slot>
      </div>
    `}constructor(){super(),this.thresholds=[0,.25,.5,.75,1],this.rootMargin="0px",this.visibleLimit=.5,this.isVisible=!1}updated(t){t.forEach(((t,e)=>{"isVisible"==e&&this.dispatchEvent(new CustomEvent("is-visible-changed",{detail:this[e]}))}))}static get properties(){return{itemId:{type:String,attribute:"item-id"},_a:{type:String},thresholds:{type:Array},rootMargin:{type:String,attribute:"root-margin"},visibleLimit:{type:Number,reflect:!0,attribute:"visible-limit"},isVisible:{type:Boolean,attribute:"is-visible"}}}connectedCallback(){super.connectedCallback(),this.observer=new IntersectionObserver(this.handleIntersectionCallback.bind(this),{rootMargin:this.rootMargin,threshold:this.thresholds}),this.observer.observe(this)}handleIntersectionCallback(t){for(let e of t)if(Number(e.intersectionRatio).toFixed(2)>=this.visibleLimit&&this.itemId){let t=s.findItem(this.itemId);this._a=t.slug,this.isVisible=!0,setTimeout((()=>{this.shadowRoot.querySelector("#a").click()}),25)}}}customElements.define(ActiveWhenVisible.tag,ActiveWhenVisible);export{ActiveWhenVisible};