/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../../../lit/index.js";import"../../../../simple-modal/lib/simple-modal-template.js";import{HAXCMSThemeParts as o}from"../../core/utils/HAXCMSThemeParts.js";import"../../../../simple-icon/simple-icon.js";import"../../../../simple-icon/lib/simple-icons.js";import"../../../../simple-icon/lib/simple-icon-button-lite.js";import"../../../../simple-tooltip/simple-tooltip.js";class SiteModal extends(o(t)){static get styles(){return[super.styles,i`
        :host {
          display: block;
        }
        :host([disabled]) {
          pointer-events: none;
        }
        simple-icon-button-lite {
          color: var(--site-modal-icon-color);
        }
        simple-modal-template {
          --simple-modal-width: 60vw;
          --simple-modal-height: 70vh;
          --simple-modal-min-width: 50vw;
          --simple-modal-min-height: 50vh;
        }
      `]}static get tag(){return"site-modal"}constructor(){super(),this.title="Dialog",this.icon="icons:menu",this.buttonLabel="Open dialog",this.position="auto",this.disabled=!1}render(){return e`
      <simple-icon-button-lite
        .part="${this.editMode?"edit-mode-active":""}"
        ?disabled="${this.editMode}"
        id="btn"
        @click="${this.fireEvent}"
        .icon="${this.icon}"
        .title="${this.buttonLabel}"
      ></simple-icon-button-lite>
      <simple-tooltip for="btn" position="${this.position}">
        ${this.buttonLabel}
      </simple-tooltip>
      <simple-modal-template id="smt" .title="${this.title}">
        <div id="content" slot="content"></div>
      </simple-modal-template>
    `}fireEvent(t){this.dispatchEvent(new CustomEvent("site-modal-click",{detail:{value:!0}}))}static get properties(){return{...super.properties,disabled:{type:Boolean,reflect:!0},dark:{type:Boolean},accentColor:{type:String,attribute:"accent-color"},title:{type:String},icon:{type:String},buttonLabel:{type:String,attribute:"button-label"},position:{type:String}}}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.shadowRoot.querySelector("#smt").associateEvents(this.shadowRoot.querySelector("#btn")),setTimeout((()=>{if(this.children&&this.shadowRoot.querySelector("#content"))for(var t in this.children)"object"==typeof this.children[t]&&this.shadowRoot.querySelector("#content").appendChild(this.children[t])}),0)}}customElements.define(SiteModal.tag,SiteModal);export{SiteModal};