/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,PolymerElement as e}from"../../../../../@polymer/polymer/polymer-element.js";import{store as i}from"../../core/haxcms-site-store.js";import{autorun as o,toJS as s}from"../../../../../mobx/dist/mobx.esm.js";import"../query/site-query.js";import"../../../../../@polymer/polymer/lib/elements/dom-repeat.js";class SiteOutlineBlock extends e{static get tag(){return"site-outline-block"}constructor(){super(),this.windowControllers=new AbortController}static get template(){return t`
      <style>
        :host {
          display: block;
          --site-top-menu-bg: var(--haxcms-color, #ffffff);
          --site-top-menu-indicator-arrow: 6px;
        }
        :host([sticky]) {
          position: fixed;
          top: 0;
          left: 0;
          right: 0;
          z-index: 1000;
        }
        .wrapper {
          display: flex;
          justify-content: center;
          justify-items: space-evenly;
          background-color: var(--site-top-menu-bg);
        }
        :host .wrapper ::slotted(div.spacing) {
          display: inline-flex;
        }
        .spacing {
          display: inline-flex;
        }
        .link {
          color: var(--site-top-menu-link-color, #444444);
        }
        button {
          text-transform: unset;
          min-width: unset;
        }

        .active {
          color: var(--site-top-menu-link-active-color, #000000);
        }
        #indicator {
          transition: 0.4s ease-in-out all;
          transition-delay: 0.2s;
          position: relative;
          width: 0;
          height: 0;
          visibility: hidden;
        }
        :host([indicator="line"]) #indicator {
          border-bottom: 2px solid var(--site-top-menu-indicator-color, #000000);
        }
        :host([indicator="arrow"]) #indicator {
          border-left: var(--site-top-menu-indicator-arrow) solid transparent;
          border-right: var(--site-top-menu-indicator-arrow) solid transparent;
          border-bottom: var(--site-top-menu-indicator-arrow) solid
            var(--site-top-menu-indicator-color, #000000);
        }
        #indicator.activated {
          visibility: visible;
          position: absolute;
        }
        :host([notitle]) .spacing .link-title {
          display: none;
        }
        .spacing .link-index {
          display: none;
        }
        :host([showindex]) .spacing .link-index {
          display: inline-flex;
        }
      </style>
      <div class="wrapper">
        <slot name="prefix"></slot>
        <site-query
          result="{{__items}}"
          sort='{"order": "ASC"}'
          conditions='{"parent": null}'
        ></site-query>
        <dom-repeat items="[[__items]]" mutable-data>
          <template>
            <div class="spacing">
              <a
                data-id$="[[item.id]]"
                class="link"
                tabindex="-1"
                title$="Go to [[item.title]]"
                href$="[[item.slug]]"
                ><button noink="[[noink]]">
                  <span class="link-index">[[humanIndex(index)]]</span
                  ><span class="link-title">[[item.title]]</span>
                </button></a
              >
            </div>
          </template>
        </dom-repeat>
        <slot name="suffix"></slot>
      </div>
      <div id="indicator"></div>
    `}static get properties(){return{manifest:{type:Object},activeId:{type:String,observer:"_activeIdChanged"},sticky:{type:Boolean,reflectToAttribute:!0,value:!1},indicator:{type:String,reflectToAttribute:!0,value:"line"},noink:{type:Boolean,reflectToAttribute:!0,value:!1},notitle:{type:Boolean,reflectToAttribute:!0,value:!1},showindex:{type:Boolean,reflectToAttribute:!0,value:!1},arrowSize:{type:Number,value:6}}}humanIndex(t){return t+1}_activeIdChanged(t){if("none"!=this.indicator)if(t){this.shadowRoot.querySelector("#indicator").classList.add("activated");let e=null;if(this.shadowRoot.querySelector('[data-id="'+t+'"]'))e=this.shadowRoot.querySelector('[data-id="'+t+'"]');else{let i=this.manifest.items.find((e=>e.id==t));for(;null===e&&i&&null!=i.parent;)i=this.manifest.items.find((t=>t.id==i.parent)),i&&this.shadowRoot.querySelector('[data-id="'+i.id+'"]')&&(e=this.shadowRoot.querySelector('[data-id="'+i.id+'"]'))}this._prevEl&&this._prevEl.classList.remove("active"),e&&(e.classList.add("active"),this._prevEl=e,"arrow"==this.indicator?(this.shadowRoot.querySelector("#indicator").style.left=e.offsetLeft+e.offsetWidth/2-this.arrowSize+"px",this.shadowRoot.querySelector("#indicator").style.top=e.offsetTop+e.offsetHeight-this.arrowSize+"px"):(this.shadowRoot.querySelector("#indicator").style.left=e.offsetLeft+"px",this.shadowRoot.querySelector("#indicator").style.top=e.offsetTop+e.offsetHeight+"px",this.shadowRoot.querySelector("#indicator").style.width=e.offsetWidth+"px"))}else this.shadowRoot.querySelector("#indicator").classList.remove("activated")}connectedCallback(){super.connectedCallback(),this.__disposer=o((()=>{this.manifest=s(i.manifest)})),setTimeout((()=>{this.__disposer2=o((()=>{this.activeId=s(i.activeId)}))}),50),globalThis.addEventListener("resize",(()=>{this._activeIdChanged(this.activeId)}),{signal:this.windowControllers.signal})}disconnectedCallback(){super.disconnectedCallback(),this.__disposer(),this.__disposer2&&this.__disposer2(),this.windowControllers.abort()}}customElements.define(SiteOutlineBlock.tag,SiteOutlineBlock);export{SiteOutlineBlock};