/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../../../lit/index.js";import{store as n}from"../../core/haxcms-site-store.js";import{autorun as r,toJS as a}from"../../../../../mobx/dist/mobx.esm.js";import"../query/site-query-menu-slice.js";class SiteChildrenBlock extends e{static get tag(){return"site-children-block"}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"HAXcms: child block",description:"Dynamic block to show child of the current page",icon:"av:call-to-action",color:"grey",tags:["Other","haxcms"],handles:[],meta:{author:"HAXTheWeb core team",owner:"The Pennsylvania State University"}},settings:{configure:[],advanced:[{property:"dynamicMethodology",title:"Dynamic method",description:"How to calculate the children relative to this element",inputMethod:"select",options:{active:"Active children",parent:"Parent's children",ancestor:"All children from the highest ancestor"}},{property:"start",title:"Start level",inputMethod:"number"},{property:"end",title:"End level",inputMethod:"number"}]},demoSchema:[{tag:"site-children-block",properties:{},content:""}]}}constructor(){super(),this.__disposer=[],this.dynamicMethodology="active",this.start=0,this.end=1e3,this.fixedId=!1,this.__items=[]}static get styles(){return[i`
        :host {
          display: block;
          --site-children-block-indent: 16px;
          --site-children-block-link-active-bg: rgba(255, 255, 255, 0.1);
          transition: 0.2s opacity linear;
          opacity: 1;
        }
        :host([edit-mode]) {
          opacity: 0.2;
          pointer-events: none;
        }
        .link {
          display: block;
          color: var(--site-children-block-link-color, #444444);
          text-decoration: none;
        }
        .link button:hover,
        .link button:focus {
          text-decoration: underline;
        }
        button {
          cursor: pointer;
          display: block;
          line-height: inherit;
          font-size: inherit;
          padding: 0;
          margin: 0;
          text-align: left;
          text-transform: unset;
          min-width: unset;
          width: 100%;
          margin: 0;
          border-radius: 0;
          justify-content: flex-start;
          background-color: transparent;
          border: none;
          color: inherit;
        }
        ul {
          margin: 0;
          padding: 0;
          list-style: none;
        }
        li {
          margin: 0;
          padding: 0;
        }
        .active {
          color: var(--site-children-block-link-active-color, #000000);
          background-color: var(--site-children-block-link-active-bg);
        }
        .spacing .indent {
          display: inline-flex;
        }
        .indent-1 {
          margin-left: calc(var(--site-children-block-indent) * 1);
        }
        .indent-2 {
          margin-left: calc(var(--site-children-block-indent) * 2);
        }
        .indent-3 {
          margin-left: calc(var(--site-children-block-indent) * 3);
        }
        .indent-4 {
          margin-left: calc(var(--site-children-block-indent) * 4);
        }
        .indent-5 {
          margin-left: calc(var(--site-children-block-indent) * 5);
        }
        .indent-6 {
          margin-left: calc(var(--site-children-block-indent) * 6);
        }
        .indent-7 {
          margin-left: calc(var(--site-children-block-indent) * 7);
        }
        .indent-8 {
          margin-left: calc(var(--site-children-block-indent) * 8);
        }
        .indent-9 {
          margin-left: calc(var(--site-children-block-indent) * 9);
        }
        .indent-10 {
          margin-left: calc(var(--site-children-block-indent) * 10);
        }
      `]}resultChanged(e){this.__items=[...e.detail]}render(){return t`
      <ul class="wrapper">
        <site-query-menu-slice
          @result-changed="${this.resultChanged}"
          dynamic-methodology="${this.dynamicMethodology}"
          start="${this.start}"
          end="${this.end}"
          parent="${this.parent}"
          ?fixed-id="${this.fixedId}"
        ></site-query-menu-slice>
        ${this.__items.map((e=>t`${!0===e.metadata.hideInMenu||!1===e.metadata.published?"":t`
                  <li class="spacing">
                    <a
                      data-id="${e.id}"
                      class="link"
                      tabindex="-1"
                      href="${e.slug}"
                    >
                      <button>
                        <div class="indent indent-${e.indent}"></div>
                        ${e.title}
                      </button>
                    </a>
                  </li>
                `} `))}
      </ul>
    `}static get properties(){return{dynamicMethodology:{type:String,attribute:"dynamic-methodology"},start:{type:Number},end:{type:Number},parent:{type:String},fixedId:{type:Boolean,attribute:"fixed-id"},__items:{type:Array},activeId:{type:String,attribute:"active-id"},editMode:{type:Boolean,reflect:!0,attribute:"edit-mode"}}}_activeIdChanged(e){if(e){let t=null;if(this.shadowRoot.querySelector('[data-id="'+e+'"]'))t=this.shadowRoot.querySelector('[data-id="'+e+'"]');else{let i=this.manifest.items.find((t=>t.id==e));for(;null===t&&i&&null!=i.parent;)i=this.manifest.items.find((e=>e.id==i.parent)),i&&this.shadowRoot.querySelector('[data-id="'+i.id+'"]')&&(t=this.shadowRoot.querySelector('[data-id="'+i.id+'"]'))}this._prevEl&&this._prevEl.classList.remove("active"),t&&(t.classList.add("active"),this._prevEl=t)}else this._prevEl&&this._prevEl.classList.remove("active")}updated(e){super.updated(e),e.forEach(((e,t)=>{"__items"===t&&this.dispatchEvent(new CustomEvent(`${this[t]}-changed`,{detail:this[t]})),"_activeId"===t&&this.shadowRoot&&this._activeIdChanged(this[e])}))}connectedCallback(){super.connectedCallback(),r((e=>{this.editMode=a(n.editMode),this.__disposer.push(e)})),r((e=>{this.manifest=a(n.manifest),this.__disposer.push(e)})),setTimeout((()=>{r((e=>{this.activeId=a(n.activeId),this.__disposer.push(e)}))}),250)}disconnectedCallback(){for(var e in this.__disposer)this.__disposer[e].dispose();super.disconnectedCallback()}}customElements.define(SiteChildrenBlock.tag,SiteChildrenBlock);export{SiteChildrenBlock};