/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../../../lit/index.js";import{store as s}from"../../core/haxcms-site-store.js";import{iconFromPageType as o}from"../../../../course-design/lib/learning-component.js";import{autorun as a,toJS as r}from"../../../../../mobx/dist/mobx.esm.js";import"../../../../simple-icon/lib/simple-icon-lite.js";class SiteActiveTitle extends t{static get tag(){return"site-active-title"}render(){return e`
      <style>
        site-active-title {
          display: block;
          text-align: start;
        }
        site-active-title[edit-mode]:hover {
          cursor: pointer;
          outline: 2px solid var(--hax-ui-color-hover, #0001);
          transition: 0.2s outline-width ease-in-out;
          outline-offset: 8px;
        }
        h1 .site-active-title-icon {
          --simple-icon-height: 32px;
          --simple-icon-width: 32px;
          margin-right: 8px;
          vertical-align: middle;
        }
      </style>
      <h1>
        ${this.icon?e`
              <simple-icon-lite
                class="site-active-title-icon"
                icon="${this.icon}"
              ></simple-icon-lite>
            `:""}
        ${this.__title}
      </h1>
    `}updated(t){t.forEach(((t,e)=>{"dynamicMethodology"==e&&(this.__title=this._makeTitle(this.dynamicMethodology,this.activeTitle,this.parentTitle,this.ancestorTitle)),"editMode"==e&&void 0!==t&&(this.editMode?setTimeout((()=>{const t=globalThis.HaxStore.requestAvailability();this.activateController=new AbortController,this.addEventListener("click",(e=>{t.activeNode=t.activeHaxBody.querySelector("page-break")}),{signal:this.activateController.signal}),this._inProgressPageBreak=new MutationObserver((e=>{e.forEach((e=>{if("attributes"===e.type)switch(e.attributeName){case"title":this.activeTitle=t.activeHaxBody.querySelector("page-break").title,this.__title=this._makeTitle(this.dynamicMethodology,this.activeTitle,this.parentTitle,this.ancestorTitle);break;case"icon":case"page-type":t.activeHaxBody.querySelector("page-break").icon?this.icon=t.activeHaxBody.querySelector("page-break").icon:t.activeHaxBody.querySelector("page-break").pageType?this.icon=o(t.activeHaxBody.querySelector("page-break").pageType):this.icon=null}}))})),this._inProgressPageBreak.observe(t.activeHaxBody.querySelector("page-break"),{attributeFilter:["title","page-type","icon"],attributes:!0})}),0):(this.noFallback=!1,this.activateController.abort(),this._inProgressPageBreak.disconnect()))}))}static get properties(){return{__title:{type:String},icon:{type:String},dynamicMethodology:{type:String},editMode:{type:Boolean,reflect:!0,attribute:"edit-mode"}}}_makeTitle(t,e,i,s){switch(t){case"above":return""!==i||this.noFallback?i:e;case"ancestor":return""!==s||this.noFallback?s:e;default:return e}}constructor(){super(),this.activateController=new AbortController,this.noFallback=!1,this.dynamicMethodology="active",this.__title="",this.icon=null,this.__disposer=[],a((t=>{this.editMode=r(s.editMode),this.__disposer.push(t)})),a((t=>{const e=r(s.activeItem);e&&e.metadata&&e.metadata.icon?this.icon=e.metadata.icon:this.icon=null,this.__disposer.push(t)})),a((t=>{this.activeTitle=r(s.activeTitle),this.__title=this._makeTitle(this.dynamicMethodology,this.activeTitle,this.parentTitle,this.ancestorTitle),this.__disposer.push(t)})),a((t=>{this.ancestorTitle=r(s.ancestorTitle),this.__title=this._makeTitle(this.dynamicMethodology,this.activeTitle,this.parentTitle,this.ancestorTitle),this.__disposer.push(t)})),a((t=>{this.parentTitle=r(s.parentTitle),this.__title=this._makeTitle(this.dynamicMethodology,this.activeTitle,this.parentTitle,this.ancestorTitle),this.__disposer.push(t)}))}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();super.disconnectedCallback()}createRenderRoot(){return this}}customElements.define(SiteActiveTitle.tag,SiteActiveTitle);export{SiteActiveTitle};