/**
 * Copyright 2023 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../../../lit/index.js";import{store as s}from"../../core/haxcms-site-store.js";import{autorun as a,toJS as o}from"../../../../../mobx/dist/mobx.esm.js";import"../../../../simple-fields/lib/simple-tags.js";class SiteActiveTags extends t{static get tag(){return"site-active-tags"}static get styles(){return[i`
        :host {
          display: block;
        }
        a {
          text-decoration: none;
        }
        :host([edit-mode]) .tag-wrap {
          pointer-events: none;
        }
      `]}render(){return e`<div class="tag-wrap"></div>${this.tags&&""!=this.tags&&this.tags.split?this.tags.split(",").map((t=>e` <a
                @click="${this.testEditMode}"
                href="x/views?tags=${t.trim()}"
              >
                <simple-tag
                  ?auto-accent-color="${this.autoAccentColor}"
                  value="${t.trim()}"
                  accent-color="${this.accentColor}"
                ></simple-tag>
              </a>`)):""}</div>`}testEditMode(t){this.editMode&&(t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation())}static get properties(){return{tags:{type:String},autoAccentColor:{type:Boolean,attribute:"auto-accent-color"},accentColor:{type:String,attribute:"accent-color"},editMode:{type:Boolean,reflect:!0,attribute:"edit-mode"}}}constructor(){super(),this.autoAccentColor=!1,this.accentColor=null,this.tags=null,this.__disposer=[],a((t=>{this.tags=o(s.activeTags),this.__disposer.push(t)})),a((t=>{this.editMode=o(s.editMode),this.__disposer.push(t)}))}updated(t){t.forEach(((t,e)=>{"editMode"==e&&void 0!==t&&(this.editMode?setTimeout((()=>{const t=globalThis.HaxStore.requestAvailability();this.activateController=new AbortController,this.addEventListener("click",(e=>{t.activeNode=t.activeHaxBody.querySelector("page-break")}),{signal:this.activateController.signal}),this._inProgressPageBreak=new MutationObserver((e=>{e.forEach((e=>{if("attributes"===e.type)if("tags"===e.attributeName)this.tags=t.activeHaxBody.querySelector("page-break").tags}))})),this._inProgressPageBreak.observe(t.activeHaxBody.querySelector("page-break"),{attributeFilter:["tags"],attributes:!0})}),0):(this.noFallback=!1,this.activateController.abort(),this._inProgressPageBreak.disconnect()))}))}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();super.disconnectedCallback()}}customElements.define(SiteActiveTags.tag,SiteActiveTags);export{SiteActiveTags};