/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../../../lit/index.js";import{HAXCMSLitElementTheme as i}from"../core/HAXCMSLitElementTheme.js";class HAXCMSDevTheme extends i{static get tag(){return"haxcms-dev-theme"}constructor(){super(),import("../../../simple-icon/simple-icon.js"),import("../../../simple-icon/lib/simple-icons.js"),import("../../../simple-tooltip/simple-tooltip.js"),import("../ui-components/active-item/site-active-title.js"),import("../ui-components/blocks/site-children-block.js"),import("../ui-components/navigation/site-breadcrumb.js"),import("../ui-components/navigation/site-menu.js"),import("../ui-components/navigation/site-menu-button.js"),import("../ui-components/navigation/site-top-menu.js"),import("../ui-components/query/site-query.js"),import("../ui-components/query/site-query-menu-slice.js"),import("../ui-components/site/site-rss-button.js"),import("../ui-components/site/site-title.js")}static get styles(){return[super.styles,e`
        :host {
          display: block;
          /* theme color which is dictated by the manifest */
          background-color: var(--haxcms-color, black);
        }
        div.card {
          width: 200px;
          color: black;
          background-color: blue;
          padding: 8px;
          font-size: 10px;
        }
        /**
         * Hide the slotted content during edit mode. This must be here to work.
         */
        :host([edit-mode]) #slot {
          display: none;
        }
        .manifest,
        .activeitem {
          width: 49%;
          min-height: 300px;
          height: 300px;
          overflow: scroll;
          border: 4px solid black;
          margin: 0;
          padding: 0;
          display: inline-block;
          vertical-align: text-top;
        }
        .buttons {
          display: flex;
        }
        site-top-menu {
          --site-top-menu-bg: var(
            --simple-colors-default-theme-blue-grey-7,
            #37474f
          );
          --site-top-menu-link-color: #ffffff;
          --site-top-menu-indicator-color: var(--haxcms-color, #ffffff);
          --site-top-menu-link-active-color: yellow;
          --site-top-menu-indicator-arrow: 8px;
        }
        .spacing button {
          min-width: unset;
          text-transform: unset;
          background-color: var(--haxcms-color, #000000);
          color: #ffffff;
          margin: 0;
          border-radius: 0;
        }
        site-children-block {
          --site-children-block-button-active: {
            background-color: var(
              --simple-colors-default-theme-blue-grey-7,
              #37474f
            );
            color: #ffffff;
          };
        }
      `]}render(){return t`
      <site-top-menu noink indicator="arrow" arrow-size="8">
        <div slot="suffix" class="spacing">
          <a
            rel="noopener noreferrer"
            target="_blank"
            tabindex="-1"
            href="https://github.com/haxtheweb/haxcms-php"
            data-title="Get it. Got it? Good."
          >
            <button noink>Get HAXcms</button>
          </a>
          <site-print-button></site-print-button>
          <site-print-button type="parent"></site-print-button>
          <site-print-button type="ancestor"></site-print-button>
          <site-print-button type="site"></site-print-button>
        </div>
      </site-top-menu>
      <site-children-block
        fixed-id
        parent="item-14e9e811-8d92-41ee-b2f1-8248eacc3138"
      >
      </site-children-block>
      <h1 style="margin:0;">HAXCMS DEVELOPMENT THEME</h1>
      <site-title></site-title>
      <div class="buttons">
        <site-menu-button type="prev"></site-menu-button>
        <site-menu-button type="next"></site-menu-button>
        <button id="unset" on-click="resetActive">Unset activeItem</button>
        <site-rss-button type="atom"></site-rss-button>
        <site-rss-button type="rss"></site-rss-button>
      </div>
      <div class="manifest">
        <h2>title: ${manifest.title}</h2>
        <div>description: ${manifest.description}</div>
        <div>
          icon:
          <simple-icon
            icon="${manifest.metadata.theme.variables.icon}"
          ></simple-icon>
        </div>
        <div>
          image:
          <img
            src="${manifest.metadata.theme.variables.image}"
            height="200px"
            width="200px"
          />
        </div>
      </div>
      <div class="activeitem">
        <site-breadcrumb></site-breadcrumb>
        <h2>ACTIVE ITEM</h2>
        <site-active-title></site-active-title>
        <div id="contentcontainer">
          <div id="slot"><slot></slot></div>
        </div>
      </div>
      ${this.items.map((e=>t`
          <div style="padding:8px;">
            <div class="card">
              <div class="card-content">
                <div>title: ${e.title}</div>
                <div>description: ${e.description}</div>
                <div>slug: ${e.slug}</div>
                <div>location: ${e.location}</div>
                <div>changed: ${e.metadata.updated}</div>
              </div>
              <div class="card-actions">
                <a tabindex="-1" href$="${e.slug}"
                  ><button data-id$="${e.id}" @click="${this._itemTapped}">
                    Set as active
                  </button></a
                >
              </div>
            </div>
          </div>
        `))}
      <site-menu></site-menu>
    `}_itemTapped(t){var e=t.target,i=e.getAttribute("data-id");"BUTTON"===e.tagName&&void 0!==i&&console.warn(this.manifest)}}customElements.define(HAXCMSDevTheme.tag,HAXCMSDevTheme);export{HAXCMSDevTheme};