import{store as e}from"./haxcms-site-store.js";import{toJS as t}from"../../../../mobx/dist/mobx.esm.js";import{LitElement as i,html as s,css as a}from"../../../../lit/index.js";import{HAXCMSI18NMixin as l}from"./utils/HAXCMSI18NMixin.js";import{MicroFrontendRegistry as o}from"../../../micro-frontend-registry/micro-frontend-registry.js";import{enableServices as n}from"../../../micro-frontend-registry/lib/microServices.js";import"../../../a11y-tabs/a11y-tabs.js";import"../../../accent-card/accent-card.js";import"../../../retro-card/retro-card.js";import"../../../simple-img/simple-img.js";import"../../../simple-fields/simple-fields.js";import"../../../lesson-overview/lib/lesson-highlight.js";import"../../../../@github/time-elements/dist/relative-time-element.js";import"../../../iframe-loader/lib/loading-indicator.js";import{learningComponentTypes as r,iconFromPageType as c}from"../../../course-design/lib/learning-component.js";n(["haxcms","core"]);class HAXCMSShareDialog extends(l(i)){static get styles(){return[a`
        :host {
          display: block;
          overflow: auto;
          height: 85vh;
          padding: 16px;
        }
        :host([hide-results*="link-status-false"]) .link-status-false,
        :host([hide-results*="link-status-true"]) .link-status-true {
          display: none;
        }
        .selector-wrapper {
          margin-bottom: 32px;
          font-size: 24px;
          line-height: 24px;
        }
        .selector-wrapper select,
        .selector-wrapper button {
          font-size: 20px;
          line-height: 24px;
          margin: 0 8px;
          padding: 4px;
        }
        ul {
          list-style: none;
          margin: 0;
          padding: 0;
        }
        a11y-tabs {
          --a11y-tabs-horizontal-background: white;
        }
        a11y-tabs::part(tab) {
          font-size: 24px;
        }
        a11y-tabs[active-tab="insights"]::part(tab-insights) {
          color: var(--simple-colors-default-theme-purple-8);
        }
        a11y-tabs[active-tab="linkchecker"]::part(tab-linkchecker) {
          color: var(--simple-colors-default-theme-orange-8);
        }
        a11y-tabs[active-tab="mediabrowser"]::part(tab-mediabrowser) {
          color: var(--simple-colors-default-theme-red-8);
        }
        a11y-tabs[active-tab="contentbrowser"]::part(tab-contentbrowser) {
          color: var(--simple-colors-default-theme-blue-8);
        }
        a11y-tab#insights loading-indicator {
          --loading-indicator-color: var(
            --simple-colors-default-theme-purple-8
          );
        }
        a11y-tab#linkchecker loading-indicator {
          --loading-indicator-color: var(
            --simple-colors-default-theme-orange-8
          );
        }
        a11y-tab#mediabrowser loading-indicator {
          --loading-indicator-color: var(--simple-colors-default-theme-red-8);
        }
        a11y-tab#contentbrowser loading-indicator {
          --loading-indicator-color: var(--simple-colors-default-theme-blue-8);
        }
        simple-fields-field[type="checkbox"],
        simple-fields-field[type="select"] {
          display: inline-block;
          margin: 16px;
        }
        simple-icon {
          --simple-icon-height: 24px;
          --simple-icon-width: 24px;
          padding: 2px;
        }
        accent-card {
          height: 225px;
          width: 300px;
          overflow-x: hidden;
          overflow-y: auto;
          --accent-card-image-width: 25%;
          --accent-card-image-x: left;
          --accent-card-image-y: top;
        }
        accent-card .title-link {
          text-decoration: none;
          font-family: "Roboto Mono", Consolas, Monospace;
          font-size: 20px;
          color: blue;
        }
        accent-card .title-link:hover,
        accent-card .title-link:focus,
        accent-card .title-link:active {
          text-decoration: underline;
          color: black;
        }
        accent-card .stats {
          height: 125px;
        }
        .content-list li accent-card .stats li {
          display: block;
          padding: 0px;
          margin: 0px;
          list-style: none;
        }
        .content-list li accent-card .stats li simple-icon {
          padding-right: 8px;
        }
        .content-list li {
          display: inline-block;
          margin: 0;
          padding: 0;
          font-size: 12px;
          --accent-card-padding: 0;
        }
        .insights {
          column-count: 3;
        }
        .insights .recently-updated-items {
          font-size: 16px;
          line-height: 20px;
        }
        .media-list li {
          margin: 8px;
          display: inline-flex;
        }
        .media-list retro-card {
          width: 350px;
        }
        .media-list retro-card::part(title) {
          padding: 0;
          font-size: 20px;
          overflow: hidden;
          text-overflow: ellipsis;
          word-break: break-word;
          height: 75px;
        }
        .media-list retro-card::part(description) {
          padding: 0;
          font-size: 14px;
        }
        .media-list retro-card .body {
          height: 275px;
        }
        .media-list retro-card img {
          max-height: 225px;
          width: 275px;
        }
        .mediabrowser-wrapper {
          overflow: hidden;
        }
      `]}updated(e){super.updated(e),e.forEach(((e,t)=>{"activeTab"===t&&this[t]&&this.refreshData()}))}_insightResponse(e){this.loading=!1,this.data=e.data,this._originalData=JSON.parse(JSON.stringify(e.data)),this.filters={},setTimeout((()=>{switch(this.activeTab){case"linkchecker":this.filters={links:"all"},this.shadowRoot.querySelector("#schema").fields=[{property:"links",title:"Link status",inputMethod:"select",options:{all:"All",error:"Error only",ok:"OK only"}}];break;case"contentbrowser":this.filters={sort:"title",title:"",hasVideo:!1,hasH5P:!1,hasAuthorNotes:!1,hasLinks:!1,hasImages:!1,hasPlaceholders:!1,hasSiteRemoteContent:!1},this.shadowRoot.querySelector("#schema").value=this.filters,this.shadowRoot.querySelector("#schema").fields=[{property:"title",title:"Title",inputMethod:"textfield"},{property:"pageType",title:"Page type",inputMethod:"select",options:{"":"",...r}},{property:"sort",title:"Sort by",inputMethod:"select",options:{title:"Title",lastUpdated:"Last updated",contentLength:"Content length"}},{property:"hasAuthorNotes",title:"Author notes",description:"Includes content editor notes",inputMethod:"boolean"},{property:"hasVideo",title:"Video",description:"Includes video",inputMethod:"boolean"},{property:"hasH5P",title:"H5P",description:"Includes h5p",inputMethod:"boolean"},{property:"hasPlaceholders",title:"Placeholders",description:"Includes placeholders",inputMethod:"boolean"},{property:"hasSiteRemoteContent",title:"Remote content",description:"Includes remote content",inputMethod:"boolean"},{property:"hasLinks",title:"Links",description:"Includes external links",inputMethod:"boolean"},{property:"hasImages",title:"Images",description:"Includes images",inputMethod:"boolean"}];break;case"mediabrowser":this.filters={title:"",type:"all",location:"all"},this.shadowRoot.querySelector("#schema").fields=[{property:"title",title:"Title",inputMethod:"textfield"},{property:"status",title:"Status",inputMethod:"select",options:{all:"All",info:"No issues",warning:"Warnings",error:"Errors"}},{property:"type",title:"Media type",inputMethod:"select",options:{all:"All",audio:this.t.audio,video:this.t.video,image:this.t.images,h5p:"H5P",document:"Document"}},{property:"location",title:"Location",inputMethod:"select",options:{all:"All",external:"External only",internal:"Internal only"}}],this.shadowRoot.querySelector("#schema").values=this.filters}}),0)}refreshData(){let i=this.base;""==i&&globalThis.document.querySelector("base")&&(i=globalThis.document.querySelector("base").href);const s=t(e.manifest),a={type:"site",site:{file:i+"site.json",id:s.id,title:s.title,author:s.author,description:s.description,license:s.license,metadata:s.metadata,items:s.items},activeId:this.shadowRoot.querySelector("#selector").value,link:i};switch(this.loading=!0,this.activeTab){case"insights":o.call("@haxcms/insights",a,this._insightResponse.bind(this),this);break;case"linkchecker":o.call("@haxcms/linkChecker",a,this._insightResponse.bind(this),this);break;case"contentbrowser":o.call("@haxcms/contentBrowser",a,this._insightResponse.bind(this),this);break;case"mediabrowser":o.call("@haxcms/mediaBrowser",a,this._insightResponse.bind(this),this);break;default:this.loading=!1}}static get tag(){return"haxcms-site-insights"}getReadingTime(e){let t=[];var i=Math.floor(e/60),s=Math.floor(e-60*i);return 1===i?t.push(`${i} ${this.t.hour}`):0===i||t.push(`${i} ${this.t.hours}`),1===s?t.push(`${s} ${this.t.minute}`):0===s||t.push(`${s} ${this.t.minutes}`),t.join(", ")}closeModal(){globalThis.dispatchEvent(new CustomEvent("simple-modal-hide"))}activeChanged(e){this.activeTab=e.detail.activeTab}linkFormChanged(e){this.filters.links=e.detail.value.links,"error"===this.filters.links?this.hideResults="link-status-true":"ok"===this.filters.links&&(this.hideResults="link-status-false")}contentBrowserFormChanged(e){this.data=JSON.parse(JSON.stringify(this._originalData));let t=e.detail.value;this.filters={title:t.title?t.title:"",sort:t.sort,pageType:t.pageType,hasVideo:t.hasVideo,hasH5P:t.hasH5P,hasAuthorNotes:t.hasAuthorNotes,hasPlaceholders:t.hasPlaceholders,hasSiteRemoteContent:t.hasSiteRemoteContent,hasLinks:t.hasLinks,hasImages:t.hasImages},this.data.contentData&&(this.data.contentData=this.data.contentData.filter((e=>(!0!==this.filters.hasVideo||0!==e.videos)&&((!0!==this.filters.hasH5P||0!==e.h5p)&&((!0!==this.filters.hasAuthorNotes||0!==e.authorNotes)&&((!0!==this.filters.hasPlaceholders||0!==e.placeholders)&&((!0!==this.filters.hasSiteRemoteContent||0!==e.siteremotecontent)&&((!0!==this.filters.hasLinks||0!==e.links)&&((!0!==this.filters.hasImages||0!==e.images)&&(""==this.filters.pageType||!this.filters.pageType||e.pageType==this.filters.pageType&&(""==this.filters.title||!!e.title.toLowerCase().includes(this.filters.title.toLowerCase()))))))))))),this.data.contentData.sort(((e,t)=>{switch(this.filters.sort){case"title":return e.title.localeCompare(t.title);case"contentLength":return t.readTime-e.readTime;case"lastUpdated":return new Date(t.updated)-new Date(e.updated)}})))}mediaBrowserFormChanged(e){this.data=JSON.parse(JSON.stringify(this._originalData));let t=e.detail.value;this.filters={title:t.title?t.title:"",type:t.type?t.type:"all",status:t.status?t.status:"all",location:t.location?t.location:"all"},this.data.mediaData&&(this.data.mediaData=this.data.mediaData.filter((e=>"all"==this.filters.location||this.filters.location==e.locType)),this.data.mediaData=this.data.mediaData.filter((e=>"all"==this.filters.status||this.filters.status==e.status)),this.data.mediaData=this.data.mediaData.filter((e=>"all"==this.filters.type||this.filters.type==e.type)),this.data.mediaData=this.data.mediaData.filter((e=>!this.filters.title||""==this.filters.title||!(this.filters.title.toLowerCase&&!e.name.toLowerCase().includes(this.filters.title.toLowerCase())))))}render(){const e=this.data;let t=this.base;return""==t&&globalThis.document.querySelector("base")&&(t=globalThis.document.querySelector("base").href),s`
      ${this.pageSelector()}
      <a11y-tabs
        id="tabs"
        full-width
        @a11y-tabs-active-changed="${this.activeChanged}"
        sticky
      >
        <a11y-tab
          id="insights"
          icon="hax:clipboard-pulse"
          label="${this.t.insights}"
        >
          ${"insights"===this.activeTab?s`
                <loading-indicator
                  full
                  ?loading="${this.loading}"
                ></loading-indicator>
                ${this.loading?s`<p>${this.t.loading} ${this.t.insights}..</p>`:s`
        <div class="insights">
          <h2>${e&&e.title?e.title:""} ${this.t.insights}</h2>
          <ul>
            <li>
            <lesson-highlight icon="editor:insert-drive-file">
              <p slot="title">${e.pages?e.pages:s`0`} ${this.t.pages}</p>
              <p>${e.objectives} ${this.t.learningObjectives},
              ${e.authorNotes} ${this.t.authorNotes},
              ${e.specialTags} ${this.t.specialElements},
              ${e.dataTables} ${this.t.dataTables},
              ${e.headings} ${this.t.headings}</p>
            </lesson-highlight>
            </li>
            ${0==e.video?"":s`<li>
                    <lesson-highlight icon="av:play-circle-outline">
                      <p slot="title">${e.video} ${this.t.videos}</p>
                      ${0!=e.videoLength?s`(
                            <p>${function toHHMMSS(e){var t="",i=parseInt(e,10),s=Math.floor(i/3600),a=Math.floor((i-3600*s)/60);0!==s&&(t+=`${s} hour`,1!==s&&(t+="s"),t+=", ");0!==a&&(t+=`${a} minute`,1!==s&&(t+="s"));return t}(e.videoLength)}</p>
                            )`:""}
                    </lesson-highlight>
                  </li>`}
            ${0==e.h5p?"":s`<li>
                    <lesson-highlight icon="lrn:interact">
                      <p slot="title">${e.h5p} H5P</p>
                    </lesson-highlight>
                  </li>`}
            ${0==e.audio?"":s`<li>
                    <lesson-highlight icon="av:music-video">
                      <p slot="title">${e.audio} ${this.t.audio}</p>
                    </lesson-highlight>
                  </li>`}
            <li>
            <lesson-highlight icon="icons:link">
              <p slot="title">${e.links} ${this.t.externalLinks}</p>
            </lesson-highlight>
            </li>
            <li>
            <lesson-highlight icon="communication:import-contacts">
              <p slot="title">${this.getReadingTime(e.readTime)} ${this.t.ofReading}</p>
            </lesson-highlight>
            </li>
            ${e.readability?s`
                    <li>
                      <lesson-highlight icon="editable-table:numbers">
                        <p slot="title">${e.readability.gradeLevel}</p>
                        <p>Dale-Chall ${this.t.basedGradeReadingLevel}</p>
                      </lesson-highlight>
                    </li>
                    <li>
                      <lesson-highlight icon="hax:format-textblock">
                        <p slot="title">
                          ${e.readability.lexiconCount} ${this.t.words}
                        </p>
                        <p>
                          ${e.readability.difficultWords} ${this.t.longWords}
                        </p>
                      </lesson-highlight>
                    </li>
                  `:""}
            <li>
            <lesson-highlight icon="device:access-time">
              <p slot="title">${this.t.created}: <relative-time datetime="${e.created}"></relative-time></p>
            </lesson-highlight>
            </li>
            <li>
            <lesson-highlight icon="device:access-time">
              <p slot="title">${this.t.lastUpdated}: <relative-time datetime="${e.updated}"></relative-time></p>
            </lesson-highlight>
            </li>
            <li>
              <lesson-highlight icon="av:av-timer">
              <p slot="title">${this.t.recentUpdates}</p>
              <ol class="recently-updated-items">
                ${e.updatedItems?e.updatedItems.map((e=>s` <li>
                            <a @click="${this.closeModal}" href="${e.slug}"
                              >${e.title}
                              <relative-time
                                datetime="${e.metadata.updated}"
                              ></relative-time
                            ></a>
                          </li>`)):""}
              </ol>
              </lesson-highlight>
            </li>
            </ul>
            </div>
        </div>
      `}
              `:""}
        </a11y-tab>
        <a11y-tab
          id="linkchecker"
          icon="icons:link"
          label="${this.t.linkChecker}"
        >
          ${"linkchecker"==this.activeTab?s`
                <loading-indicator
                  full
                  ?loading="${this.loading}"
                ></loading-indicator>
                ${this.loading?s`<p>${this.t.loading} ${this.t.linkChecker}..</p>`:s`
                      <div>
                        <h2>${this.t.linkReport}</h2>
                        <form id="form">
                          <simple-fields
                            id="schema"
                            autofocus
                            @value-changed="${this.linkFormChanged}"
                          ></simple-fields>
                        </form>
                        <ul class="link-list">
                          ${e.linkData?Object.keys(e.linkData).map((t=>this.renderLinkCheck(e.linkData,t))):s`${this.t.noLinksInSelectedPages}`}
                        </ul>
                      </div>
                    `}
              `:""}
        </a11y-tab>
        <a11y-tab
          id="contentbrowser"
          icon="icons:view-module"
          label="${this.t.contentBrowser}"
        >
          ${"contentbrowser"==this.activeTab?s`
                <loading-indicator
                  full
                  ?loading="${this.loading}"
                ></loading-indicator>
                ${this.loading?s`<p>${this.t.loading} ${this.t.contentBrowser}..</p>`:s`
                      <div>
                        <h2>${this.t.contentBrowser}</h2>
                        <form id="form">
                          <simple-fields
                            id="schema"
                            autofocus
                            @value-changed="${this.contentBrowserFormChanged}"
                          ></simple-fields>
                        </form>
                        <ul class="content-list">
                          ${e.contentData?e.contentData.map((e=>s`
                                  <li>
                                    <accent-card
                                      image-src="https://screenshoturl.open-apis.hax.cloud/api/screenshotUrl?quality=25&render=img&urlToCapture=${t}${e.location}"
                                      horizontal
                                    >
                                      <div slot="heading">
                                        <a
                                          class="title-link"
                                          href="${e.slug}"
                                          @click="${this.closeModal}"
                                          >${e.pageType?s`
                                                <simple-icon-lite
                                                  title="${e.pageType}"
                                                  icon="${c(e.pageType)}"
                                                ></simple-icon-lite>
                                              `:""}
                                          ${e.title}</a
                                        >
                                      </div>
                                      <div slot="content">
                                        <div>
                                          ${this.t.created}
                                          <relative-time
                                            datetime="${e.created}"
                                          ></relative-time>
                                        </div>
                                        <div>
                                          ${this.t.lastUpdated}
                                          <relative-time
                                            datetime="${e.updated}"
                                          ></relative-time>
                                        </div>
                                      </div>
                                      <div slot="footer">
                                        <ul class="stats">
                                          ${e.objectives>0?s`<li>
                                                <simple-icon
                                                  icon="editor:format-list-bulleted"
                                                ></simple-icon
                                                >${e.objectives}
                                                ${this.t.learningObjectives}
                                              </li>`:""}
                                          ${e.authorNotes>0?s`<li>
                                                <simple-icon
                                                  icon="hax:figure"
                                                ></simple-icon
                                                >${e.authorNotes}
                                                ${this.t.authorNotes}
                                              </li>`:""}
                                          ${e.videos>0?s`<li>
                                                <simple-icon
                                                  icon="av:play-arrow"
                                                ></simple-icon
                                                >${e.videos} ${this.t.videos}
                                              </li>`:""}
                                          ${e.h5p>0?s`<li>
                                                <simple-icon
                                                  icon="lrn:interact"
                                                ></simple-icon
                                                >${e.h5p} H5P
                                              </li>`:""}
                                          ${e.placeholders>0?s`<li>
                                                <simple-icon
                                                  icon="hax:placeholder-image"
                                                ></simple-icon
                                                >${e.placeholders}
                                                ${this.t.placeholders}
                                              </li>`:""}
                                          ${e.audio>0?s`<li>
                                                <simple-icon
                                                  icon="av:music-video"
                                                ></simple-icon
                                                >${e.audio} ${this.t.audio}
                                              </li>`:""}
                                          ${e.selfChecks>0?s`<li>
                                                <simple-icon
                                                  icon="hardware:videogame-asset"
                                                ></simple-icon
                                                >${e.selfChecks}
                                                ${this.t.selfChecks}
                                              </li>`:""}
                                          ${e.images>0?s`<li>
                                                <simple-icon
                                                  icon="image:collections"
                                                ></simple-icon
                                                >${e.images} ${this.t.images}
                                              </li>`:""}
                                          ${e.dataTables>0?s`<li>
                                                <simple-icon
                                                  icon="image:grid-on"
                                                ></simple-icon
                                                >${e.dataTables}
                                                ${this.t.dataTables}
                                              </li>`:""}
                                          ${e.specialTags>0?s`<li>
                                                <simple-icon
                                                  icon="icons:stars"
                                                ></simple-icon
                                                >${e.specialTags}
                                                ${this.t.specialElements}
                                              </li>`:""}
                                          ${e.links>0?s`<li>
                                                <simple-icon
                                                  icon="icons:link"
                                                ></simple-icon
                                                >${e.links} ${this.t.links}
                                              </li>`:""}
                                          ${e.readTime>0?s`<li>
                                                <simple-icon
                                                  icon="icons:chrome-reader-mode"
                                                ></simple-icon
                                                >${this.getReadingTime(e.readTime)}
                                                ${this.t.ofReading}
                                              </li>`:""}
                                        </ul>
                                      </div>
                                    </accent-card>
                                  </li>
                                `)):""}
                        </ul>
                      </div>
                    `}
              `:""}
        </a11y-tab>
        <a11y-tab
          id="mediabrowser"
          icon="icons:perm-media"
          label="${this.t.mediaBrowser}"
        >
          ${"mediabrowser"==this.activeTab?s`
                <loading-indicator
                  full
                  ?loading="${this.loading}"
                ></loading-indicator>
                ${this.loading?s`<p>${this.t.loading} ${this.t.mediaBrowser}..</p>`:s`
                      <div class="mediabrowser-wrapper">
                        <h2>${this.t.mediaBrowser}</h2>
                        <form id="form">
                          <simple-fields
                            id="schema"
                            autofocus
                            @value-changed="${this.mediaBrowserFormChanged}"
                          ></simple-fields>
                        </form>
                        <ul class="media-list">
                          ${e.mediaData?e.mediaData.map((e=>s`
                                  <li>
                                    <retro-card
                                      nosource
                                      class="${e.locType} ${e.type}"
                                      accent-color="${this.accentColorFromType(e.type)}"
                                      title="${e.name} ${e.title}"
                                      tags="${e.locType}, ${e.type}"
                                    >
                                      <div class="body">
                                        ${"image"==e.type?s`<img
                                                src="${e.source}"
                                                alt="${e.alt}"
                                                title="${e.title}"
                                              />
                                              <div>
                                                ${this.analyzeAltData(e)}
                                              </div>`:""}
                                        ${"video"==e.type&&e.source.includes("videoseries")?s`<iframe
                                              src="${e.source}"
                                            ></iframe>`:""}
                                        ${"video"!=e.type||e.source.includes("videoseries")?"":s`<video-player
                                              source="${e.source}"
                                            ></video-player>`}
                                        ${"h5p"==e.type?s`<iframe
                                              src="${e.source}"
                                            ></iframe>`:""}
                                        ${"audio"==e.type?s`<video-player
                                              source="${e.source}"
                                            ></video-player>`:""}
                                        ${"document"==e.type?s`<div>
                                              <a
                                                href="${e.source}"
                                                target="_blank"
                                                >${this.t.openInNewTab}</a
                                              >
                                            </div>`:""}
                                        <div>
                                          ${e.itemId?this.renderItemLinkById(e.itemId):""}
                                        </div>
                                      </div>
                                    </retro-card>
                                  </li>
                                `)):`${this.t.noMediaInSelectedPages}`}
                        </ul>
                      </div>
                    `}
              `:""}
        </a11y-tab>
      </a11y-tabs>
    `}analyzeAltData(e){return null==e.alt||"null"==e.alt?s`<simple-icon
        icon="error"
        accent-color="red"
        title="missing alt text"
      ></simple-icon>`:e.name==e.alt||e.source==e.alt?s`<simple-icon
        icon="error"
        accent-color="red"
        title="alt text matches file name"
      ></simple-icon>`:e.title==e.alt?s`<simple-icon
        icon="error"
        accent-color="red"
        title="alt text matches title"
      ></simple-icon>`:""==e.alt?s`<simple-icon
        icon="warning"
        accent-color="yellow"
        title="alt text set to blank, ensure decorative image"
      ></simple-icon>`:e.alt&&e.alt.includes("image")?s`<simple-icon
        icon="warning"
        accent-color="yellow"
        title="alt text includes word 'image'"
      ></simple-icon>`:e.alt&&e.alt.includes("picture")?s`<simple-icon
        icon="warning"
        accent-color="yellow"
        title="alt text includes word 'picture'"
      ></simple-icon>`:s`<simple-icon
      icon="info"
      accent-color="blue"
      title="alt text: ${e.alt}"
    ></simple-icon>`}linkValidationResponse(e){let t=Object.keys(e.data);this.linkResponseData[t[0]]=e.data[t[0]],clearTimeout(this.__interval),this.__interval=setTimeout((()=>{this.requestUpdate()}),500)}renderLinkCheck(e,t){return this.linkResponseData[t]||(this.linkResponseData[t]={ok:"loading"},o.call("@core/linkValidator",{links:t},this.linkValidationResponse.bind(this))),s`
      <li class="link-status-${this.linkResponseData[t].ok}">
        ${"loading"===this.linkResponseData[t].ok?s`<simple-icon
              icon="hax:loading"
              accent-color="grey"
            ></simple-icon>`:""}
        ${"loading"!=this.linkResponseData[t].ok?this.linkResponseData[t].ok?s`<simple-icon
                icon="check"
                accent-color="green"
              ></simple-icon>`:s`<simple-icon
                icon="clear"
                accent-color="red"
                title="${this.linkResponseData[t].status}"
              ></simple-icon>`:""}
        ${"loading"!=this.linkResponseData[t].ok?this.linkResponseData[t].ok?s`<a
                href="${t}"
                target="_blank"
                rel="noopener nofollow noreferrer"
                >${t}</a
              >`:s`${t}`:""}
        (${e[t].map((e=>s`
            <strong>${e.linkTitle}</strong> ${this.t.onPage}
            ${e.itemId?this.renderItemLinkById(e.itemId):""}
          `))})
      </li>
    `}accentColorFromType(e){switch(e){case"video":return"red";case"h5p":return"purple";case"audio":return"orange";case"image":return"blue";case"document":return"green";default:return"grey"}}renderItemLinkById(i){if(null!=i){const a=t(e.findItem(i));if(a)return s`<a href="${a.slug}" @click="${this.closeModal}"
          >${a.title}</a
        >`}return s``}constructor(){super(),this.base="",this.filters={},this.linkResponseData={},this.t=this.t||{},this.t={...this.t,pageToProvideInsightsAbout:"Page to provide insights about",noLinksInSelectedPages:"No links in selected pages",noMediaInSelectedPages:"No media in selected pages",recentUpdates:"Recent updates",created:"Created",lastUpdated:"Last updated",updateInsights:"Update insights",onPage:"on page",learningObjectives:"learning objectives",specialElements:"Special elements",headings:"Headings",externalLinks:"External links",pages:"Pages",videos:"videos",authorNotes:"Author notes",placeholders:"Placeholders",video:"Video",audio:"Audio",selfChecks:"Self checks",openInNewTab:"Open in new tab",links:"Links",images:"Images",dataTables:"Data tables",ofReading:"of reading",basedGradeReadingLevel:"based grade reading level",words:"Words",longWords:"long words",linkReport:"Link report",loading:"Loading",fullSite:"Full site",insights:"Insights",linkChecker:"Link checker",mediaBrowser:"Media browser",contentBrowser:"Content browser",hour:"hour",hours:"hours",minute:"minute",minutes:"minutes"},this.data={readability:{},updatedItems:[]},this.activeTab="insights",this.loading=!1}static get properties(){return{...super.properties,data:{type:Object},hideResults:{type:String,attribute:"hide-results",reflect:!0},filters:{type:Object},linkResponseData:{type:Object},activeTab:{type:String},base:{type:String,reflect:!0},loading:{type:Boolean,reflect:!0}}}pageSelector(){const i=e.getManifestItems(!0);var a=[{text:`-- ${this.t.fullSite} --`,value:null}];return i.forEach((e=>{let t=e,s="- ";for(;t&&null!=t.parent;)t=i.find((e=>e.id==t.parent)),t&&(s="--"+s);a.push({text:s+e.title,value:e.id})})),s`<div class="selector-wrapper">
      <label style="font-weight:bold;" for="selector"
        >${this.t.pageToProvideInsightsAbout}</label
      >:<select id="selector">
        ${a.map((i=>s`
            <option
              .value="${i.value}"
              ?selected="${t(e.activeId)==i.value}"
            >
              ${i.text}
            </option>
          `))}
      </select>
      <button
        @click="${this.refreshData}"
        icon="refresh"
        ?disabled="${this.loading}"
      >
        ${this.t.updateInsights}
      </button>
    </div>`}}customElements.define(HAXCMSShareDialog.tag,HAXCMSShareDialog);export{HAXCMSShareDialog};