/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../../../lit/index.js";import{store as o}from"./haxcms-site-store.js";import{autorun as i,toJS as s}from"../../../../mobx/dist/mobx.esm.js";import"../../../simple-tooltip/simple-tooltip.js";import"../../../simple-fields/lib/simple-fields-form.js";import"../../../simple-icon/simple-icon.js";import"../../../simple-icon/lib/simple-icons.js";import"../../../simple-icon/lib/simple-icon-button.js";import{HaxUiBaseStyles as a}from"../../../hax-body/lib/hax-ui-styles.js";import{HaxSchematizer as r,HaxElementizer as l}from"../../../hax-body-behaviors/lib/HAXFields.js";import{SimpleColors as d}from"../../../simple-colors/simple-colors.js";class HAXCMSSiteDashboard extends d{static get tag(){return"haxcms-site-dashboard"}constructor(){super(),this.siteTitle="",this.method="POST",this.loadEndpoint="",this.body={},this.headers={},this.__disposer=[],i((t=>{this.jwt=s(o.jwt),this.__disposer.push(t)})),i((t=>{this.siteTitle=s(o.siteTitle),this.__disposer.push(t)}))}static get styles(){return[a,e`
        :host {
          z-index: 1;
          display: block;
          border-right: 2px solid #17271f;
          overflow: scroll;
          color: black;
        }
        .buttons {
          position: absolute;
          bottom: 0;
          left: 0;
          right: 0;
          display: flex;
        }
        button.hax-modal-btn {
          font-size: 30px;
          padding: 8px;
          margin: 4px;
          color: white;
          background-color: green;
          border: 4px solid black;
          border-radius: 8px;
          font-family: sans-serif;
        }
        button.hax-modal-btn.cancel {
          background-color: red;
        }
        button.hax-modal-btn:hover,
        button.hax-modal-btn:focus {
          outline: 2px solid black;
          cursor: pointer;
          background-color: darkgreen;
        }
        button.hax-modal-btn.cancel:hover,
        button.hax-modal-btn.cancel:focus {
          background-color: darkred;
        }
        .title {
          color: black;
          font-size: 24px;
          margin: 0 0 0 16px;
          padding: 0;
          display: inline-flex;
        }
        @media screen and (max-width: 600px) {
          .title {
            font-size: 14px;
            margin: 0;
          }
          .toptext {
            font-size: 11px;
          }
          button.hax-modal-btn {
            font-size: 14px;
          }
        }
        button {
          background-color: white;
          color: black;
        }
        .title-wrapper {
          padding: 0 16px;
        }
        .toptext {
          padding: 0;
          margin: 0;
          font-size: 12px;
          font-style: italic;
          display: inline-flex;
        }
        .fields-wrapper {
          height: auto;
          background-color: white;
        }
        #siteform {
          --a11y-tabs-height: 65vh;
          --a11y-tabs-tab-height: 60vh;
          --primary-color: var(--haxcms-color, #000000);
          --paper-input-container-focus-color: var(--haxcms-color, #000000);
          --lumo-primary-text-color: var(--haxcms-color, #000000);
          --a11y-tabs-color: var(--haxcms-color, #000000);
          --a11y-tabs-focus-color: var(--haxcms-color, #000000);
          color: var(--hax-ui-color);
          --simple-fields-color: var(--hax-ui-color);
        }
      `]}render(){return t`
      <div class="title-wrapper">
        <h2 class="title">${this.siteTitle} settings</h2>
      </div>
      <div class="fields-wrapper">
        <simple-fields-form
          id="siteform"
          .headers="${this.headers}"
          .body="${this.body}"
          .schematizer="${r}"
          .elementizer="${l}"
          load-endpoint="${this.loadEndpoint}"
          @simple-fields-form-data-loaded="${this.fieldDataLoaded}"
          method="${this.method}"
        ></simple-fields-form>
      </div>
      <div class="buttons">
        <button class="hax-modal-btn" @click="${this._saveSiteFieldsTap}">
          Save
        </button>
        <button class="hax-modal-btn cancel" @click="${this._cancel}">
          cancel
        </button>
      </div>
    `}static get properties(){return{...super.properties,loadEndpoint:{type:String,attribute:"load-endpoint"},headers:{type:Object},body:{type:Object},method:{type:String},jwt:{type:String},publishing:{type:Boolean},siteTitle:{type:String}}}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();super.disconnectedCallback()}fieldDataLoaded(){const t=o.getManifestItems(!0);var e=[{text:"",value:null}];t.forEach((o=>{if(o.id!=this.itemId){let i=o,s="- ";for(;i&&null!=i.parent;)i=t.find((t=>t.id==i.parent)),i&&(s="--"+s);e.push({text:s+o.title,value:o.id})}})),requestAnimationFrame((()=>{const t=this.shadowRoot.querySelector("#siteform").fields;t.find((t=>"manifest"===t.property)).properties.find((t=>"theme"===t.property)).properties.find((t=>"regions"===t.property)).properties.map((t=>{"array"===t.inputMethod&&(t.properties[0].itemsList=e)})),setTimeout((()=>{this.shadowRoot.querySelector("#siteform").fields=[...t],requestAnimationFrame((()=>{this.shadowRoot.querySelector("#siteform").requestUpdate()}))}),0)}))}generateRequest(){this.shadowRoot.querySelector("#siteform").loadData()}_saveSiteFieldsTap(t){o.playSound("click"),globalThis.dispatchEvent(new CustomEvent("haxcms-save-site-data",{bubbles:!0,composed:!0,cancelable:!0,detail:this.shadowRoot.querySelector("#siteform").submit()})),setTimeout((()=>{globalThis.dispatchEvent(new CustomEvent("simple-modal-hide",{bubbles:!0,cancelable:!0,detail:{}}))}),0)}_cancel(t){o.playSound("error"),globalThis.dispatchEvent(new CustomEvent("simple-modal-hide",{bubbles:!0,cancelable:!0,detail:{}}))}}customElements.define(HAXCMSSiteDashboard.tag,HAXCMSSiteDashboard);export{HAXCMSSiteDashboard};