import{LitElement as e,html as t,css as a}from"../../../../lit/index.js";import{HAXCMSI18NMixin as i}from"./utils/HAXCMSI18NMixin.js";import"../../../code-sample/code-sample.js";import"../../../simple-icon/simple-icon.js";import"../../../simple-icon/lib/simple-icons.js";class HAXCMSShareDialog extends(i(e)){static get styles(){return[a`
        :host {
          display: block;
          overflow: auto;
        }
        .buttons {
          position: absolute;
          bottom: 0;
          z-index: 1000000;
          background-color: var(--simple-modal-titlebar-background, #000000);
          color: var(--simple-modal-titlebar-color, #ffffff);
          left: 0;
          right: 0;
        }
        .buttons button {
          color: black;
          background-color: white;
        }
        simple-icon {
          margin-right: 4px;
        }
      `]}static get tag(){return"haxcms-share-dialog"}render(){return t`
      <form>
        <label for="access">Who are you sharing with?</label>
        <select @change="${this.calculateShareCode}" name="access" id="access">
          <option value="oer">Open to anyone</option>
          <option value="courses">Account required to view</option>
          <option value="iam">Editor rights required</option>
        </select>
        <details>
          <summary>Disable features</summary>
          <div>
            ${["left-col","right-col","search","breadcrumb","print","rss","git-link","footer","qr-code"].map((e=>t`
                <input
                  type="checkbox"
                  name="disable-features"
                  id="${e}"
                  value="${e}"
                  @change="${this.calculateShareCode}"
                /><label for="${e}">${e.replace("-"," ")}</label><br />
              `))}
          </div>
        </details>
        <label for="link">Link</label
        ><input type="text" id="link" value="${this.link}" size="125" /><br />
        <label for="iframe">Embed</label>
        <code-sample
          type="html"
          copy-clipboard-button
          id="iframe"
        ></code-sample>
        <label for="height">Embed height</label>
        <input
          id="height"
          type="text"
          name="height"
          value="600px"
          @input="${this.calculateShareCode}"
        />
      </form>
    `}calculateShareCode(){const e=new FormData(this.shadowRoot.querySelector("form"));let t={};for(var a of e.entries())t[a[0]]?t[a[0]]+=`,${a[1]}`:t[a[0]]=a[1];this.link=`${globalThis.location.href.replace("iam.",`${t.access}.`)}${t["disable-features"]?`?disable-features=${t["disable-features"]}`:""}`;var i=`<template>\n      <iframe\n        src="${this.link}"\n        height="${t.height}"\n        width="100%"\n        frameborder="0"\n        allow="autoplay; encrypted-media; fullscreen; picture-in-picture"\n      ></iframe>\n    </template>`;this.shadowRoot.querySelector("code-sample").innerHTML=i,this.shadowRoot.querySelector("code-sample")._updateContent()}firstUpdated(e){super.firstUpdated(e),this.calculateShareCode()}static get properties(){return{...super.properties,link:{type:String}}}constructor(){super(),this.link=globalThis.location.href}}customElements.define(HAXCMSShareDialog.tag,HAXCMSShareDialog);export{HAXCMSShareDialog};