import{LitElement as t,html as e,css as i}from"../../../../lit/index.js";import{store as o}from"./haxcms-site-store.js";import{autorun as s,toJS as n}from"../../../../mobx/dist/mobx.esm.js";import{HAXCMSI18NMixin as a}from"./utils/HAXCMSI18NMixin.js";import"../../../json-outline-schema/json-outline-schema.js";import"../../../outline-designer/outline-designer.js";import"../../../simple-icon/simple-icon.js";import"../../../simple-icon/lib/simple-icons.js";class HAXCMSOutlineEditorDialog extends(a(t)){static get styles(){return[i`
        :host {
          display: block;
          height: 70vh;
          overflow: auto;
          padding-bottom: 40px;
          padding-top: 16px;
          min-width: 70vw;
          font-family: var(--ddd-font-navigation);
        }
        .buttons {
          position: absolute;
          bottom: 0;
          z-index: 1000000;
          background-color: var(--simple-modal-titlebar-background, #000000);
          left: 0;
          right: 0px;
          padding-left: 8px;
        }
        .buttons button {
          color: black;
          background-color: white;
        }
        simple-icon {
          margin-right: 4px;
        }
        outline-designer:not(:defined) {
          display: none;
        }
        #toggle {
          float: right;
          text-transform: unset;
        }
        button.hax-modal-btn {
          font-size: 30px;
          padding: 8px;
          margin: 4px 8px;
          color: white;
          background-color: green;
          border: 4px solid black;
          border-radius: 8px;
          font-family: sans-serif;
        }
        button.hax-modal-btn.cancel {
          background-color: red;
        }
        button.hax-modal-btn:hover,
        button.hax-modal-btn:focus {
          outline: 2px solid black;
          cursor: pointer;
          background-color: darkgreen;
        }
        button.hax-modal-btn.cancel:hover,
        button.hax-modal-btn.cancel:focus {
          background-color: darkred;
        }
      `]}static get tag(){return"haxcms-outline-editor-dialog"}render(){return e`
      <outline-designer
        id="outline"
        edit-mode
        .hidden="${this.viewMode}"
        .items="${this.manifestItems}"
      ></outline-designer>
      <div class="buttons">
        <button @click="${this._saveTap}" class="hax-modal-btn">
          ${this.t.save}
        </button>
        <button @click="${this._cancelTap}" class="cancel hax-modal-btn">
          ${this.t.cancel}
        </button>
      </div>
    `}constructor(){super(),this.__disposer=[],this.manifestItems=[],this.viewMode=!1,this.t=this.t||{},this.t={...this.t,save:"Save",cancel:"cancel"}}static get properties(){return{opened:{type:Boolean},manifestItems:{type:Array},manifestItemsStatic:{type:String,attribute:"manifest-items-static"},viewLabel:{type:String,attribute:"view-label"},viewMode:{type:Boolean,attribute:"view-mode"}}}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"opened"==e&&this.dispatchEvent(new CustomEvent("opened-changed",{detail:this[e]})),"manifestItems"==e&&(this._manifestItemsChanged(this[e],t),this.dispatchEvent(new CustomEvent("manifest-edit-mode-changed",{detail:this[e]})))}))}_manifestItemsChanged(t){t&&(globalThis.JSONOutlineSchema.requestAvailability().items=t,this.manifestItemsStatic=JSON.stringify(t,null,2))}connectedCallback(){super.connectedCallback(),s((t=>{this.manifestItems=[...n(o.manifest.items)],setTimeout((()=>{this.shadowRoot&&this.shadowRoot.querySelector("#outline").__syncUIAndDataModel()}),500),this.__disposer.push(t)}))}disconnectedCallback(){for(var t in this.__disposer)this.__disposer[t].dispose();super.disconnectedCallback()}async _saveTap(t){o.playSound("click");const e=await this.shadowRoot.querySelector("#outline").getData();let i=0,s=0,n=0;e.items.map((t=>{t.delete?i++:t.new?n++:t.modified&&s++}));let a=`${n>0?`‣ ${n} new pages will be created\n`:""}${s>0?`‣ ${s} pages will be updated\n`:""}${i>0?`‣ ${i} pages will be deleted\n`:""}`,l=!1;l=""==a||globalThis.confirm(`Saving will commit the following actions:\n${a}\nAre you sure?`),l&&(globalThis.dispatchEvent(new CustomEvent("haxcms-save-outline",{bubbles:!0,composed:!0,detail:e.items})),setTimeout((()=>{this.dispatchEvent(new CustomEvent("simple-modal-hide",{bubbles:!0,composed:!0,cancelable:!1,detail:!1}))}),0))}_cancelTap(t){o.playSound("error"),this.dispatchEvent(new CustomEvent("simple-modal-hide",{bubbles:!0,composed:!0,cancelable:!1,detail:!1}))}}customElements.define(HAXCMSOutlineEditorDialog.tag,HAXCMSOutlineEditorDialog);export{HAXCMSOutlineEditorDialog};