/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t}from"../../../../../lit/index.js";import{store as i}from"../haxcms-site-store.js";import{autorun as s,toJS as a}from"../../../../../mobx/dist/mobx.esm.js";import{generateResourceID as o}from"../../../../utils/utils.js";import"../../../../beaker-broker/beaker-broker.js";import{HAXStore as n}from"../../../../hax-body/lib/hax-store.js";class HAXCMSBackendBeaker extends e{static get tag(){return"haxcms-backend-beaker"}render(){return t` <beaker-broker id="beaker"></beaker-broker> `}static get properties(){return{jwt:{type:String},manifest:{type:Object},activeItem:{type:Object}}}constructor(){super(),this.windowControllers=new AbortController,this.__disposer=[],s((e=>{this.jwt=a(i.jwt),this.__disposer.push(e)})),globalThis.addEventListener("jwt-token",this._jwtTokenFired.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("haxcms-save-site-data",this.saveManifest.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("haxcms-save-outline",this.saveOutline.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("haxcms-save-node",this.saveNode.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("haxcms-delete-node",this.deleteNode.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("haxcms-create-node",this.createNode.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("hax-app-picker-selection",this._appPicked.bind(this),{signal:this.windowControllers.signal})}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}_appPicked(e){if("dat"===e.detail.connection.protocol){e.preventDefault(),e.stopPropagation();let t=new FileReader;t.onload=e=>{let t="files/"+n.haxTray.shadowRoot.querySelector("#fileupload").files[0].name;this.shadowRoot.querySelector("#beaker").write(t,e.target.result),n.haxTray.shadowRoot.querySelector("#url").value=t,n.haxTray.shadowRoot.querySelector("hax-tray-upload").newAssetConfigure()},t.readAsArrayBuffer(n.haxTray.shadowRoot.querySelector("#fileupload").files[0])}}async saveNode(e){this.activeItem=e.detail,await this.shadowRoot.querySelector("#beaker").write(this.activeItem.location,await n.activeHaxBody.haxToContent()),i.cmsSiteEditor.instance.shadowRoot.querySelector("#toast").show("Page updated!");const t=new CustomEvent("haxcms-trigger-update-node",{bubbles:!0,composed:!0,cancelable:!1,detail:!0});i.cmsSiteEditor.instance.dispatchEvent(t)}async saveOutline(e){this.manifest=i.cmsSiteEditor.instance.manifest,this.manifest.items=e.detail,this.manifest.items.forEach(((e,t)=>{if(void 0===e.location){let i=o("item-");e.id=i,e.location="pages/"+i+"/index.html",e.order=t,e.description="",e.metadata={created:Math.floor(Date.now()/1e3),updated:Math.floor(Date.now()/1e3)},this.shadowRoot.querySelector("#beaker").archive.mkdir("pages/"+i),this.shadowRoot.querySelector("#beaker").write("pages/"+i+"/index.html","<p>Ex uno Plures</p>"),this.manifest.items[t]=e}})),this.shadowRoot.querySelector("#beaker").write("site.json",JSON.stringify(this.manifest,null,2)),i.cmsSiteEditor.instance.shadowRoot.querySelector("#toast").show("Outline saved!"),i.cmsSiteEditor.instance.dispatchEvent(new CustomEvent("haxcms-trigger-update",{bubbles:!0,composed:!0,cancelable:!1,detail:!0})),i.cmsSiteEditor.instance.dispatchEvent(new CustomEvent("json-outline-schema-changed",{bubbles:!0,composed:!0,cancelable:!1,detail:this.manifest}))}async deleteNode(e){let t=e.detail.item;this.manifest=i.cmsSiteEditor.instance.manifest,this.manifest.items=e.detail,this.manifest.items.forEach(((e,i)=>{e.id===t.id&&this.splice("manifest.items",i,1)})),this.shadowRoot.querySelector("#beaker").write("site.json",JSON.stringify(this.manifest,null,2)),i.cmsSiteEditor.instance.shadowRoot.querySelector("#toast").show(`${t.title} deleted`),i.cmsSiteEditor.instance.dispatchEvent(new CustomEvent("haxcms-trigger-update",{bubbles:!0,composed:!0,cancelable:!1,detail:!0})),i.cmsSiteEditor.instance.dispatchEvent(new CustomEvent("json-outline-schema-changed",{bubbles:!0,composed:!0,cancelable:!1,detail:this.manifest}))}async createNode(e){let t=e.detail.values;this.manifest=i.cmsSiteEditor.instance.manifest,this.manifest.items=e.detail,this.manifest.items.forEach(((e,i)=>{if(void 0===e.location){t.id||(t.id=o("item-")),t.location||(t.location="pages/"+t.id+"/index.html");let s=t.location.replace("/index.html","");e.id=t.id,e.location=t.location,e.slug=t.title,e.order=t.order,e.indent=t.indent,e.parent=t.parent,e.description=t.description,e.metadata.created=Math.floor(Date.now()/1e3),e.metadata.updated=Math.floor(Date.now()/1e3),this.shadowRoot.querySelector("#beaker").archive.mkdir(s),this.shadowRoot.querySelector("#beaker").write(t.slug,"<p>My great new content!</p>"),this.manifest.items[i]=e}})),this.shadowRoot.querySelector("#beaker").write("site.json",JSON.stringify(this.manifest,null,2)),i.cmsSiteEditor.instance.shadowRoot.querySelector("#toast").show(`${t.title} created!`),i.cmsSiteEditor.instance.dispatchEvent(new CustomEvent("haxcms-trigger-update",{bubbles:!0,composed:!0,cancelable:!1,detail:!0})),i.cmsSiteEditor.instance.dispatchEvent(new CustomEvent("json-outline-schema-changed",{bubbles:!0,composed:!0,cancelable:!1,detail:this.manifest}))}async saveManifest(e){if(this.manifest=e.detail,"string"==typeof this.manifest.metadata.theme){const e={"haxcms-dev-theme":{element:"haxcms-dev-theme",path:"@haxtheweb/haxcms-elements/lib/haxcms-dev-theme.js",name:"Developer theme"},"outline-player":{element:"outline-player",path:"@haxtheweb/outline-player/outline-player.js",name:"Outline player"},"simple-blog":{element:"simple-blog",path:"@haxtheweb/simple-blog/simple-blog.js",name:"Simple blog"}};e[this.manifest.metadata.theme]&&(this.manifest.metadata.theme=e[this.manifest.metadata.theme])}await this.shadowRoot.querySelector("#beaker").write("site.json",JSON.stringify(this.manifest,null,2)),i.cmsSiteEditor.instance.shadowRoot.querySelector("#toast").show("Site details saved!"),i.cmsSiteEditor.instance.dispatchEvent(new CustomEvent("haxcms-trigger-update",{bubbles:!0,composed:!0,cancelable:!1,detail:!0})),i.cmsSiteEditor.instance.dispatchEvent(new CustomEvent("json-outline-schema-changed",{bubbles:!0,composed:!0,cancelable:!1,detail:this.manifest}))}_jwtTokenFired(e){this.jwt=e.detail,i.jwt=this.jwt,i.cmsSiteEditor&&i.cmsSiteEditor.instance&&(i.cmsSiteEditor.instance.jwt=this.jwt)}disconnectedCallback(){for(var e in this.__disposer)this.__disposer[e].dispose();super.disconnectedCallback()}async connectedCallback(){super.connectedCallback();let e=this.shadowRoot.querySelector("#beaker");this.jwt=e.archive.url;var t=await e.archive.getInfo();if(null!=this.jwt&&"string"==typeof this.jwt&&t.isOwner){var s=JSON.parse(await e.read("appstore.json"));try{import("../haxcms-site-editor.js").then((e=>{i.cmsSiteEditorAvailability(),i.cmsSiteEditor.instance.jwt=this.jwt,i.cmsSiteEditor.instance.appStore=s}),(e=>{}))}catch(e){}}else globalThis.dispatchEvent(new CustomEvent("haxcms-not-logged-in",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}}customElements.define(HAXCMSBackendBeaker.tag,HAXCMSBackendBeaker);export{HAXCMSBackendBeaker};