/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
class HaxLogo extends HTMLElement{get html(){return'\n<style>\n:host {\n  display: block;\n  --hax-logo-letter-spacing: -16px;\n  --hax-logo-font-size: 64px;\n  --hax-logo-inner-font-size: 48px;\n  --hax-logo-innerslot-margin: 8px 4px 4px 4px;\n  --hax-logo-inner-margin: 8px -4px 8px 8px;\n}\n\n:host([hidden]) {\n  display: none;\n}\n:host([toupper]) {\n  text-transform: uppercase;\n}\n\n:host([size="mini"]) {\n  --hax-logo-letter-spacing: -6px;\n  --hax-logo-font-size: 18px;\n  --hax-logo-inner-font-size: 16px;\n  --hax-logo-innerslot-margin: 0px 0px 2px 4px;\n  --hax-logo-inner-margin: 0px 0px 2px 4px;\n}\n\n:host([size="small"]) {\n  --hax-logo-font-size: 36px;\n  --hax-logo-inner-font-size: 28px;\n  --hax-logo-innerslot-margin: 4px 0px 4px 4px;\n  --hax-logo-inner-margin: 4px -4px 4px 8px;\n}\n\n:host([size="large"]) {\n  --hax-logo-font-size: 346px;\n  --hax-logo-inner-font-size: 100px;\n}\n.the {\n  display: none;\n}\n.web {\n  display: none;\n}\n:host([size="large"]) .left {\n  margin-right:-72px;\n}\n:host([size="large"]) .right {\n  margin-left: -44px;\n}\n:host([hide-hax]) .inner,\n:host([hide-hax]) .innerslot {\n  display: none;\n}\n:host([size="large"]) .the {\n  letter-spacing: 20px;\n  margin-left: 20px;\n  text-transform: uppercase;\n  display: inline-block;\n}\n:host([size="large"]) .web {\n  letter-spacing: 20px;\n  margin-left: 20px;\n  text-transform: uppercase;\n  display: inline-block;\n}\n\n.wrap {\n  font-family: \'Press Start 2P\', cursive;\n  font-size: var(--hax-logo-font-size);\n  letter-spacing: var(--hax-logo-letter-spacing);\n  text-align: center;\n}\n.inner {\n  font-size: var(--hax-logo-inner-font-size);\n  display: inline-block;\n  vertical-align: text-top;\n  margin: var(--hax-logo-inner-margin);\n  letter-spacing: -2px;\n}\n.innerslot {\n  font-size: var(--hax-logo-inner-font-size);\n  display: inline-block;\n  vertical-align: text-top;\n  margin: var(--hax-logo-innerslot-margin);\n  letter-spacing: -2px;\n}\n        </style>\n<span class="wrap"><span class="left">&lt;</span><span class="innerslot"><slot name="pre"></slot></span><slot></slot><span class="inner">h-a-x<br><span class="the">the</span><br><span class="web">web</span></bt></span><span class="innerslot"><slot name="post"></slot></span><span class="right">&gt;</span></span>'}static get haxProperties(){return new URL("./lib/hax-logo.haxProperties.json",import.meta.url).href}static get tag(){return"hax-logo"}constructor(){if(super(),!globalThis.__haxLogoFontLoaded&&globalThis.document&&globalThis.document.head){let n=globalThis.document.createElement("link");n.setAttribute("href","https://fonts.googleapis.com/css?family=Press+Start+2P&display=swap"),n.setAttribute("rel","stylesheet"),globalThis.document.head.appendChild(n),globalThis.__haxLogoFontLoaded=!0}this.tag=HaxLogo.tag,this.template=globalThis.document.createElement("template"),this.attachShadow({mode:"open"}),this.render()}connectedCallback(){globalThis.ShadyCSS&&globalThis.ShadyCSS.styleElement(this)}render(){this.shadowRoot.innerHTML=null,this.template.innerHTML=this.html,globalThis.ShadyCSS&&globalThis.ShadyCSS.prepareTemplate(this.template,this.tag),this.shadowRoot.appendChild(this.template.content.cloneNode(!0))}get size(){return this.getAttribute("size")}set size(n){n&&this.setAttribute("size",n)}get toupper(){return this.getAttribute("toupper")}set toupper(n){n&&this.setAttribute("toupper","toupper")}}customElements.define(HaxLogo.tag,HaxLogo);export{HaxLogo};