import{html as e}from"../../lit/index.js";import{DDD as i}from"../d-d-d/d-d-d.js";import{FileSystemBrokerSingleton as t}from"../file-system-broker/file-system-broker.js";import"../simple-icon/lib/simple-icons.js";import"../hax-iconset/lib/simple-hax-iconset.js";import"../simple-icon/lib/simple-icon-button-lite.js";import"../haxcms-elements/lib/core/haxcms-site-builder.js";class HaxCloud extends i{createRenderRoot(){return this}static get tag(){return"hax-cloud"}constructor(){if(super(),this.windowControllers=new AbortController,this.fileRoot="",this.fileObjects=[],!globalThis.__haxLogoFontLoaded){let e=globalThis.document.createElement("link");e.setAttribute("href","https://fonts.googleapis.com/css?family=Press+Start+2P&display=swap"),e.setAttribute("rel","stylesheet"),globalThis.document.head.appendChild(e),globalThis.__haxLogoFontLoaded=!0}globalThis.addEventListener("manifest-changed",this.loadLocalHax.bind(this),{signal:this.windowControllers.signal})}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback&&super.disconnectedCallback()}render(){return e`
      <style>
        simple-icon-button-lite {
          border: 2px solid black;
          border-radius: 0;
          display: inline-flex;
          padding: 16px;
          margin: 0;
          --simple-icon-button-border-radius: 0;
          --simple-icon-width: 100px;
          --simple-icon-height: 100px;
        }
        simple-icon-button-lite::part(button) {
          font-size: 20px;
        }
        simple-icon-button-lite:focus,
        simple-icon-button-lite:hover,
        simple-icon-button-lite:focus-within {
          background-color: #3333ff;
          color: white;
        }
        hax-cloud ol,
        hax-cloud ul {
          margin: 8px;
        }
        hax-cloud li {
          padding: 0;
          margin: 0;
        }
        hax-cloud h1 {
          margin: 0;
          padding: 0;
        }
        hax-cloud h2 {
          padding: 0;
          margin: 0;
        }
        .step-container {
          display: flex;
          flex-direction: row;
          justify-content: center;
        }
        .step {
          border: 2px solid black;
          padding: 16px;
          font-size: 32px;
          display: inline-block;
          width: 30%;
        }
        .step h2,
        .step simple-icon-button-lite {
          display: flex;
        }
        .name-wrapper {
          display: flex;
          margin: 0 auto;
          justify-content: center;
          align-items: center;
          margin: 16px;
        }
        .name-icon {
          --simple-icon-width: 100px;
          --simple-icon-height: 100px;
          display: inline-flex;
          padding: 16px;
        }
        .dot {
          display: inline-flex;
          font-size: 64px;
          font-family: "Press Start 2P", sans-serif;
        }
      </style>
      <main>
        <h1 class="name-wrapper" title="Welcome to HAX.cloud">
          <simple-icon
            icon="hax:hax2022"
            class="name-icon"
            accent-color="deep-purple"
          ></simple-icon>
          <div class="dot" aria-hidden="true">[dot]</div>
          <simple-icon
            icon="cloud"
            class="name-icon"
            accent-color="green"
          ></simple-icon>
        </h1>
        <div class="step-container">
          <details open class="step">
            <summary>Load HAX locally</summary>
            <ol>
              <li>Click Download HAX site (if needed)</li>
              <li>Unzip folder where you manage files on your computer</li>
              <li>Click Select HAX site</li>
              <li>Select The HAX site that you just unzipped in Step 2</li>
              <li>Start editing HAX pages on your local machine!!</li>
            </ol>
          </details>
          <div class="step">
            <h2>Step 1</h2>
            <simple-icon-button-lite
              icon="file-download"
              @click="${this.downloadHAXLatest}"
              >Download HAX site</simple-icon-button-lite
            >
          </div>
          <div class="step">
            <h2>Step 3</h2>
            <simple-icon-button-lite
              icon="folder-open"
              @click="${this.findLocalHaxCopy}"
              >Select HAX site</simple-icon-button-lite
            >
          </div>
        </div>
      </main>
    `}async downloadHAXLatest(){let e=globalThis.document.createElement("a");e.href="https://github.com/elmsln/hax-single-site/archive/refs/heads/main.zip",e.download="hax-single-site.zip",e.click()}async findLocalHaxCopy(){const e=t;this.fileObjects=await e.openDir(!0,{mode:"readwrite"}),await this.fileObjects.forEach((async e=>{if("file"===e.kind&&"site.json"===e.name){let i=await e.handle.getFile(),t=JSON.parse(await i.text());this.fileRoot=e.folder,console.log(t),t&&t.items.length>0&&(globalThis.document.querySelector("haxcms-site-builder").manifest=t)}}))}loadLocalHax(){globalThis.appSettings={login:"dist/dev/login.json",logout:"dist/dev/logout.json",saveNodePath:"dist/dev/saveNode.json",saveManifestPath:"dist/dev/saveManifestPath.json",createNodePath:"dist/dev/saveNode.json",deleteNodePath:"dist/dev/saveNode.json",saveOutlinePath:"dist/dev/saveNode.json",publishSitePath:"dist/dev/saveNode.json",syncSitePath:"dist/dev/saveNode.json",getSiteFieldsPath:"dist/dev/getSiteFieldsPath.json",revertSitePath:"dist/dev/saveNode.json",getFormToken:"adskjadshjudfu823u823u8fu8fij",appStore:{url:new URL("./lib/appstore.json",import.meta.url).href},themes:{"haxcms-dev-theme":{element:"haxcms-dev-theme",path:"@haxtheweb/haxcms-elements/lib/haxcms-dev-theme.js",name:"Developer theme"}}},globalThis.document.querySelector("haxcms-backend-userfs").fileObjects=this.fileObjects,globalThis.document.querySelector("haxcms-backend-userfs").fileRoot=this.fileRoot,globalThis.document.querySelector("haxcms-site-builder").style.display="",setTimeout((()=>{this.remove()}),0)}}customElements.define(HaxCloud.tag,HaxCloud);export{HaxCloud};