import{LitElement as t,html as o,css as e}from"../../../lit/index.js";import{MtzFileDownloadBehaviors as a}from"../../dl-behavior/dl-behavior.js";import{stripMSWord as i,formatHTML as l,b64toBlob as n}from"../../utils/utils.js";import{HAXStore as s}from"./hax-store.js";import"./hax-toolbar.js";import{HaxComponentStyles as r}from"./hax-ui-styles.js";import{autorun as d,toJS as c}from"../../../mobx/dist/mobx.esm.js";import{I18NMixin as h}from"../../i18n-manager/lib/I18NMixin.js";import"../../simple-toolbar/lib/simple-toolbar-menu.js";import"../../simple-toolbar/lib/simple-toolbar-menu-item.js";import"./hax-tray-button.js";import{MicroFrontendRegistry as m}from"../../micro-frontend-registry/micro-frontend-registry.js";class HaxViewSource extends(h(a(t))){static get styles(){return[...r,e`
        :host {
          display: block;
          height: calc(100vh - 120px);
        }
        #wrapper {
          margin: 0;
          padding: 0;
          display: flex;
          flex-direction: column;
          align-items: stretch;
          position: relative;
          flex: 1 1 100%;
        }
        #spacer {
          flex: 1 1 100%;
          z-index: -1;
        }
        #textarea {
          position: absolute;
          top: 0;
          bottom: 0;
          margin: 0;
          padding: 0;
          height: calc(100vh - 200px);
        }
        .updatecontent {
          background-color: var(--ddd-theme-default-coalygray);
          color: var(--ddd-theme-default-opportunityGreen);
        }
        hax-toolbar {
          flex: 0 0 auto;
          background-color: var(--hax-ui-background-color);
        }
        hax-toolbar::part(buttons) {
          display: flex;
          justify-content: center;
          align-items: stretch;
          margin: 0 auto;
        }
        hax-tray-button {
          flex: 1 1 auto;
        }
        simple-toolbar-menu {
          --simple-toolbar-button-border-color: var(--hax-ui-border-color);
        }
        /** This is mobile layout for controls */
        @media screen and (max-width: 800px) {
          hax-tray-button {
            flex: 0 1 auto;
          }
        }
      `]}render(){return o`${this.hidden?"":o` <hax-toolbar>
            <hax-tray-button
              label="${this.t.updateHTML}"
              icon="icons:check"
              @click="${this.updateBodyFromHTML}"
              show-text-label
              icon-position="top"
              class="updatecontent"
            >
            </hax-tray-button>
            <hax-tray-button
              @click="${this.scrubContent}"
              icon="editor:format-clear"
              label="${this.t.cleanFormatting}"
              show-text-label
              icon-position="top"
            >
            </hax-tray-button>
            ${m.has("@core/prettyHtml")?o`
                  <hax-tray-button
                    label="${this.t.PrettifyHtml}"
                    icon="hax:format-textblock"
                    @click="${this.prettifyContent}"
                    show-text-label
                    icon-position="top"
                  >
                  </hax-tray-button>
                `:o``}
            <hax-tray-button
              @click="${this.selectBody}"
              icon="hax:html-code"
              label="${this.t.copyHTML}"
              show-text-label
              icon-position="top"
            >
            </hax-tray-button>
            ${s.revisionHistoryLink?o` <hax-tray-button
                  @click="${this.revisionHistoryClick}"
                  icon="hax:git"
                  label="${this.t.revisionHistory}"
                  show-text-label
                  icon-position="top"
                >
                </hax-tray-button>`:""}

            <simple-toolbar-menu
              icon="icons:file-download"
              icon-position="top"
              label="${this.t.downloadContent}"
              @dblclick="${this.download}"
              show-text-label
            >
              <simple-toolbar-menu-item>
                <hax-tray-button
                  icon="hax:file-html"
                  icon-position="top"
                  label="${this.t.downloadHTML}"
                  @click="${this.download}"
                  show-text-label
                >
                </hax-tray-button>
              </simple-toolbar-menu-item>
              <simple-toolbar-menu-item>
                ${m.has("@core/htmlToDocx")?o`
                      <hax-tray-button
                        label="${this.t.downloadDOCX}"
                        icon="hax:file-docx"
                        @click="${this.downloadDOCXviaMicro}"
                        show-text-label
                        icon-position="top"
                      >
                      </hax-tray-button>
                    `:o`
                      <hax-tray-button
                        label="${this.t.downloadDOCX}"
                        icon="hax:file-docx"
                        @click="${this.downloadDOCX}"
                        show-text-label
                        icon-position="top"
                      >
                      </hax-tray-button>
                    `}
              </simple-toolbar-menu-item>
              ${m.has("@core/htmlToMd")?o`
                    <simple-toolbar-menu-item>
                      <hax-tray-button
                        label="${this.t.downloadMD}"
                        icon="hax:format-textblock"
                        @click="${this.downloadMDviaMicro}"
                        show-text-label
                        icon-position="top"
                      >
                      </hax-tray-button>
                    </simple-toolbar-menu-item>
                  `:o``}
              ${m.has("@core/htmlToPdf")?o`
                    <simple-toolbar-menu-item>
                      <hax-tray-button
                        label="${this.t.downloadPDF}"
                        icon="lrn:pdf"
                        @click="${this.downloadPDFviaMicro}"
                        show-text-label
                        icon-position="top"
                      >
                      </hax-tray-button>
                    </simple-toolbar-menu-item>
                  `:o``}
              <simple-toolbar-menu-item>
                <hax-tray-button
                  @click="${this.htmlToHaxElements}"
                  label="${this.t.haxSchema}"
                  icon="hax:code-json"
                  show-text-label
                  icon-position="top"
                ></hax-tray-button>
              </simple-toolbar-menu-item>
            </simple-toolbar-menu>
          </hax-toolbar>
          <div id="wrapper">
            <div id="spacer"></div>
            <textarea id="hiddentextarea" hidden></textarea>
            <code-editor
              id="textarea"
              theme="${"hax"==this.haxUiTheme?"vs":"haxdark"==this.haxUiTheme?"vs-dark":"auto"}"
              language="html"
              font-size="13"
              word-wrap
            ></code-editor>
          </div>`} `}static get tag(){return"hax-view-source"}refreshHTMLEditor(t){this.updateEditor()}async download(t){const o=await this.contentToFile(!1);this.downloadFromData(o,"html","my-new-code"),s.toast(this.t.fileDownloaded),this.close()}async downloadDOCX(t){import("../../file-system-broker/lib/docx-file-system-broker.js").then((async t=>{let o=await s.activeHaxBody.haxToContent();globalThis.DOCXFileSystemBroker.requestAvailability().HTMLToDOCX(o,globalThis.document.title),s.toast(this.t.fileDownloaded),this.close()}))}async downloadDOCXviaMicro(t){let o=await s.activeHaxBody.haxToContent();const e=await m.call("@core/htmlToDocx",{html:o});if(200==e.status){const t=globalThis.document.createElement("a");t.href=globalThis.URL.createObjectURL(n(`${e.data}`,"application/vnd.openxmlformats-officedocument.wordprocessingml.document")),t.download="PageContents.docx",t.target="_blank",this.appendChild(t),t.click(),this.removeChild(t),s.toast(this.t.fileDownloaded),this.close()}}async downloadMDviaMicro(t){let o=await s.activeHaxBody.haxToContent();const e=await m.call("@core/htmlToMd",{html:o});if(200==e.status&&e.data){const t=globalThis.document.createElement("a");t.href=globalThis.URL.createObjectURL(n(btoa(e.data),"text/markdown")),t.download="PageContents.md",t.target="_blank",this.appendChild(t),t.click(),this.removeChild(t),s.toast(this.t.fileDownloaded),this.close()}}async downloadPDFviaMicro(t){let o=await s.activeHaxBody.haxToContent();var e="";globalThis.document.querySelector("base")&&(e=globalThis.document.querySelector("base").href);const a=await m.call("@core/htmlToPdf",{base:e,html:o});if(200==a.status&&a.data){const t=globalThis.document.createElement("a");t.href=globalThis.URL.createObjectURL(n(a.data,"application/pdf")),t.download="PageContents.pdf",t.target="_blank",this.appendChild(t),t.click(),this.removeChild(t),s.toast(this.t.fileDownloaded),this.close()}}async downloadfull(t){const o=await this.contentToFile(!0);this.downloadFromData(o,"html","my-new-webpage"),s.toast(this.t.fileDownloaded),this.close()}async updateBodyFromHTML(t){let o=this.shadowRoot.querySelector("#textarea").value,e="slot"===s.activeHaxBody.shadowRoot.querySelector("#body").localName?s.activeHaxBody.shadowRoot.querySelector("#body").assignedNodes({flatten:!0}):[];if(e.length>0&&"PAGE-BREAK"===e[0].tagName&&!o.includes("<page-break")){o=await s.nodeToContent(e[0])+"\n"+o}s.activeHaxBody.importContent(o),s.haxTray.trayDetail=""}scrubContent(t){const o=this.shadowRoot.querySelector("#textarea").value;s.toast("Scrubbed, Content updated"),s.activeHaxBody.importContent(i(o)),this.close()}async prettifyContent(t){let o=await s.activeHaxBody.haxToContent();const e=await m.call("@core/prettyHtml",{html:o});200==e.status&&(this.shadowRoot.querySelector("#textarea").editorValue="",setTimeout((()=>{const t=e.data.replace(/^\s+|\s+$/gm,"");this.shadowRoot.querySelector("#textarea").editorValue=t}),0));const a=this.shadowRoot.querySelector("#textarea").value;s.toast("Formatting updated, Content updated"),s.activeHaxBody.importContent(a)}openSource(){globalThis.customElements.get("code-editor")?setTimeout((()=>{this.updateEditor()}),1e3):import("../../code-editor/code-editor.js").then((()=>{this.updateEditor(),setTimeout((()=>{this.updateEditor()}),1e3)}))}revisionHistoryClick(){s.revisionHistoryLink&&globalThis.open(s.revisionHistoryLink,"_blank")}selectBody(t){let o=this.shadowRoot.querySelector("#hiddentextarea");o.value=this.shadowRoot.querySelector("#textarea").value,o.removeAttribute("hidden"),o.focus(),o.select(),globalThis.document.execCommand("copy"),o.setAttribute("hidden","hidden"),s.toast(this.t.copiedToClipboard)}async htmlToHaxElements(t){let o=await s.activeHaxBody.haxToContent(),e=await s.htmlToHaxElements(o);e.shift();var a=JSON.stringify(e,null,2);let i=this.shadowRoot.querySelector("#textarea").value,l=this.shadowRoot.querySelector("#hiddentextarea");l.removeAttribute("hidden"),l.value=a,l.focus(),l.select(),globalThis.document.execCommand("copy"),l.value=i,l.setAttribute("hidden","hidden"),s.toast(this.t.copiedToClipboard),this.close()}close(){s.haxTray.trayDetail=""}updateEditor(){s.activeHaxBody&&this.shadowRoot&&this.shadowRoot.querySelector("#textarea")&&(this.shadowRoot.querySelector("#textarea").editorValue="",setTimeout((async()=>{const t=l(await s.activeHaxBody.haxToContent());this.shadowRoot.querySelector("#textarea").editorValue=t}),0))}async contentToFile(t){let o=await s.activeHaxBody.haxToContent();var e=o;return t&&(e=`\n        <!DOCTYPE html>\n        <html lang="en">\n          <head>\n            <meta charset="utf-8" />\n            <meta\n              name="viewport"\n              content="width=device-width, minimum-scale=1, initial-scale=1, user-scalable=yes"\n            />\n            <title>hax-body demo</title>\n            <script>globalThis.WCGlobalCDNPath="https://cdn.webcomponents.psu.edu/cdn/"; <\/script> <script src="https://cdn.webcomponents.psu.edu/cdn/build.js"><\/script> \n            <style>\n              body {\n                padding: 32px;\n              }\n            </style>\n          </head>\n          <body>\n          ${o}\n          </body>\n        </html>\n      `),e}static get properties(){return{...super.properties,globalPreferences:{type:Object},hidden:{type:Boolean,reflect:!0},theme:{type:String}}}constructor(){super(),this.t={updateHTML:"Update HTML",copyHTML:"Copy HTML",downloadContent:"Download content",downloadHTML:"Download HTML",fileDownloaded:"File downloaded",downloadDOCX:"Download DOCX",downloadMD:"Download Markdown",downloadPDF:"Download PDF",PrettifyHtml:"Prettify HTML",cleanFormatting:"Clean Formatting",haxSchema:"HAXSchema",revisionHistory:"Revision history"},this.registerLocalization({context:this,namespace:"hax"}),d((()=>{this.globalPreferences=c(s.globalPreferences),this.haxUiTheme=(this.globalPreferences||{}).haxUiTheme||"hax"}))}}customElements.define(HaxViewSource.tag,HaxViewSource);export{HaxViewSource};